<?php
namespace App\Classes;

class FluentdService {
    private $fluentdUrl;
    private $usuario = 'logscurl';
    private $senha = 'sa123';
    private $MATCH_INDEX = 'logscurl';

    public function __construct($host, $port) {
        $this->fluentdUrl = "http://$host:$port/$this->MATCH_INDEX";
        $this->usuario = $this->usuario;
        $this->senha = $this->senha;
    }

    private function enviarLog($nivel, $evento, $mensagem) {
        $data = [
            "level" => $nivel,
            "event" => $evento,
            "message" => $mensagem,
            "timestamp" => date(DATE_ISO8601)  // Inclui timestamp ISO 8601
        ];

        $jsonData = json_encode($data);

        $ch = curl_init($this->fluentdUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json'
        ]);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);

        if ($this->usuario && $this->senha) {
            curl_setopt($ch, CURLOPT_USERPWD, "$this->usuario:$this->senha");
        }

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($httpCode === 200) {
            return true;
        } else {
            return false;
        }
    }

    // Métodos específicos para cada nível de log
    public function info($evento, $mensagem) {
        return $this->enviarLog('info', $evento, $mensagem);
    }

    public function warning($evento, $mensagem) {
        return $this->enviarLog('warning', $evento, $mensagem);
    }

    public function error($evento, $mensagem) {
        return $this->enviarLog('error', $evento, $mensagem);
    }

    public function debug($evento, $mensagem) {
        return $this->enviarLog('debug', $evento, $mensagem);
    }
}

// Exemplo de uso:
$fluentd = new FluentdService('localhost', 8082);

// Enviar logs em diferentes níveis
// $fluentd->info("asdfasdfuser_login", "Usuário john_doe fez login.");
// $fluentd->warning("1api_request", "Requisição lenta detectada.");
// $fluentd->error("1db_connection", "Falha ao conectar ao banco de dados.");
// $fluentd->debug("1cache_hit", "Cache hit para chave xyz.");