<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Client;
use App\Usedavailablelimit;

class AvailablelimitInterestCharger extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:availablelimitinterestcharger';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $limitesUtilizados = Usedavailablelimit::where('paid','=',0)->get();

        $hoje = now();

        foreach($limitesUtilizados as $lim) {

            $dias = daysBetweenDates($hoje, $lim->emission);

            if($dias == 0) continue;

            //$saldoCliente = getClientBalance($lim->taxnumber);
            //if($saldoCliente >= $lim->interestvalue) {
                $pagar = $this->realizaPagamento($lim->id, $lim->client_id,$lim->taxnumber, $lim->interestvalue, $hoje);
            //}
        }
    }

    public function realizaPagamentoTST($usedlimit_id,$client_id,$taxnumber,$interestvalue,$hoje) {
        // CONSULTA O SALDO DO CLIENTE
        $saldoCliente = saldoCliente($taxnumber);
        $saldoCompensar = getAvailableLimitMultiCnpj($taxnumber);
        $saldoDisponivel = $saldoCliente + $saldoCompensar;

        $utilizado = Usedavailablelimit::where('id','=',$usedlimit_id)->first();
        $taxaAPagar = $utilizado->interestvalue;

        if ($saldoCliente >= $taxaAPagar) {

            return 0;

        } else {

            // TST
            $saldoCliente = 0;

            $valorAdiantar = ($taxaAPagar - $saldoCliente);
            // ao saldo a transferir deve ser adicionada a taxa
            $cashbackvalue = consultaTaxaCliente($client_id, 'internaltransfer', $valorAdiantar);

            // verifica se o cliente possui saldo total suficiente
            if( $saldoDisponivel < ($taxaAPagar + $cashbackvalue) ) {

                return 0;

            } else {
                // provisionar SEM cashback, pois ficará no adiantamento
                $provisionamentoId = realizaProvisionamento_Zane($usedlimit_id, $taxaAPagar, 0, $hoje);

                // adiantar o complemento
                // - transfere da conta mãe para cliente
                $transfereSaldoDisponivel = transfereSaldoDisponivelCliente($taxnumber, $valorAdiantar, 'Transferencia de saldo a compensar', $cashbackvalue, 0);
                if(!$transfereSaldoDisponivel) return 0;
                // - incluit o adiantamento no saldo devedor (usedavailabellimits)
                $provisionamento = Usedavailablelimit::where('id','=',$provisionamentoId)->first();
                $user_id = $provisionamento->user_id;
                $client_id = $provisionamento->client_id;
                $taxnumber = $provisionamento->taxnumber;
                $availablelimit = 0;
                $requestedvalue = $valorAdiantar;
                $transactiontype = 'PAGAMENTO TAXA';
                $random2dig = str_pad(random_int(0, 99), 2, "0", STR_PAD_LEFT);
                $documentnumber = 'SpsPagto_' . $provisionamentoId . "_" . $random2dig;
                $logid = false;
                $internaltransferdocumentnumber = 0;
                $ratevalue = $cashbackvalue;
                $limitusedID = logAvailableLimitUsed($user_id, $client_id, $taxnumber, $availablelimit, $requestedvalue, $transactiontype, $documentnumber, $logid, $internaltransferdocumentnumber, $ratevalue);

                // TODO pagar provisionamento (apagando o cashback)
                // pagar taxa
                $pagamento = transfereClienteParaSps($taxnumber, $taxaAPagar, 'Pagamento de taxa adiantamento de saldo', 0);
                if(!$pagamento) {
                    return 0;
                } else  {
                    // TODO apagar o cashback do provisionamento
                    $provisionado = Usedavailablelimit::where('id','=',$provisionamentoId)->first();
                    $provisionado->paymentvalue += $taxaAPagar;
                    $provisionado->documentnumber = $pagamento;
                    $provisionado->paymentdate = $hoje;
                    $provisionado->paid = 1;
                    $provisionado->update();
                    return $pagamento;
                }
            }
        }
    }

    // ZANE
    public function realizaPagamento($usedlimit_id,$client_id,$taxnumber,$interestvalue,$hoje) {

        // CONSULTA O SALDO DO CLIENTE
        $saldoCliente = saldoCliente($taxnumber);
        $saldoCompensar = getAvailableLimitMultiCnpj($taxnumber);
        $saldoDisponivel = $saldoCliente + $saldoCompensar;

        $utilizado = Usedavailablelimit::where('id','=',$usedlimit_id)->first();
        $taxaAPagar = $utilizado->interestvalue;

        if ($saldoCliente >= $taxaAPagar) {
            // provisionar sem cashback
            $provisionamentoId = realizaProvisionamento_Zane($usedlimit_id, $taxaAPagar, 0, $hoje);
            // pagar provisionamento
            $pagamento = transfereClienteParaSps($taxnumber, $taxaAPagar, 'Taxa adiantamento de saldo', 0);
            if($pagamento) {
                $provisionado = Usedavailablelimit::where('id','=',$provisionamentoId)->first();
                $provisionado->paymentvalue += $taxaAPagar;
                $provisionado->paymentdate = $hoje;
                $provisionado->documentnumber = $pagamento;
                $provisionado->paid = 1;
                $provisionado->update();
            }
            return $pagamento;

        } else {

            $valorAdiantar = ($taxaAPagar - $saldoCliente);
            // ao saldo a transferir deve ser adicionada a taxa
            $cashbackvalue = consultaTaxaCliente($client_id, 'internaltransfer', $valorAdiantar);

            // verifica se o cliente possui saldo total suficiente
            if( $saldoDisponivel < ($taxaAPagar + $cashbackvalue) ) {
                // provisionar COM cashback proporcional
                $provisionamentoId = realizaProvisionamento_Zane($usedlimit_id, $taxaAPagar, $cashbackvalue, $hoje);
                // se saldo cliente > 0, usa o saldo real para pagar parcial
                if ($saldoCliente > 0) {
                    $pagamento = transfereClienteParaSps($taxnumber, $saldoCliente, 'Taxa parcial adiantamento de saldo', 0);
                    $provisionado = Usedavailablelimit::where('id','=',$provisionamentoId)->first();
                    $provisionado->paymentvalue += $saldoCliente;
                    $provisionado->documentnumber = $pagamento;
                    $provisionado->paymentdate = $hoje;
                    $provisionado->update();
                    return $pagamento;

                }
                return 0;

            } else {
                // provisionar SEM cashback, pois ficará no adiantamento
                $provisionamentoId = realizaProvisionamento_Zane($usedlimit_id, $taxaAPagar, 0, $hoje);

                // adiantar o complemento
                // - transfere da conta mãe para cliente
                $transfereSaldoDisponivel = transfereSaldoDisponivelCliente($taxnumber, $valorAdiantar, 'Transferencia de saldo a compensar', $cashbackvalue, 0);
                if(!$transfereSaldoDisponivel) return 0;
                // - incluit o adiantamento no saldo devedor (usedavailabellimits)
                $provisionamento = Usedavailablelimit::where('id','=',$provisionamentoId)->first();
                $user_id = $provisionamento->user_id;
                $client_id = $provisionamento->client_id;
                $taxnumber = $provisionamento->taxnumber;
                $availablelimit = 0;
                $requestedvalue = $valorAdiantar;
                $transactiontype = 'PAGAMENTO TAXA';
                $random2dig = str_pad(random_int(0, 99), 2, "0", STR_PAD_LEFT);
                $documentnumber = 'SpsPagto_' . $provisionamentoId . "_" . $random2dig;
                $logid = false;
                $internaltransferdocumentnumber = 0;
                $ratevalue = $cashbackvalue;
                $limitusedID = logAvailableLimitUsed($user_id, $client_id, $taxnumber, $availablelimit, $requestedvalue, $transactiontype, $documentnumber, $logid, $internaltransferdocumentnumber, $ratevalue);

                // TODO pagar provisionamento (apagando o cashback)
                // pagar taxa
                $pagamento = transfereClienteParaSps($taxnumber, $taxaAPagar, 'Pagamento de taxa adiantamento de saldo', 0);
                if(!$pagamento) {
                    return 0;
                } else  {
                    // TODO apagar o cashback do provisionamento
                    $provisionado = Usedavailablelimit::where('id','=',$provisionamentoId)->first();
                    $provisionado->paymentvalue += $taxaAPagar;
                    $provisionado->documentnumber = $pagamento;
                    $provisionado->paymentdate = $hoje;
                    $provisionado->paid = 1;
                    $provisionado->update();
                    return $pagamento;
                }
            }
        }
    }

    // ##### DEPRECATED out/21 #####
    // ZANE + ROBSON
    public function realizaPagamento_ZaneRobson($usedlimit_id,$client_id,$taxnumber,$interestvalue,$hoje) {

        // CONSULTA O SALDO DO CLIENTE
        $saldoCliente = saldoCliente($taxnumber);
        $saldoCompensar = getAvailableLimitMultiCnpj($taxnumber);
        $saldoDisponivel = $saldoCliente + $saldoCompensar;

        $utilizado = Usedavailablelimit::where('id','=',$usedlimit_id)->first();
        $taxaAPagar = $utilizado->interestvalue;

        if ($saldoCliente >= $taxaAPagar) {
           // pagar taxa
            $pagamento = transfereClienteParaSps($taxnumber, $taxaAPagar, 'Taxa adiantamento de saldo', 0);

            if($pagamento) {
                $utilizado = Usedavailablelimit::where('id','=',$usedlimit_id)->first();
                $utilizado->paymentdate = $hoje;
                $utilizado->update();
            }

            return $pagamento;

        } else {

            $valorAdiantar = ($taxaAPagar - $saldoCliente);
            // ao saldo a transferir deve ser adicionada a taxa
            $cashbackvalue = consultaTaxaCliente($client_id, 'internaltransfer', $valorAdiantar);

            // verifica se o cliente possui saldo total suficiente
            if( $saldoDisponivel < ($taxaAPagar + $cashbackvalue) ) {
                return 0;

            } else {
                // adiantar o complemento
                $transfereSaldoDisponivel = transfereSaldoDisponivelCliente($taxnumber, $valorAdiantar, 'Transferencia de saldo a compensar', $cashbackvalue, 0);
                if(!$transfereSaldoDisponivel) return 0;

                // pagar taxa
                $pagamento = transfereClienteParaSps($taxnumber, $taxaAPagar, 'Taxa adiantamento de saldo', 0);

                if($pagamento) {
                    $utilizado = Usedavailablelimit::where('id','=',$usedlimit_id)->first();
                    $utilizado->paymentdate = $hoje;
                    $utilizado->update();
                    return $pagamento;
                } else  {
                    return 0;
                }

            }

        }

    }

    public function realizaPagamento_Helder($usedlimit_id,$client_id,$taxnumber,$interestvalue,$hoje) {
        $client = Client::where('id','=',$client_id)->first();

        $pagamento = transfereClienteParaSps($taxnumber, $interestvalue, 'juros adiantamento de saldo', 0);

        if($pagamento) {
            $utilizado = Usedavailablelimit::where('id','=',$usedlimit_id)->first();
            $utilizado->paymentdate = $hoje;
            $utilizado->paid = 1;
            $utilizado->update();
        }

        return $pagamento;
    }
}
