<?php

namespace App\Console\Commands;

use App\Mail\EnviaMailAnexo;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Mail;
use Tymon\JWTAuth\Claims\Subject;

class GeraRelatorioLogsCurl extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:gerarelatoriologscurl';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Relatório de logs de requisições api fitbank';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->limparLog();
        $this->logsCurlReport();
        $this->sendEmail();
    }

    public function logsCurlReport()
    {

        $logscurl = DB::table('logscurl')
            ->select('id', 'taxnumber as cnpj','datasent as request')
            ->whereDate('created_at', '=', DB::raw('CURDATE()'))
            ->whereNull('datareceived')
            ->get()
            ->toArray();


        $filepath = storage_path('logs/relatorios/logscurl.csv');
        $header = ["id, cnpj, request, response"];

        $body = array_map(function ($log) {
            return implode(',', (array) $log);
        }, (array) $logscurl);

        $csv = array_merge($header, $body);
        file_put_contents($filepath, implode("\n", $csv));


    }

    public function limparLog()
    {
        $logFile = storage_path('logs/relatorios/logscurl.csv');
        if (file_exists($logFile)) {
            File::delete($logFile);
        }
    }

    public function sendEmail()
    {
        $filePath = storage_path('logs/relatorios/logscurl.csv');
        $destinatario = 'sistemas@smartsafebrasil.com.br';
        $from = 'naoresponda@ssgbank.com.br';
        $subject = 'Relatório de erros de requisições api fitbank';
        $message = 'Relatório de erros de requisições api fitbank em anexo.';

        Mail::send(new EnviaMailAnexo($from, $destinatario, $subject, $message, $filePath));
    }

}
