<?php

namespace App\Console\Commands;

use App\Classes\ClientSPS\ClientSpsService;
use Illuminate\Console\Command;
use App\Usedavailablelimit;

class PagarLimitesUtilizados extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:pagarlimitesutilizados';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Rotina que efetua o pagamento de todos os limites utilizados que estão em aberto, sejam eles adiantamento de saldo a compensar ou provisionamento';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $menorValorSaldoReal = 0.5;

        $clientesComLimitesUtilizadosNaoPagos = Usedavailablelimit::selectRaw("DISTINCT taxnumber")
            ->where('paid', '=', 0)
            ->whereDate('duedate', '<=', date('Y-m-d', strtotime('+1 days')) . ' 23:59:59')
            ->get();

        foreach($clientesComLimitesUtilizadosNaoPagos as $cliente) {

            $clienteSpsService = new ClientSpsService($cliente->taxnumber);
            $saldoRealAtualizado = $clienteSpsService->__get('saldoReal');

            $limitesUtilizadosNaoPagos = Usedavailablelimit::where('paid', '=', 0)
                ->whereDate('duedate', '<=', date('Y-m-d') . ' 23:59:59')
                ->where('taxnumber', '=', $cliente->taxnumber)
                ->orderBy('emission', 'asc')
                ->get();

            if ($saldoRealAtualizado <= $menorValorSaldoReal) {
                continue;
            }

            foreach($limitesUtilizadosNaoPagos as $objLimite) {

                $array = prepararSaldoParaPagamentoLimitesUtilizados($objLimite, true);

                finalizarPagamentoLimitesUtilizados($objLimite, $array['valorATransferirParaSPS'], $array['valorProvisionado']);

                $saldoRealAtualizado = $clienteSpsService->__get('saldoReal');

                // Definir o limite para pausar o provisionamento
                if ($saldoRealAtualizado <= $menorValorSaldoReal) {
                    break;
                }
            }
        }
    }

}
