<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

use App\Usedavailablelimit;

class PagarMensalidades extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:pagarmensalidades';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Realiza o pagamento das mensalidades';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $mensalidadesAPagar = Usedavailablelimit::where([
                'paid' => 0,
                'transactiontype' => 'MENSALIDADE'
            ])
            ->whereDate('duedate', '<=', date('Y-m-d') . ' 23:59:59')
            ->orderBy('emission', 'asc')
            ->get();

        foreach($mensalidadesAPagar as $objLimite) {

            $arrayValores = prepararSaldoParaPagamentoLimitesUtilizados($objLimite, false);

            finalizarPagamentoLimitesUtilizados($objLimite, $arrayValores['valorATransferirParaSPS'], $arrayValores['valorProvisionado'], 'Débito de Mensalidade');

        }

    }
}
