<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        'App\Console\Commands\LancarMensalidades',
        'App\Console\Commands\PagarMensalidades',
        'App\Console\Commands\PagarLimitesUtilizados',
        'App\Console\Commands\DatabaseBackUp',
        'App\Console\Commands\AvailablelimitInterestCalculator',
        'App\Console\Commands\AvailablelimitInterestCharger',
        'App\Console\Commands\AgendarDxAutomatico',
        'App\Console\Commands\ExecutarDxAutomatico',
        'App\Console\Commands\ChangeFromClientToMultisafe',
        'App\Console\Commands\ChangeClientOfMultisafe',
    ];

    /**
     * Define the application's command schedule.
     *
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        // * * * * * cd /Users/helder/Sites/sps && php artisan schedule:run >> /dev/null 2>&1
        $schedule->command('database:backup')
            ->twiceDaily(8, 20)
            ->appendOutputTo(storage_path('logs/backup.log'));

        /* Novos Agendamentos solicitados por Operaçoes
        */
        $schedule->command('command:agendardxautomatico')
            ->weekdays()
            ->hourlyAt(01)
            ->between('00:00', '01:00');

        $schedule->command('command:executardxautomatico')
            ->weekdays()
            ->hourlyAt(05)
            ->between('00:00', '01:00');


        $schedule->command('command:agendardxautomatico')
            ->weekdays()
            ->hourlyAt(30)
            ->between('08:00', '15:00')
            ->timezone('America/Sao_Paulo');

        $schedule->command('command:executardxautomatico')
            ->weekdays()
            ->hourly()
            ->between('09:00', '19:05')
            ->timezone('America/Sao_Paulo');

        $schedule->command('command:gerarrelatoriodxautomatico')
            ->weekdays()
            ->hourlyAt(35)
            ->between('09:00', '16:00')
            ->timezone('America/Sao_Paulo');

        $schedule->command('command:gerarelatoriologscurl')
            ->weekdays()
            ->hourlyAt(40)
            ->between('08:00', '19:00')
            ->timezone('America/Sao_Paulo');
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
