<?php namespace App\Exports;

use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use App\Http\Controllers\SpsinfoController;
use App\Client;

class ReportExport implements FromView
{
    protected $SpsinfoController;
    // public function __construct(SpsinfoController $SpsinfoController)
    // {
    //     $this->SpsinfoController = $SpsinfoController;
    // }

    private $client_id;

    public function __construct(String $datade, String $dataate, int $client_id, int $mensalidade) 
    {
        $this->datade = $datade;
        $this->dataate = $dataate;
        $this->client_id = $client_id;
        $this->mensalidade = $mensalidade;
    }

    public function view(): View
    {
        $q_listclients = Client::select('id','name')->orderBy('name','ASC');

        if($this->client_id != '')
                $q_listclients->where('id','=',$this->client_id);

        $listclients = $q_listclients->get();

        $relatorio = [];

        $sps = getSPS();

        foreach($listclients as $cli) {

            $relatorio[] = [ "client" => $cli->name, 
                                "report" => SpsinfoController::relatoriosSimples(['datade'=>$this->datade, 'dataate'=>$this->dataate, 'client_id' => $cli->id, 'mensalidade' => $this->mensalidade])
                        ];
            
        }

        // $relatorio = SpsinfoController::relatoriosComparativos(['filtromes'=>'06', 'filtroano'=>'2020', 'client_id' => '']);
        return view('sps.export_xls_simples', [
            'relatorio' => $relatorio
        ]);
    }
}