<?php namespace App\Http\Controllers;

use App\Client;
use App\Gpspayment;
use JWTAuth;
use Tymon\JWTAuth\Exceptions\JWTException;

use Illuminate\Http\Request;

class ApiGpsController extends Controller
{
    /** *****************************************
     ********************************************
     *                  GPS
     ********************************************
     ********************************************
    */

    public function consultaGps(Request $request)
    {
        
        $results = $this->queryResults($request,new Gpspayment);

        $listitens = [];

        foreach($results['object'] as $item) {
            $listitens[] = [
                    'id' => $item->id,
                    'duedate' => detectDateFormatOutputDateBr($item->duedate),
                    'principalvalue' => formatMoneyBr($item->principalvalue),
                    'fineinterestvalue' => formatMoneyBr($item->fineinterestvalue),
                    'othervalues' => formatMoneyBr($item->othervalues),
                    'totalvalue' => formatMoneyBr($item->totalvalue),
                    'paymentdate' => detectDateFormatOutputDateBr($item->paymentdate),
                    'status' => traduzStatusApi($item->status),
                    'identifier' => $item->identifier,
                    'documentnumber' => $item->documentnumber,
                    'contributortaxnumber' => formataCNPJ($item->contributortaxnumber),
                    'paymentauthentication' => replaceNullValueWithEmptyString($item->paymentauthentication),
                    'receipturl' => replaceNullValueWithEmptyString($item->receipturl)
            ];
        }

        return response()->json(
            [
                "success" => true,
                "data" =>[
                            "resposta" => $listitens,
                            "filtro" => $results['filtro'],
                            "itens" => $results['object']->count()
                        ],
            ]
        );
    }

    public function queryResults($request, $tipo) {
        $userInfo = JWTAuth::user();
        $client = Client::select('clients.*')->where('id','=',$userInfo->client_id)->first();
        
        if ($request->input('datade') != ''  && $request->input('dataate') != '') {
            $datade  = date2us($request->input('datade'));
            $dataate = date2us($request->input('dataate')); 
        } else {
            $datade  = date('Y-m-d', strtotime('-15 days'));
            $dataate = date('Y-m-d');   
        }

        $q_sql = $tipo->where('client_id','=',$userInfo->client_id)
                            ->whereDate('emission','>=',$datade)
                            ->whereDate('emission','<=',$dataate);

        if(isset($request) && $request->input('filtrostatus') != '')
            $q_sql->where('status','=',$request->input('filtrostatus'));


        $results = $q_sql->orderBy('created_at','desc')->get();

        $filtrostatus  = (isset($request) && $request->input('filtrostatus') != '')?$request->input('filtrostatus'):'';

        $filtro = array('datade'=>dataUs2Br($datade),'dataate'=>dataUs2Br($dataate), 'filtrostatus'=>$filtrostatus);

        return ["object"=>$results,"filtro"=>$filtro];
    }


    /* ******************************************************
       ******************************************************
        
        SUBMITS

       ******************************************************
       ****************************************************** */

    public function enviaGps(Request $request) {
        $userInfo = JWTAuth::user();
        $client = getClientById($userInfo->client_id);

        // CONSULTA O SALDO DO CLIENTE
        $saldoCliente = saldoCliente($client->taxnumber);
        $saldoDisponivel = $client->availablelimit;
        // valor a ser transferido
        $valor = covert2Float($request->input('totalvalue'));
        $logLimitUsed = false;

        $saldoCompensar = 0;
        $saldoCompensarValor = 0;
        $internaltransferdocumentnumber = 0;
        $cashbackvalue = 0;

        $cli_ratevalue = consultaTaxaCliente($client->id, 'payment', covert2Float($request->input('principalvalue')));
        
        // verifica se o disponível é >= valor a ser transferido
        if($valor > $saldoCliente) {
            // se não for, verifica se permite usar saldo a compensar
            if( $request->input('limiteespecial') == 'Sim' ) {

                // saldo a transferir para completar o pagamento
                $saldoATransferir = ($valor - $saldoCliente);

                // ao saldo a transferir deve ser adicionada a taxa
                $cashbackvalue = consultaTaxaCliente($client->id, 'internaltransfer', $saldoATransferir);

                // verifica se o cliente possui saldo a compensar suficiente
                if( ($saldoCliente + $saldoDisponivel) < ($valor + $cashbackvalue + $cli_ratevalue) ) {
                    return response()->json(["success" => false,"message" => "Não há saldo suficiente para realizar a operação."]);
                } else {
                    // realiza a transferencia do valor adicional para o cliente
                    $transfereSaldoDisponivel = transfereSaldoDisponivelCliente($client->taxnumber, ( $saldoATransferir + $cashbackvalue), 'Transferencia de saldo a compensar', $cashbackvalue, $cli_ratevalue);

                    if(!$transfereSaldoDisponivel) return response()->json(["success" => false,"message" => "Ocorreu um erro ao realizar a operação. Por favor tente mais tarde."]);

                    // $logLimitUsed = logAvailableLimitUsed(Auth::user()->id, $client->id, $client->taxnumber, $client->availablelimit, $saldoATransferir, 'DARF', '0', false); // salva detalhamento
                    $logLimitUsed = true;
                    $saldoCompensar = 1;
                    $saldoCompensarValor = $saldoATransferir;
                    $internaltransferdocumentnumber = $transfereSaldoDisponivel;
                }
            } else {
                return response()->json(["success" => false,"message" => "Não há saldo suficiente para realizar a operação."]);
            }
        }
        // /CONSULTA O SALDO DO CLIENTE

        $newIdentifier = concatIdentifier($request->input('identifier'));

        

        $spsInfo = getSPS();

        $curlParams = "{ \"Method\": \"GeneratePaymentGPS\",
                    \"PartnerId\": ".$spsInfo->partnerid.",
                    \"BusinessUnitId\": ".$spsInfo->businessunitid.",
                    \"TaxNumber\": \"".somenteNumeros($client->taxnumber)."\",
                    \"ContributorTaxNumber\": \"".somenteNumeros($request->input('contributortaxnumber'))."\",
                    \"PrincipalValue\": ".covert2Float($request->input('principalvalue')).",
                    \"FineInterestValue\": ".covert2Float($request->input('fineinterestvalue')).",
                    \"OtherValues\": ".covert2Float($request->input('othervalues')).",
                    \"RateValue\": \"".$cli_ratevalue."\",
                    \"PaymentDate\": \"".dataSlashReverse($request->input('paymentdate'))."\",
                    \"DueDate\": \"".dataSlashReverse($request->input('duedate'))."\",
                    \"Tags\": [],
                    \"RateValueType\": \"1\",
                    \"Description\": \"".$request->input('description')."\",
                    \"Identifier\": \"".$newIdentifier."\",
                    \"PaymentCode\": \"".$request->input('paymentcode')."\",
                    \"ReferenceNumber\": \"".somenteNumeros($request->input('referencenumber'))."\",
                    \"JurisdictionDate\": \"".somenteNumeros($request->input('jurisdictiondate'))."\"
                }";

        $enviar = sendCurl($curlParams);

        if($enviar["Success"] == "false") {
            $validacao = (isset($enviar['Validation']))?serialize($enviar['Validation']):'';
            $mensagem = (isset($enviar['Message']))?$enviar['Message']:'';
            saveTransferErrorLog('GeneratePaymentGPS', $curlParams, $mensagem, $validacao);

            return response()->json(["success" => false,"message" => "Erro: ocorreu um problema ao processar a requisição. Por favor tente mais tarde."]);
        }

        $documentnumber = (isset($enviar['DocumentNumber']))?$enviar['DocumentNumber']:'0';
        $alreadyexists = (isset($enviar['AlreadyExists']))?1:0;

        $checkDocnumber = $this->checkExists($documentnumber);

        if(!$checkDocnumber) {
            $viewStatus = 'status';
            $viewMessage = 'Documento enviado.';
            $this->saveGpsLog(somenteNumeros($client->taxnumber),$request, $curlParams,$documentnumber,$alreadyexists, 0, $newIdentifier,$saldoCompensar,$saldoCompensarValor);

            if($logLimitUsed) logAvailableLimitUsed($userInfo->id, $client->id, $client->taxnumber, $client->availablelimit, $saldoATransferir, 'GPS', $documentnumber, false, $internaltransferdocumentnumber, $cashbackvalue); // atualiza detalhamento
        } else {
            $viewStatus = 'danger';
            $viewMessage = 'O documento já foi enviado anteriormente!';
        }

        return response()->json(["success" => true,"message" => $viewMessage]);
    }

    
    public function checkExists($docnumber) {
        $check = Gpspayment::where('documentnumber','=',$docnumber)->first();
        return (!$check)?false:true;
    }


    /* ******************  LOGS  ****************** */
    public function saveGpsLog($taxnumber, $request, $curlParams,$documentnumber,$alreadyexists,$ratevalue, $newIdentifier, $saldoCompensar,$saldoCompensarValor) {

        $userInfo = JWTAuth::user();

        $logerror = new Gpspayment();
        $logerror->user_id = $userInfo->id;
        $logerror->client_id = $userInfo->client_id;
        $logerror->taxnumber = $taxnumber;
        $logerror->emission = date('Y-m-d H:i:s');
        $logerror->contributortaxnumber = somenteNumeros($request->input('contributortaxnumber'));
        $logerror->principalvalue = covert2Float($request->input('principalvalue'));
        $logerror->fineinterestvalue = covert2Float($request->input('fineinterestvalue'));
        $logerror->othervalues = covert2Float($request->input('othervalues'));
        $logerror->ratevalue = covert2Float($request->input('ratevalue'));
        $logerror->paymentdate = date2us($request->input('paymentdate'));
        $logerror->ratevaluetype = $request->input('ratevaluetype');
        $logerror->description = $request->input('description');
        $logerror->identifier = $newIdentifier;
        $logerror->ratevalue = $ratevalue;
        $logerror->paymentcode = $request->input('paymentcode');
        $logerror->referencenumber = $request->input('referencenumber');
        $logerror->jurisdictiondate = $request->input('jurisdictiondate');
        $logerror->status = 0;
        $logerror->documentnumber = $documentnumber;
        $logerror->alreadyexists = $alreadyexists;
        $logerror->datasent = $curlParams;
        $logerror->limiteespecial = $saldoCompensar;
        $logerror->valorlimiteespecial = $saldoCompensarValor;
        $logerror->save();

        return true;
    }
   
}
