<?php namespace App\Http\Controllers;

use App\Classes\ClientSPS\ClientSpsService;
use App\Client;
use App\Transferlog;
use Illuminate\Support\Facades\Validator;
use JWTAuth;
use Tymon\JWTAuth\Exceptions\JWTException;

use Illuminate\Http\Request;

class ApiTransferenciaController extends Controller
{
    /** *****************************************
     ********************************************
     *                  TRANSFERENCIA
     ********************************************
     ********************************************
    */

    public function consultaTransferencia(Request $request)
    {

        $results = $this->queryResults($request,new Transferlog);

        $listitens = [];

        foreach($results['object'] as $item) {
            $listitens[] = [
                    'id' => $item->id,
                    'document' => formataCNPJ($item->documento),
                    'nome' => $item->nome,
                    'paymentdate' => detectDateFormatOutputDateBr($item->paymentdate),
                    'banco' => $item->banco,
                    'agencia' => $item->agencia,
                    'conta' => $item->conta .'-'. $item->digito,
                    'valor' => formatMoneyBr($item->valor),
                    'status' => traduzStatusApi($item->status),
                    'receipturl' => replaceNullValueWithEmptyString($item->url)
            ];
        }

        return response()->json(
            [
                "success" => true,
                "data" =>[
                            "resposta" => $listitens,
                            "filtro" => $results['filtro'],
                            "itens" => $results['object']->count()
                        ],
            ]
        );
    }

    public function queryResults($request, $tipo) {
        $userInfo = JWTAuth::user();
        $client = Client::select('clients.*')->where('id','=',$userInfo->client_id)->first();

        if ($request->input('datade') != ''  && $request->input('dataate') != '') {
            $datade  = date2us($request->input('datade'));
            $dataate = date2us($request->input('dataate'));
        } else {
            $datade  = date('Y-m-d', strtotime('-15 days'));
            $dataate = date('Y-m-d');
        }

        $q_sql = $tipo->where('user_id','=',$userInfo->id)
                            ->whereDate('actiondate','>=',$datade)
                            ->whereDate('actiondate','<=',$dataate);

        if(isset($request) && $request->input('filtrostatus') != '')
            $q_sql->where('status','=',$request->input('filtrostatus'));


        $results = $q_sql->orderBy('created_at','desc')->get();

        $filtrostatus  = (isset($request) && $request->input('filtrostatus') != '')?$request->input('filtrostatus'):'';

        $filtro = array('datade'=>dataUs2Br($datade),'dataate'=>dataUs2Br($dataate), 'filtrostatus'=>$filtrostatus);

        return ["object"=>$results,"filtro"=>$filtro];
    }


    /* ******************************************************
       ******************************************************

        SUBMITS

       ******************************************************
       ****************************************************** */

    public function enviaTransferencia(Request $request) {

        $validation = Validator::make($request->all(), [
            'taxnumber' => ['required', 'max:14', 'min:14'],
            'valor' => 'required',
            'limiteespecial' => 'required',
            'identificador' => 'required',
            'tipoconta' => 'required',
            'documento' => 'required',
            'nome' => 'required',
            'banco' => 'required',
            'agencia' => 'required',
            'conta' => 'required',
            'digito' => 'required',
        ], [
            'taxnumber.required' => 'O CNPJ é obrigatório.',
            'taxnumber.max' => 'O CNPJ deve ter 14 caracteres e somente números.',
            'taxnumber.min' => 'O CNPJ deve ter 14 caracteres e somente números.',
            'valor.required' => 'O campo Valor é obrigatório.',
            'limiteespecial.required' => 'O campo Limite Especial é obrigatório.',
            'identificador.required' => 'O campo Identificador é obrigatório.',
            'tipoconta.required' => 'O campo Tipo de Conta é obrigatório.',
            'documento.required' => 'O campo Documento é obrigatório.',
            'nome.required' => 'O campo Nome é obrigatório.',
            'banco.required' => 'O campo Banco é obrigatório.',
            'agencia.required' => 'O campo Agência é obrigatório.',
            'conta.required' => 'O campo Conta é obrigatório.',
            'digito.required' => 'O campo Dígito é obrigatório.',
        ]);

        if ($validation->fails()) {
            return response()->json([
                "success" => false,
                "message" => $validation->errors()
            ]);
        }

        if (!operationTimeLimit('transferencia')) {
            return response()->json([
                "success" => false,
                "message" => "Transferências após o horário limite devem ser agendadas para o próximo dia útil."
            ], 423);
        }

        $userInfo = JWTAuth::user();

        try {
            $client = new ClientSpsService($request->input('taxnumber'));
        } catch (\Exception $e) {
            return response()->json([
                "success" => false,
                "message" => "CNPJ não encontrado."
            ]);
        }

        if ($client->clientId !== $userInfo->client_id) {
            return response()->json([
                'success' => false,
                'message' => 'Você não possui permissão para acessar este CNPJ.',
            ], 403);
        }

        // CONSULTA O SALDO DO CLIENTE
        $saldoReal = $client->saldoReal;
        $saldoACompensar = $client->saldoCompensar;

        // valor a ser transferido
        $valor = $request->input('valor');
        $logLimitUsed = false;

        $saldoCompensar = 0;
        $saldoCompensarValor = 0;
        $internaltransferdocumentnumber = 0;
        $cashbackvalue = 0;

        // $cli_ratevalue = consultaTaxaCliente($client->id, 'moneytransfer', covert2Float($valor));
        $taxaTransferencia = $client->calculaTaxaDaOperacao('TRANSFERENCIA_EXTERNA', $valor);

        /**
         * O valor que ele deseja transferir + a taxa da transferência é o suficiente em conta?
         */
        $naoPossuiSaldoReal = ($valor + $taxaTransferencia) > $saldoReal;

        if ($naoPossuiSaldoReal) {

            /*
             * É possível utilizar o limite (saldo a compensar) ?
             */
            if ($request->input('limiteespecial') != 'Sim') {
                return response()->json(["success" => false,"message" => "Não há saldo suficiente para realizar a operação."]);
            }

            /**
             * $saldoAAdiantar = valor a ser adiantado sem taxa
             *
             * Inicialmente, usei
             * $saldoAAdiantar = $client->calculaSaldoAAdiantarParaOperacao('TRANSFERENCIA_INTERNA', $valor);
             * porém o valor retornado estava com a taxa.
             */
            $taxaAdiantamento = $client->calculaTaxaAdiantamentoParaOperacao('TRANSFERENCIA_INTERNA', $valor);
            $valorAAdiantar = $saldoCompensar - ($saldoReal - $valor);

            // saldo a transferir para completar o pagamento
            // $valorATransferir = ($valor - $saldoCliente);

            // ao saldo a transferir deve ser adicionada a taxa
            // $cashbackvalue = consultaTaxaCliente($client->id, 'internaltransfer', $valorATransferir);
            // $cashback = $client->calculaTaxaDaOperacao('TRANSFERENCIA_INTERNA', $valorATransferir);

            /**
             * O saldo a compensar é menor do que o valor a adiantar + a taxa de adiantamento?
             */
             $naoPossuiSaldo = $saldoACompensar < $valorAAdiantar + $taxaAdiantamento;
            if ($naoPossuiSaldo) {
                return response()->json([
                    "success" => false,
                    "message" => "Não há saldo suficiente para realizar a operação."
                ]);
            }

            $adiantamento = transfereSaldoDisponivelCliente(
                $client->taxnumber,
                $valorAAdiantar,
                'Adiantamento de saldo a compensar',
                0,
                $taxaAdiantamento);

            // $transfereSaldoDisponivel = transfereSaldoDisponivelCliente($client->taxnumber, $valorATransferir,
            //    'Transferencia de saldo a compensar', $cashback, $taxaTransferencia);

            // if(!$transfereSaldoDisponivel) return response()->json(["success" => false,"message" => "Ocorreu um
            // erro ao realizar a operação. Por favor tente mais tarde."]);

            if (! $adiantamento) {
                return response()->json([
                    "success" => false,
                    "message" => "Ocorreu um erro ao realizar a operação. Por favor tente mais tarde."
                ]);
            }

            $logLimitUsed = true;
            $saldoCompensar = 1;
            $saldoCompensarValor = $valorAAdiantar;
            $internaltransferdocumentnumber = $adiantamento;
        }
        // /CONSULTA O SALDO DO CLIENTE

        $spsInfo = getSPS();

        $newIdentifier = concatIdentifier($request->input('identificador'));

        $tipo_conta = $request->input('tipoconta') == 'Conta corrente' ? 0 : 1;

        $curlParams = "{ \"Method\": \"MoneyTransfer\",
                    \"PartnerId\": ".$spsInfo->partnerid.",
                    \"BusinessUnitId\": ".$spsInfo->businessunitid.",
                    \"FromTaxNumber\": \"".$client->taxnumber."\",
                    \"ToTaxNumber\": \"".somenteNumeros($request->input('documento'))."\",
                    \"ToName\": \"".$request->input('nome')."\",
                    \"Bank\": \"".somenteNumeros($request->input('banco'))."\",
                    \"BankBranch\": \"".somenteNumeros($request->input('agencia'))."\",
                    \"BankAccount\": \"".somenteNumeros($request->input('conta'))."\",
                    \"BankAccountDigit\": \"".somenteNumeros($request->input('digito'))."\",
                    \"AccountType\": \"".$tipo_conta."\",
                    \"Value\": ".$valor.",
                    \"RateValue\": \"".$taxaTransferencia."\",
                    \"Identifier\": \"".$newIdentifier."\",
                    \"RateValueType\": 0,
                    \"PaymentDate\": \"".dataSlashReverse($request->input('datatransf'))."\",
                    \"Tags\": []
                }";

/*      // ORIGINAL EM 20220406
        $curlParams = "{ \"Method\": \"MoneyTransfer\",
                    \"PartnerId\": ".$spsInfo->partnerid.",
                    \"BusinessUnitId\": ".$spsInfo->businessunitid.",
                    \"FromTaxNumber\": \"".$client->taxnumber."\",
                    \"ToTaxNumber\": \"".somenteNumeros($request->input('documento'))."\",
                    \"ToName\": \"".$request->input('nome')."\",
                    \"Bank\": ".somenteNumeros($request->input('banco')).",
                    \"BankBranch\": ".somenteNumeros($request->input('agencia')).",
                    \"BankAccount\": ".somenteNumeros($request->input('conta')).",
                    \"BankAccountDigit\": ".somenteNumeros($request->input('digito')).",
                    \"AccountType\": ".$tipo_conta.",
                    \"Value\": \"".$valor."\",
                    \"RateValue\": \"".$cli_ratevalue."\",
                    \"Identifier\": \"".$newIdentifier."\",
                    \"RateValueType\": 1,
                    \"PaymentDate\": \"".dataSlashReverse($request->input('datatransf'))."\",
                    \"Tags\": []
                }";
*/

        $transfere = sendCurl($curlParams);

        if($transfere["Success"] == "false") {
            $validacao = (isset($transfere['Validation']))?serialize($transfere['Validation']):'';
            $mensagem = (isset($transfere['Message']))?$transfere['Message']:'';

            saveTransferErrorLog('MoneyTransfer', $curlParams, $mensagem, $validacao);

            return response()->json(["success" => false,"message" => "Erro: ocorreu um problema ao processar a requisição. Por favor tente mais tarde."]);
        }

        $transactionNumber = (isset($transfere['DocumentNumber']))?$transfere['DocumentNumber']:'0';
        $sucesso = ($transfere["Success"] == "false")?0:1;
        $entryid = (isset($transfere["EntryId"]))?$transfere["EntryId"]:'';
        $validacao = (isset($transfere['Validation']))?serialize($transfere['Validation']):'';
        $mensagem = (isset($transfere['Message']))?$transfere['Message']:'';
        $url = (isset($transfere['Url']))?$transfere['Url']:'';
        $alreadyexists = (isset($transfere['AlreadyExists']))?1:0;


        $limiteespecial = ($request->input('limiteespecial') == 'Sim')?'1':'0';
        $valorlimiteespecial = 0;

        $checkSaved = checkDocNumberTransfer($transactionNumber);

        if(!$checkSaved) {
            saveTransferLog(
                $client->taxnumber,
                somenteNumeros($request->input('documento')),
                $request->input('nome'),
                somenteNumeros($request->input('banco')),
                somenteNumeros($request->input('agencia')),
                somenteNumeros($request->input('conta')),
                somenteNumeros($request->input('digito')),
                somenteNumeros($tipo_conta),
                $valor,
                $spsInfo->ratevalue,
                $newIdentifier,
                $sucesso,
                $transactionNumber,
                $url,
                $alreadyexists,
                $saldoCompensar,
                $saldoCompensarValor,
                $curlParams,
                date2us($request->input('datatransf'))
            );
        }

        if ($logLimitUsed) {
            logAvailableLimitUsed(
                $userInfo->id,
                $client->id,
                $client->taxnumber,
                $client->availablelimit,
                $saldoCompensarValor,
                'TRANSFERENCIA',
                $transactionNumber,
                false,
                $internaltransferdocumentnumber,
                $taxaAdiantamento
            ); // atualiza detalhamento
        }

        return response()->json([
            "success" => true,
            "message" => 'Transferência realizada com sucesso.',
        ]);
    }


    public function checkExists($docnumber) {
        $check = Transferlog::where('documentnumber','=',$docnumber)->first();
        return (!$check)?false:true;
    }


    /* ******************  LOGS  ****************** */


}
