<?php namespace App\Http\Controllers;

use App\Bank;

use Illuminate\Http\Request;

class BankController extends Controller
{

	public function index()
	{

		$banks = Bank::all();
		$status=(!$banks)?false:true;
		return response()->json($banks);
	}


	public function store(Request $request)
	{

		$banks = new Bank($request->all());
		$banks->save();
		if(!$banks) { return response()->json(['status'=>false,'result' => 'Houve um problema ao salvar. Por favor tente mais tarde.']);}
		return response()->json(['status'=>true,'result' => $banks]);
	}


	public function show(Request $request, $id)
	{

		$banks = Bank::findOrFail($id);
		if(!$banks) { return response()->json(['status'=>false,'result' => 'Oops! Nada foi encontrado.']); }
		return response()->json(['status'=>true,'result' => $banks]);
	}


	public function update(Request $request, $id)
	{

		$banks = Bank::findOrFail($id);
		$banks->update($request->all());
		if(!$banks) { return response()->json(['status'=>false,'result' => 'Houve um problema ao atualizar. Por favor tente mais tarde.']);}
		return response()->json(['status'=>true,'result' => $banks]);
	}


	public function destroy($id)
	{

		$banks = Bank::findOrFail($id);
		$banks->delete();
		if(!$banks) { return response()->json(['status'=>false,'result' => 'Houve um problema ao excluir. Por favor tente mais tarde.']);}
		return response()->json(['status'=>true,'result' => 'O item foi removido com sucesso.']);
	}


}
