<?php namespace App\Http\Controllers;

use App\Bankaccount;

use Illuminate\Http\Request;

class BankaccountController extends Controller
{

	public function index()
	{

		$bankaccounts = Bankaccount::all();
		$status=(!$bankaccounts)?false:true;
		return response()->json(['status'=>$status,'result' => $bankaccounts]);
	}


	public function store(Request $request)
	{

		$bankaccounts = new Bankaccount($request->all());
		$bankaccounts->save();
		if(!$bankaccounts) { return response()->json(['status'=>false,'result' => 'Houve um problema ao salvar. Por favor tente mais tarde.']);}
		return response()->json(['status'=>true,'result' => $bankaccounts]);
	}


	public function show(Request $request, $id)
	{

		$bankaccounts = Bankaccount::findOrFail($id);
		if(!$bankaccounts) { return response()->json(['status'=>false,'result' => 'Oops! Nada foi encontrado.']); }
		return response()->json(['status'=>true,'result' => $bankaccounts]);
	}


	public function update(Request $request, $id)
	{

		$bankaccounts = Bankaccount::findOrFail($id);
		$bankaccounts->update($request->all());
		if(!$bankaccounts) { return response()->json(['status'=>false,'result' => 'Houve um problema ao atualizar. Por favor tente mais tarde.']);}
		return response()->json(['status'=>true,'result' => $bankaccounts]);
	}


	public function destroy($id)
	{

		$bankaccounts = Bankaccount::findOrFail($id);
		$bankaccounts->delete();
		if(!$bankaccounts) { return response()->json(['status'=>false,'result' => 'Houve um problema ao excluir. Por favor tente mais tarde.']);}
		return response()->json(['status'=>true,'result' => 'O item foi removido com sucesso.']);
	}


}
