<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;

use App\Client;
use App\User;
use App\Paymentlog;
use App\Transferlog;
use App\Clientcontact;
use App\Billet;
use App\Billeterror;
use App\Barcodepayment;
use App\Classes\Loglevel;
use App\Classes\Log;

use App\Classes\ClientSPS\ClientSpsService;
use GuzzleHttp\RetryMiddleware;

class BarcodepaymentController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function pagamentoboleto(Request $request) {

        //Log
        $logAplicacaoFeature = 'PAGAMENTO_BOLETO';
        $logIdLixo = Log::saveLogAplicacao(Loglevel::DEBUG, $logAplicacaoFeature, Route::getCurrentRoute()->getActionName(), 'ENTRADA DE METODO', 1, null);


        $varArray = array(
            'clientTaxnumber' => Session::get('cnpj'),
            'limiteespecial' => isset($request->limiteespecial)? $request->limiteespecial : 1,
            'request' => json_decode(json_encode(array('method' => null))),
            'spsInfo' => json_decode(json_encode(array('partnerid' => null))),
        );

        $var = json_decode(json_encode($varArray));
        $var->clienteSPS = new ClientSPSService($var->clientTaxnumber);
        $var->clienteSPSid = $var->clienteSPS->clientId;
        $var->limiteoperacao = $var->clienteSPS->calculaLimiteDaOperacao($logAplicacaoFeature, $var->limiteespecial);

        //Chamado aṕos o cliente digitar as informações do boleto
        if ($request->isMethod('post')) {

            $var->request->method = 'post';
            $spsInfo = getSPS();

            //Log
            $logId = Log::saveLogAplicacao(Loglevel::DEBUG, $logAplicacaoFeature, Route::getCurrentRoute()->getActionName(), 'GetInfosByBarcode', null, null);

            //Monta JSON para requisição inicial
            //A partir da resposta, analisar se é boleto de concessionaria ou comum
            $curlParams = "{ \"Method\": \"GetInfosByBarcode\",
                            \"PartnerId\": ".$spsInfo->partnerid.",
                            \"BusinessUnitId\": ".$spsInfo->businessunitid.",
                            \"Barcode\": \"".trim(somenteNumeros($request->barcode))."\"}";

            //Consulta informações do Fitbank
            $consulta = sendCurl($curlParams, 'GetInfosByBarcode');

            //Log
            Log::saveLogAplicacao(Loglevel::DEBUG, $logAplicacaoFeature, Route::getCurrentRoute()->getActionName(), 'GetInfosByBarcode', (int) $consulta["Success"], null, $logId);

            //Erro na requisição
            if($consulta["Success"] == "false") {
                return redirect('/pagamentos/boletos')->with('warning', 'Erro ao consultar boleto. '.$consulta['Message']);
            }

            //Extrai informações
            $boleto = json_decode($consulta['Infos']);

            //Pagamento de boletos de concessionária de serviços públicos
            if($boleto->ConcessionaireCode != null) {

                //Log
                $logIdLixo = Log::saveLogAplicacao(Loglevel::DEBUG, $logAplicacaoFeature, Route::getCurrentRoute()->getActionName(), 'Boleto de Concessionária -> View: clients.pagamentoboleto', 1, null);

                $limiteoperacao = $var->limiteoperacao;

                //chama view para pagamento de boleto de concessionaria
            	return view('clients.pagamentoboleto',compact('boleto','limiteoperacao')); // boleto de concessionária
            }

            //Pagamento de boletos em geral
            else {

                //Log
                $logIdLixo = Log::saveLogAplicacao(Loglevel::DEBUG, $logAplicacaoFeature, Route::getCurrentRoute()->getActionName(), 'Boleto Comum', 1, null);

                $client = getClientById( Auth::user()->client_id );

                //Log
                $logId = Log::saveLogAplicacao(Loglevel::DEBUG, $logAplicacaoFeature, Route::getCurrentRoute()->getActionName(), 'GetInfosCIPByBarcode', null, null);

                //Monta JSON para requisição
                //A resposta vem com diversas informações sobre o boleto
                $curlParams = "{ \"Method\": \"GetInfosCIPByBarcode\",
                            \"TaxNumber\": \"".somenteNumeros($var->clientTaxnumber)."\",
                            \"PartnerId\": ".$spsInfo->partnerid.",
                            \"BusinessUnitId\": ".$spsInfo->businessunitid.",
                            \"Barcode\": \"".trim(somenteNumeros($boleto->Barcode))."\"}";

                //Consulta informações do Fitbank
                $consulta = sendCurl($curlParams);

                Log::saveLogAplicacao(Loglevel::DEBUG, $logAplicacaoFeature, Route::getCurrentRoute()->getActionName(), 'GetInfosCIPByBarcode', (int) $consulta["Success"], null, $logId);

                //Log
                customLog('GetInfosCIPByBarcode');
                customLog($curlParams);

                //Abre view para caso de falha
	            if($consulta["Success"] == "false") {
	                return redirect('/pagamentos/boletos')->with('warning', 'Erro ao consultar detalhes do boleto. '.$consulta['Message']);
	            }

	            // $cod_barras = array('codigo'=>somenteNumeros($request->barcode));

                //Log
                $logIdLixo = Log::saveLogAplicacao(Loglevel::DEBUG, $logAplicacaoFeature, Route::getCurrentRoute()->getActionName(), 'Boleto Comum -> View: clients.pagamentoboletocip', 1, null);


                $cod_barras = array('codigo'=>somenteNumeros($boleto->Barcode));

                $boleto = json_decode($consulta['Infos']);
                $limiteoperacao = $var->limiteoperacao;

                //Chama view para caso de boleto comum
                return view('clients.pagamentoboletocip',compact('boleto','cod_barras','limiteoperacao'));
            }
        }

        $limiteoperacao = $var->limiteoperacao;

        //Chama view para cliente inserir numero do boleto
        return view('clients.pagamentoboletocodbarras', compact('limiteoperacao'));
    }

    public function pagamentoboletopagar(Request $request) {

        //Log
        $logAplicacaoFeature = 'PAGAMENTO_BOLETO';
        $logIdLixo = Log::saveLogAplicacao(Loglevel::DEBUG, $logAplicacaoFeature, Route::getCurrentRoute()->getActionName(), 'ENTRADA DE METODO', 1, null);

        //Dados do cliente
        $client = getClientById( Auth::user()->client_id );
        $clientTaxnumber = Session::get('cnpj');

        // CONSULTA O SALDO DO CLIENTE
        $saldoCliente = saldoCliente($clientTaxnumber);

        //TODO: Retirar saldo fixo
        //$saldoCliente = 1000;

        $saldoDisponivel = $client->availablelimit;
        // valor a ser transferido
        // $valor = covert2Float($request->principalvalue);
        // $valor = $request->principalvalue;
        $logLimitUsed = false;

        $saldoCompensar = 0;
        $saldoCompensarValor = 0;
        $internaltransferdocumentnumber = 0;
        $cashbackvalue = 0;

        $valorBoleto = floatval($request->principalvalue);
        $clientSPS = new ClientSpsService($clientTaxnumber);

        //Só utilizar saldo a compensar se o cliente não tiver saldo em conta
        $usarSaldoCompensar = false;
        if ((isset($request->limiteespecial) && $request->limiteespecial == 1)) {
            $usarSaldoCompensar = true;
        }

        //Retorna o limite total já considerando a opção de Saldo a Compensar e taxas
        $limitePagamentoBoleto = $clientSPS->calculaLimiteDaOperacao('PAGAMENTO_BOLETO', $usarSaldoCompensar);

        //Valor do boleto é maior que saldo a compensar + saldo na conta
        //Não completa a transação
        if ($valorBoleto > $limitePagamentoBoleto) {

            $logIdLixo = Log::saveLogAplicacao(Loglevel::DEBUG, $logAplicacaoFeature, Route::getCurrentRoute()->getActionName(), 'Não há saldo suficiente para realizar a operação.', 0, null);

            return redirect('/pagamentos/boletos')->with('warning', 'Não há saldo suficiente para realizar a operação.');

        }

        else {
            //Caso o cliente deseje utilizar parte do saldo a compensar para realizar o pagamento
            if ($valorBoleto>$saldoCliente && $usarSaldoCompensar) {

                //A função retorna o saldo total a adiantar para cobrir a operação.
                //Já adiciona todas as taxas necessárias para a transação
                //$saldoAAdiantar = Valor necessário + Taxa de adiantamento + Taxa Pagamento do Boleto
                $saldoAAdiantar = $clientSPS->calculaSaldoAAdiantarParaOperacao('PAGAMENTO_BOLETO', $valorBoleto);

                if ($saldoAAdiantar > 0) {
                    // realiza a transferencia do valor adicional para o cliente
                    $mensagem = 'Transferencia de saldo a compensar';

                    //Taxa cobrada para adiantar o saldo a compensar restante até o valor do boleto
                    $taxaDeAdiantamentoSaldo = $clientSPS->calculaTaxaAdiantamentoParaOperacao('PAGAMENTO_BOLETO', $valorBoleto);

                    //Saldo a adiantar sem considerar as taxas cobradas
                    $saldoAAdiantarSemTaxaAdiantamento = $saldoAAdiantar - $taxaDeAdiantamentoSaldo;

                    $transfereSaldoDisponivel = transfereSaldoDisponivelCliente($clientTaxnumber, $saldoAAdiantarSemTaxaAdiantamento, $mensagem, $taxaDeAdiantamentoSaldo, 0);

                    if(!$transfereSaldoDisponivel) {
                        return redirect('/pagamentos/boletos')->with('warning', 'Ocorreu um erro ao realizar a operação. Por favor tente mais tarde.');
                    }

                    $logLimitUsed = true;
                    $saldoCompensar = 1;
                    $saldoCompensarValor = $saldoAAdiantar;
                    $internaltransferdocumentnumber = $transfereSaldoDisponivel;
                }
            }
        }

        $spsInfo = getSPS();

        $vencimento = (!empty($request->duedate))?dataSlashReverse($request->duedate):date('Y/m/d');

        $extravalue = ($request->cip==0)?$request->extravalue:$request->totaladdedvalue;

        //TODO: Verificar concatenador.
        //Não concatena nada
        $newIdentifier = concatIdentifier($request->identifier);

        //Taxa cobrada para pagamento do boleto
        $taxaDaOperacao = $clientSPS->calculaTaxaDaOperacao('PAGAMENTO_BOLETO', $valorBoleto);

        //Log
        $logId = Log::saveLogAplicacao(Loglevel::DEBUG, $logAplicacaoFeature, Route::getCurrentRoute()->getActionName(), 'GenerateBoletoOut', null, null);

        $curlParams = "{\"Method\": \"GenerateBoletoOut\",
                        \"PartnerId\": ".$spsInfo->partnerid.",
                        \"BusinessUnitId\": ".$spsInfo->businessunitid.",
                        \"Name\": \"".$client->name."\",
                        \"TaxNumber\": \"".$clientTaxnumber."\",
                        \"Barcode\": \"".$request->barcode."\",
                        \"PrincipalValue\": ".$request->principalvalue.",
                        \"DiscountValue\": ".covert2Float($request->discountvalue).",
                        \"ExtraValue\": ".convertToFloat($extravalue).",
                        \"PaymentDate\": \"".dataSlashReverse($request->paymentdate)."\",
                        \"DueDate\": \"".$vencimento."\",
                        \"Identifier\": \"".$newIdentifier."\",
                        \"RateValueType\": 1,
                        \"RateValue\": \"".$taxaDaOperacao."\"
                    }";

        //Executa o pagamento
        $pagamento = sendCurl($curlParams, 'GenerateBoletoOut');

        //Log
        Log::saveLogAplicacao(Loglevel::DEBUG, $logAplicacaoFeature, Route::getCurrentRoute()->getActionName(), 'GenerateBoletoOut', (int) $pagamento["Success"], null, $logId);
        customLog('GenerateBoletoOut');
        customLog($curlParams);

        if($pagamento["Success"] == "false") {
            $validacao = (isset($pagamento['Validation']))?serialize($pagamento['Validation']):'';
            $mensagem = (isset($pagamento['Message']))?$pagamento['Message']:'';
            saveTransferErrorLog('GenerateBoletoOut', $curlParams, $mensagem, $validacao);

            return redirect('/pagamentos/boletos')->with('warning', 'Erro ao realizar a operação. '.$pagamento['Message']);
        }

        $documentnumber = (isset($pagamento['DocumentNumber']))?$pagamento['DocumentNumber']:'0';
        $sucesso = ($pagamento["Success"] == "false")?0:1;
        $entryid = (isset($pagamento["EntryId"]))?$pagamento["EntryId"]:'';
        $validacao = (isset($pagamento['Validation']))?serialize($pagamento['Validation']):'';
        $mensagem = (isset($pagamento['Message']))?$pagamento['Message']:'';
        $url = (isset($pagamento['Url']))?$pagamento['Url']:'';
        $alreadyexists = (isset($pagamento['AlreadyExists']))?$pagamento['AlreadyExists']:'';


        $checkDocnumber = $this->checkExists($documentnumber);

        if(!$checkDocnumber) {
            $viewStatus = 'status';
            $viewMessage = 'Operação realizada com sucesso.';
            $this->saveBarcodeLog(somenteNumeros($clientTaxnumber),$request, $curlParams,$documentnumber,$entryid,$alreadyexists, 0,$url,$saldoCompensar,$saldoCompensarValor);

            if($logLimitUsed)
                logAvailableLimitUsed(Auth::user()->id, $client->id, $clientTaxnumber, $client->availablelimit, $saldoAAdiantar, 'BOLETO', $documentnumber, false, $internaltransferdocumentnumber, $cashbackvalue); // atualiza detalhamento

        } else {
            $viewStatus = 'danger';
            $viewMessage = 'O documento já foi enviado anteriormente!';
        }

        //Log
        savePaymentLog($clientTaxnumber ,str_replace('/', '-', $vencimento) ,date2us($request->paymentdate) ,'GenerateBoletoOut' ,
                        concatIdentifier($request->identifier) , $documentnumber, $request->digitableline ,$curlParams ,$sucesso ,$mensagem ,$validacao ,
                        $entryid ,$url ,$request->principalvalue ,str_replace(',', '.', str_replace('.', '', zeroNull($request->discountvalue))) ,covert2Float($extravalue));

        $logIdLixo = Log::saveLogAplicacao(Loglevel::DEBUG, $logAplicacaoFeature, Route::getCurrentRoute()->getActionName(), 'Pagamento Boleto -> View: clients.pagamentoboletook', 1, null);

        return view('clients.pagamentoboletook', compact('pagamento'))->with($viewStatus, $viewMessage);
    }

    public function logpagamentos(Request $request) {
        $logAplicacaoFeature = 'PAGAMENTO_BOLETO';
        $logIdLixo = Log::saveLogAplicacao(Loglevel::DEBUG, $logAplicacaoFeature, Route::getCurrentRoute()->getActionName(), 'ENTRADA DE METODO', 1, null);

        if(isset($request) && $request->datade != ''  && $request->dataate != '' && ( $request->datade <= $request->dataate ) ) {
            $datade  = date(date2us($request->datade), strtotime('-7 days'));
            $dataate = date(date2us($request->dataate));
        } else {
            $datade  = date('Y-m-d', strtotime('-7 days'));
            $dataate = date('Y-m-d');
        }

        // $tlogs = Paymentlog::where('method','=','GenerateBoletoOut')
        //                     ->where('user_id','=',Auth::user()->id)
        //                     ->whereDate('actiondate','>=',$datade)
        //                     ->whereDate('actiondate','<=',$dataate)
        //                     ->where('url','<>','')
        //                     ->orderBy('created_at','desc')
        //                     ->get();

         $q_tlogs = Barcodepayment::where('user_id','=',Auth::user()->id)
                            ->whereDate('emission','>=',$datade)
                            ->whereDate('emission','<=',$dataate);

        if(isset($request) && $request->filtrostatus != '')
            $q_tlogs->where('status','=',$request->filtrostatus);


        $tlogs = $q_tlogs->orderBy('created_at','desc')->get();

        $filtrostatus  = (isset($request) && $request->filtrostatus != '')?$request->filtrostatus:'';

        $datafiltro = array('datade'=>date2br($datade),'dataate'=>date2br($dataate), 'filtrostatus'=>$filtrostatus);

        return view('clients.logpagamentos',compact('tlogs','datafiltro'));
    }

    public function checkExists($docnumber) {
        $check = Barcodepayment::where('documentnumber','=',$docnumber)->first();
        return (!$check)?false:true;
    }

    /* ******************  LOGS  ****************** */

    public function saveBarcodeLog($taxnumber, $request, $curlParams,$documentnumber, $entryid, $alreadyexists,$ratevalue,$url, $saldoCompensar,$saldoCompensarValor) {
        $logAplicacaoFeature = 'PAGAMENTO_BOLETO';
        $logIdLixo = Log::saveLogAplicacao(Loglevel::DEBUG, $logAplicacaoFeature, Route::getCurrentRoute()->getActionName(), 'ENTRADA DE METODO', 1, null);

        $userInfo = Auth::user();

        $vencimento = (!empty($request->duedate))?dataSlashReverse($request->duedate):date('Y/m/d');

        $logerror = new Barcodepayment();
        $logerror->user_id = $userInfo->id;
        $logerror->client_id = $userInfo->client_id;
        $logerror->emission = date('Y-m-d H:i:s');

        $logerror->name = $request->name;
		$logerror->taxnumber = somenteNumeros($request->taxnumber);
		$logerror->beneficiarytaxnumber = somenteNumeros($request->beneficiarytaxnumber);
		$logerror->beneficiaryname = $request->beneficiaryname;
		$logerror->guarantortaxnumber = somenteNumeros($request->guarantortaxnumber);
		$logerror->guarantorname = $request->guarantorname;
		$logerror->payertaxnumber = somenteNumeros($request->payertaxnumber);
		$logerror->payername = $request->payername;
		$logerror->mailtosend = $request->mailtosend;
		$logerror->phonetosend = $request->phonetosend;
		$logerror->barcode = $request->barcode;
		$logerror->principalvalue = $request->principalvalue;
		$logerror->discountvalue = covert2Float(zeroNull($request->discountvalue));
		$logerror->extravalue = covert2Float(zeroNull($request->extravalue));
		$logerror->paymentdate = date2us($request->paymentdate);
		$logerror->duedate = $vencimento;
		$logerror->feepayertaxnumber = $request->feepayertaxnumber;
		$logerror->feepayerfullname = $request->feepayerfullname;
		$logerror->feepayermail = $request->feepayermail;
		$logerror->feepayerphone = $request->feepayerphone;
		$logerror->feepayerbank = $request->feepayerbank;
		$logerror->feepayerbankbranch = $request->feepayerbankbranch;
		$logerror->feepayerbankaccount = $request->feepayerbankaccount;
		$logerror->feepayerbankaccountdigit = $request->feepayerbankaccountdigit;
		$logerror->description = $request->description;
		$logerror->identifier = concatIdentifier($request->identifier);
		$logerror->ratevaluetype = $request->ratevaluetype;
		$logerror->ratevalue = $request->ratevalue;
        $logerror->limiteespecial = $saldoCompensar;
        $logerror->valorlimiteespecial = $saldoCompensarValor;
		$logerror->receipturl = $url;

        $logerror->status = 0;
        $logerror->documentnumber = $documentnumber;
        $logerror->alreadyexists = $alreadyexists;
        $logerror->datasent = $curlParams;


        $logerror->save();

        return true;
    }




    /* ******************  LIXO  ****************** */

    public function pagamentoboletopagarHELDER(Request $request) {
        $logAplicacaoFeature = 'PAGAMENTO_BOLETO';
        $logIdLixo = Log::saveLogAplicacao(Loglevel::DEBUG, $logAplicacaoFeature, Route::getCurrentRoute()->getActionName(), 'ENTRADA DE METODO', 1, null);

        $client = getClientById( Auth::user()->client_id );

        // CONSULTA O SALDO DO CLIENTE
        $saldoCliente = saldoCliente($client->taxnumber);
        $saldoDisponivel = $client->availablelimit;
        // valor a ser transferido
        // $valor = covert2Float($request->principalvalue);
        $valor = $request->principalvalue;
        $logLimitUsed = false;

        $saldoCompensar = 0;
        $saldoCompensarValor = 0;
        $internaltransferdocumentnumber = 0;
        $cashbackvalue = 0;

        $cli_ratevalue = consultaTaxaCliente($client->id, 'payment', covert2Float($valor));

        // verifica se o disponível é >= valor a ser transferido
        if(($valor + $cli_ratevalue) > $saldoCliente) {
            // se não for, verifica se permite usar saldo a compensar
            if(isset($request->limiteespecial) && $request->limiteespecial == 1) {

                // saldo a transferir para completar o pagamento
                $saldoATransferir = (($valor + $cli_ratevalue) - $saldoCliente);

                // ao saldo a transferir deve ser adicionada a taxa
                $cashbackvalue = consultaTaxaCliente($client->id, 'internaltransfer', $saldoATransferir);

                // verifica se o cliente possui saldo a compensar suficiente
                if( ($saldoCliente + $saldoDisponivel) < ($valor + $cashbackvalue + $cli_ratevalue) ) {
                    return redirect('/pagamentos/boletos')->with('warning', 'Não há saldo suficiente para realizar a operação.');
                } else {
                    // realiza a transferencia do valor adicional para o cliente
                    $transfereSaldoDisponivel = transfereSaldoDisponivelCliente($client->taxnumber, $saldoATransferir, 'Transferencia de saldo a compensar',$cashbackvalue, 0);

                    if(!$transfereSaldoDisponivel) return redirect('/pagamentos/boletos')->with('warning', 'Ocorreu um erro ao realizar a operação. Por favor tente mais tarde.');

                    $logLimitUsed = true;
                    $saldoCompensar = 1;
                    $saldoCompensarValor = $saldoATransferir;
                    $internaltransferdocumentnumber = $transfereSaldoDisponivel;
                }
            } else {
                return redirect('/pagamentos/boletos')->with('warning', 'Não há saldo suficiente para realizar a operação.');
            }
        }

        $spsInfo = getSPS();

        $vencimento = (!empty($request->duedate))?dataSlashReverse($request->duedate):date('Y/m/d');

        $extravalue = ($request->cip==0)?$request->extravalue:$request->totaladdedvalue;

        $newIdentifier = concatIdentifier($request->identifier);

        $cli_ratevalue = consultaTaxaCliente($client->id, 'payment', covert2Float($valor));

        $curlParams = "{\"Method\": \"GenerateBoletoOut\",
                    \"PartnerId\": ".$spsInfo->partnerid.",
                    \"BusinessUnitId\": ".$spsInfo->businessunitid.",
                    \"Name\": \"".$client->name."\",
                    \"TaxNumber\": \"".$client->taxnumber."\",
                    \"Barcode\": \"".$request->barcode."\",
                    \"PrincipalValue\": ".$request->principalvalue.",
                    \"DiscountValue\": ".covert2Float($request->discountvalue).",
                    \"ExtraValue\": ".covert2Float($extravalue).",
                    \"PaymentDate\": \"".dataSlashReverse($request->paymentdate)."\",
                    \"DueDate\": \"".$vencimento."\",
                    \"Identifier\": \"".$newIdentifier."\",
                    \"RateValueType\": 1,
                    \"RateValue\": \"".$cli_ratevalue."\"
                }";

        $pagamento = sendCurl($curlParams);

        customLog('GenerateBoletoOut');
        customLog($curlParams);

        if($pagamento["Success"] == "false") {
            $validacao = (isset($pagamento['Validation']))?serialize($pagamento['Validation']):'';
            $mensagem = (isset($pagamento['Message']))?$pagamento['Message']:'';
            saveTransferErrorLog('GenerateBoletoOut', $curlParams, $mensagem, $validacao);

            return redirect('/pagamentos/boletos')->with('warning', 'Erro ao realizar a operação. '.$pagamento['Message']);
        }

        $documentnumber = (isset($pagamento['DocumentNumber']))?$pagamento['DocumentNumber']:'0';
        $sucesso = ($pagamento["Success"] == "false")?0:1;
        $entryid = (isset($pagamento["EntryId"]))?$pagamento["EntryId"]:'';
        $validacao = (isset($pagamento['Validation']))?serialize($pagamento['Validation']):'';
        $mensagem = (isset($pagamento['Message']))?$pagamento['Message']:'';
        $url = (isset($pagamento['Url']))?$pagamento['Url']:'';
        $alreadyexists = (isset($pagamento['AlreadyExists']))?$pagamento['AlreadyExists']:'';


        $checkDocnumber = $this->checkExists($documentnumber);
        if(!$checkDocnumber) {
            $viewStatus = 'status';
            $viewMessage = 'Operação realizada com sucesso.';
            $this->saveBarcodeLog(somenteNumeros($client->taxnumber),$request, $curlParams,$documentnumber,$entryid,$alreadyexists, 0,$url,$saldoCompensar,$saldoCompensarValor);

            if($logLimitUsed) logAvailableLimitUsed(Auth::user()->id, $client->id, $client->taxnumber, $client->availablelimit, $saldoATransferir, 'BOLETO', $documentnumber, false, $internaltransferdocumentnumber, $cashbackvalue); // atualiza detalhamento
        } else {
            $viewStatus = 'danger';
            $viewMessage = 'O documento já foi enviado anteriormente!';
        }


        savePaymentLog($client->taxnumber ,str_replace('/', '-', $vencimento) ,date2us($request->paymentdate) ,'GenerateBoletoOut' ,
                        concatIdentifier($request->identifier) , $documentnumber, $request->digitableline ,$curlParams ,$sucesso ,$mensagem ,$validacao ,
                        $entryid ,$url ,$request->principalvalue ,str_replace(',', '.', str_replace('.', '', zeroNull($request->discountvalue))) ,covert2Float($extravalue));

        return view('clients.pagamentoboletook', compact('pagamento'))->with($viewStatus, $viewMessage);
    }

}
