<?php namespace App\Http\Controllers;

use App\Classes\ClientSPS\ClientSpsService;
use Illuminate\Support\Facades\Route;

use App\Client;
use App\Smartsafetransfer;
use JWTAuth;
use Tymon\JWTAuth\Exceptions\JWTException;

use Illuminate\Http\Request;

use App\Multisafe;
use App\Classes\Loglevel;
use App\Classes\Log;
use App\Applicationlog;

class ClientController extends Controller
{

	public function index()
	{

		$clients = Client::all();
		$status=(!$clients)?false:true;
		return response()->json(['status'=>$status,'result' => $clients]);
	}

	function getMultiCnpj() 
	{
        	$client_id = JWTAuth::user()->client_id;
        	$client = (!$client_id)? Auth::user()->client_id : $client_id;
	        $multi = Multisafe::where('client_id', '=', $client)->get();
        	$status=(!empty($multi))?true:false;
	        return response()->json(['status'=>$status, 'result' => $multi]);
	}



	public function extrato(Request $request) {

		$isAuth = $this->checkAuth();

		if($isAuth !== true) return $isAuth;

        $request->validate([
            'taxnumber' => ['required', 'max:14', 'min:11'],
        ], [
            'taxnumber.required' => 'O CNPJ é obrigatório.',
            'taxnumber.max' => 'Utilize apenas números para informar o CNPJ e não ultrapasse 14 caracteres.',
            'taxnumber.min' => 'Utilize apenas números para informar o CNPJ e não ultrapasse 14 caracteres.',
        ]);

        $userInfo = JWTAuth::user();
	
        $spsInfo = getSPS();

        // $client = Client::select('clients.*')->where('id','=',$userInfo->client_id)->first();

        try {
            $client = new ClientSpsService($request->taxnumber);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'CNPJ não encontrado.',
            ]);
        }

        if ($client->clientId !== $userInfo->client_id) {
            return response()->json([
                'success' => false,
                'message' => 'Você não possui permissão para acessar este CNPJ.',
            ], 403);
        }

        // print $request->datade;
        // print $request->dataate;


        if(isset($request) && $request->datade != ''  && $request->dataate != '' && ( $request->datade <= $request->dataate ) ) {
            $datade  = date(dataSlashReverse($request->datade), strtotime('-15 days'));
            $dataate = date(dataSlashReverse($request->dataate));
        } else {
            $datade  = date('Y/m/d', strtotime('-15 days'));
            $dataate = date('Y/m/d');
        }

        //Request Page Params
        $pagesize = 5;
        $page = 1;

        $curlParams = "{ \"Method\": \"GetAccountEntryPaged\",
                    \"PartnerId\": ".$spsInfo->partnerid.",
                    \"BusinessUnitId\": ".$spsInfo->businessunitid.",
                    \"TaxNumber\": \"".$client->taxnumber."\",
                    \"StartDate\": \"".$datade."\",
                    \"EndDate\": \"".$dataate."\",
                    \"PageSize\": ".$pagesize.",
        			\"PageIndex\": ".$page."
                }";

        $extrato = sendCurl($curlParams);

        if($extrato["Success"] == "false") return response()->json(['success'=>false,'message'=>'Ocorreu um problema ao processar a requisição. Por favor tente novamente mais tarde.']);

        $datafiltro = array('datade'=>dataSlashReverse($datade),'dataate'=>dataSlashReverse($dataate));

  		$output = [];
  		foreach(json_decode($extrato['Entry']) as $ext) {
  			$output[] = [
  				'description' => $ext->Description,
  				'details' => $ext->Details,
  				'entrydate' => detectDateFormatOutputDateBr($ext->EntryDate),
  				'operationtype' => getOperationType($ext->OperationType),
  				'subtype' => getOperationType($ext->Subtype),
  				'internalidentifier' => $ext->InternalIdentifier,
  				'documentnumber' => $ext->DocumentNumber,
  				'entryvalue' => number_format($ext->EntryValue,2,',','.'),
  				'saida' => ($ext->EntryValue<0)?1:0
  			];
  		}

        return response()->json(
            [
                "success" => true,
                "data" =>[
                            "extrato" => $output,
                            "saldo" => number_format($extrato['Balance'],2,',','.'),
                            "datafiltro" => $datafiltro
                        ],
            ]
        );
    }







    public function checkAuth()
    {
        try {

            if (! $user = JWTAuth::parseToken()->authenticate()) {
                    return response()->json(['user_not_found'], 404);
            }

        } catch (Tymon\JWTAuth\Exceptions\TokenExpiredException $e) {

                return response()->json(['token_expired'], $e->getStatusCode());

        } catch (Tymon\JWTAuth\Exceptions\TokenInvalidException $e) {

                return response()->json(['token_invalid'], $e->getStatusCode());

        } catch (Tymon\JWTAuth\Exceptions\JWTException $e) {

                return response()->json(['token_absent'], $e->getStatusCode());

        }

        return true;
    }


	public function store(Request $request)
	{

		$clients = new Client($request->all());
		$clients->save();
		if(!$clients) { return response()->json(['status'=>false,'result' => 'Houve um problema ao salvar. Por favor tente mais tarde.']);}
		return response()->json(['status'=>true,'result' => $clients]);
	}

	public function show(Request $request, $id)
	{

		$clients = Client::findOrFail($id);
		if(!$clients) { return response()->json(['status'=>false,'result' => 'Oops! Nada foi encontrado.']); }
		return response()->json(['status'=>true,'result' => $clients]);
	}


	public function update(Request $request, $id)
	{

		$clients = Client::findOrFail($id);
		$clients->update($request->all());
		if(!$clients) { return response()->json(['status'=>false,'result' => 'Houve um problema ao atualizar. Por favor tente mais tarde.']);}
		return response()->json(['status'=>true,'result' => $clients]);
	}


	public function destroy($id)
	{

		$clients = Client::findOrFail($id);
		$clients->delete();
		if(!$clients) { return response()->json(['status'=>false,'result' => 'Houve um problema ao excluir. Por favor tente mais tarde.']);}
		return response()->json(['status'=>true,'result' => 'O item foi removido com sucesso.']);
	}

    /*
     * Status:
     * 0 = Sucesso
     * 1 = 'Problema com o header da requisição.' = código Authorization não confere : ERRO_HEADER
     * 2 = 'Código do terminal não preenchido.' : ERRO_CODE
     * 3 = 'Tipo de movimentação não preenchida.' : ERRO_TIPO
     * 4 = 'Depósito já cadastrado na SPS'
     * 5 = 'Cliente não encontrado com o cnpj fornecido.' : ERRO_CNPJ
     * -----> TENTATIVA = 150 : janela de 2h x frequencia de envio : ERRO_TENTATIVA
     */
	public function availablelimit(Request $request, $cnpj)
	{
        /*
        $log = new Applicationlog();
        $log->user_id = 52;
        $log->role_id = 2;
        $log->client_id = 13;
        $log->taxnumber = $cnpj;
        $log->sessionid = 'teste API';
        $log->sessionjson = $request;
        $log->loglevel = 0;
        $log->action = Route::getCurrentRoute()->getActionName();
        $log->message = 'teste';
        $log->success = true;
        $log->datajson = null;
        $log->save();

        return response()->json([
            'success' => true,
            'message' => $log->id
        ]);
        */

		$cnpj_header = base64_decode( $request->header('Authorization') );
		if($cnpj != $cnpj_header) {
        	return response()->json([
				    'success' => false,
                    'status' => 1,
				    'message' => 'Problema com o header da requisição.',
                    'codigo_erro' => 'ERRO_HEADER'
				]);
        }

        if (!$request->code) {
        	return response()->json([
                'success' => false,
                'status' => 2,
                'message' => 'Código do terminal não preenchido.',
                'codigo_erro' => 'ERRO_CODE'
            ]);
        }

        if (!$request->tipo) {
        	return response()->json([
                'success' => false,
                'status' => 3,
                'message' => 'Tipo de movimentação não preenchida.',
                'codigo_erro' => 'ERRO_TIPO'
            ]);
        }

        // Verifica se depósito já existe na SPS
        //$depositoExiste = true;
        $depositoExiste = Smartsafetransfer::where('smart_queue_id', $request->fila)->first();
        if($depositoExiste) {
            return response()->json([
                'success' => false,
                'status' => 4,
                'message' => 'Depósito já cadastrado na SPS',
                'codigo_erro' => 'ERRO_DUPLICADO'
            ]);
        }

		$client = Client::where('taxnumber', '=', $cnpj)->where('active', 1)->first();
      	if(!$client) {
            $multi = Multisafe::where('taxnumber', '=', $cnpj)->where('active', 1)->first();
            if(!$multi) {
                return response()->json([
                    'success' => false,
                    'status' => 5,
                    'message' => 'Cliente não encontrado com o cnpj fornecido.'.$cnpj_header,
                    'codigo_erro' => 'ERRO_CNPJ'
                ]);
            }

            $multi->availablelimit = ($multi->availablelimit + $request->value);
            $multi->update();

            $_client_id = $multi->client_id;
            $_taxnumber = $multi->taxnumber;
            $_availablelimit = $multi->availablelimit;
        } else {
            $client->availablelimit = ($client->availablelimit + $request->value);
            $client->update();

            $_client_id = $client->id;
            $_taxnumber = $client->taxnumber;
            $_availablelimit = $client->availablelimit;
        }

        $log = new Smartsafetransfer();
        $log->client_id = $_client_id;
        $log->taxnumber = $_taxnumber;
        $log->emission  = $request->emission;
        $log->value     = $request->value;
        $log->terminal  = $request->code;
        $log->movementtype = $request->tipo;
        $log->availablelimit = $_availablelimit;
        $log->smart_queue_id = $request->fila;
        $log->save();

		return response()->json([
			    'success' => true,
                'status' => 0,
			    'message' => ''
			]);
	}
    /*
    // VERSAO ORIGINAL HELDER (MAI/2022)
	public function availablelimit(Request $request, $cnpj)
	{
		$cnpj_header = base64_decode( $request->header('Authorization') );

		if($cnpj != $cnpj_header) {
        	return response()->json([
				    'success' => false,
				    'message' => 'Problema com o header da requisição.'
				]);
        }

		$client = Client::where('taxnumber','=',$cnpj)->first();

      	if(!$client) {

            $multi = Multisafe::where('taxnumber','=',$cnpj)->first();

            if(!$multi) {
                return response()->json([
                    'success' => false,
                    'message' => 'Cliente não encontrado com o cnpj fornecido.'.$cnpj_header
                ]);

            }

            $emission = $request->emission;
            $multi->availablelimit = ($multi->availablelimit + $request->value);
            $multi->update();

            $_client_id = $multi->client_id;
            $_taxnumber = $multi->taxnumber;
        } else {
            $emission = $request->emission;
            $client->availablelimit = ($client->availablelimit + $request->value);
            $client->update();

            $_client_id = $client->id;
            $_taxnumber = $client->taxnumber;
        }

        $log = new Smartsafetransfer();
        $log->client_id = $_client_id;
        $log->taxnumber = $_taxnumber;
        $log->emission  = $request->emission;
        $log->value     = $request->value;
        $log->terminal  = $request->code;
        $log->movementtype = $request->tipo;
        $log->save();

		return response()->json([
			    'success' => true,
			    'message' => ''
			]);

	}
    */

    public function userTaxes(Request $request) {
        $isAuth = $this->checkAuth();

        if($isAuth !== true) return $isAuth;

        $userInfo = JWTAuth::user();

        $spsInfos = getSPS();

        $client = Client::select('clients.*')->where('id','=',$userInfo->client_id)->first();

        if(!$client) return response()->json([
                                'success' => true,
                                'message' => 'Cliente não econtrado'
                            ]);

        if($client->customrates == 1) {
            $response = [
                'pagamentos' => ($client->paymentspercentage=='1')?formatMoneyBr($client->payments).'%':'R$ '.formatMoneyBr($client->payments),
                'transferencias' => ($client->transferspercentage=='1')?formatMoneyBr($client->transfers).'%':'R$ '.formatMoneyBr($client->transfers),
                'boletos' => ($client->billetspercentage=='1')?formatMoneyBr($client->billets).'%':'R$ '.formatMoneyBr($client->billets),
                'adiantamento' => ($client->balanceusagepercentage=='1')?formatMoneyBr($client->balanceusage).'%':'R$ '.formatMoneyBr($client->balanceusage),
                'mensalidade' => 'R$ '.formatMoneyBr($client->monthlyfee)
            ];
        } else {
            $response = [
                'pagamentos' => ($spsInfos->clientpaymentspercentage=='1')?formatMoneyBr($spsInfos->clientpayments).'%':'R$ '.formatMoneyBr($spsInfos->clientpayments),
                'transferencias' => ($spsInfos->clienttransferspercentage=='1')?formatMoneyBr($spsInfos->clienttransfers).'%':'R$ '.formatMoneyBr($spsInfos->clienttransfers),
                'boletos' => ($spsInfos->clientbilletspercentage=='1')?formatMoneyBr($spsInfos->clientbillets).'%':'R$ '.formatMoneyBr($spsInfos->clientbillets),
                'adiantamento' => ($spsInfos->clientbalanceusagepercentage=='1')?formatMoneyBr($spsInfos->clientbalanceusage).'%':'R$ '.formatMoneyBr($spsInfos->clientbalanceusage),
                'mensalidade' => 'R$ '.formatMoneyBr($client->monthlyfee)
            ];
        }

        return response()->json([
                'success' => true,
                'result' => $response
            ]);
    }

}
