<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;

use App\Client;
use App\User;
use App\Darfpayment;

class DarfpaymentController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
	* darfFormulario
    */
	public function darfFormulario() {
    	$client = getClientById(Auth::user()->client_id);

    	return view('clients.darfForm',compact('client'));
    }

    /**
	* darfEnviar
    */
    public function darfEnviar(Request $request) {

    	$client = getClientById(Auth::user()->client_id);

        $spsInfo = getSPS();
    	
    	// CONSULTA O SALDO DO CLIENTE
        $saldoCliente = saldoCliente($client->taxnumber);
        $saldoDisponivel = $client->availablelimit;
        // valor a ser transferido
        $valor = covert2Float($request->totalvalue);
        $logLimitUsed = false;

        $saldoCompensar = 0;
        $saldoCompensarValor = 0;
        $internaltransferdocumentnumber = 0;
        $cashbackvalue = 0;

        // verifica se o disponível é >= valor a ser transferido
        if($valor > $saldoCliente) {
            // se não for, verifica se permite usar saldo a compensar
            if(isset($request->limiteespecial) && $request->limiteespecial == 1) {
                
                // saldo a transferir para completar o pagamento
                $saldoATransferir = ($valor - $saldoCliente);

                // ao saldo a transferir deve ser adicionada a taxa
                $cashbackvalue = consultaTaxaCliente($client->id, 'internaltransfer', $saldoATransferir);

                // verifica se o cliente possui saldo a compensar suficiente
                if( ($saldoCliente + $saldoDisponivel) < ($valor + $cashbackvalue) ) {
                    return redirect('darf')->with('warning', 'Não há saldo suficiente para realizar a operação.');
                } else {
                    // realiza a transferencia do valor adicional para o cliente
                    $transfereSaldoDisponivel = transfereSaldoDisponivelCliente($client->taxnumber,( $saldoATransferir + $cashbackvalue), 'Transferencia de saldo a compensar', $cashbackvalue);

                    if(!$transfereSaldoDisponivel) return redirect('darf')->with('warning', 'Ocorreu um erro ao realizar a operação. Por favor tente mais tarde.');

                    // $logLimitUsed = logAvailableLimitUsed(Auth::user()->id, $client->id, $client->taxnumber, $client->availablelimit, $saldoATransferir, 'DARF', '0', false); // salva detalhamento
                    $logLimitUsed = true;
                    $saldoCompensar = 1;
                    $saldoCompensarValor = $saldoATransferir;
                    $internaltransferdocumentnumber = $transfereSaldoDisponivel;
                }
            } else {
                return redirect('darf')->with('warning', 'Não há saldo suficiente para realizar a operação.');
            }
        }
        // /CONSULTA O SALDO DO CLIENTE

    	$newIdentifier = concatIdentifier($request->identifier);

    	$curlParams = "{ \"Method\": \"GeneratePaymentDARF\",
    				\"PartnerId\": ".$spsInfo->partnerid.",
                    \"BusinessUnitId\": ".$spsInfo->businessunitid.",
    				\"TaxNumber\": \"".somenteNumeros($request->taxnumber)."\",
    				\"DARFType\": ".$request->darftype.",
				    \"CalculationPeriod\": \"".dataSlashReverse($request->calculationperiod)."\",
				    \"CodeRevenue\": \"".$request->coderevenue."\",
				    \"ContributorTaxNumber\": \"".somenteNumeros($request->contributortaxnumber)."\",
				    \"ReferenceNumber\": \"".$request->referencenumber."\",
				    \"DueDate\": \"".dataSlashReverse($request->duedate)."\",
				    \"GrossRevenueValue\": ".covert2Float($request->grossrevenuevalue).",
				    \"GrossRevenuePercentage\": ".covert2Float($request->grossrevenuepercentage).",
				    \"PrincipalValue\": ".covert2Float($request->principalvalue).",
				    \"FineValue\": ".covert2Float($request->finevalue).",
				    \"InterestValue\": ".covert2Float($request->interestvalue).",
				    \"TotalValue\": ".covert2Float($request->totalvalue).",
				    \"PaymentDate\": \"".dataSlashReverse($request->paymentdate)."\",
				    \"Tags\": [],
				    \"Description\": \"".$request->description."\",
				    \"Identifier\": \"".$newIdentifier."\",
				    \"RateValueType\": 1
    			}";

    	$enviar = sendCurl($curlParams);

    	if($enviar["Success"] == "false") {
    		$validacao = (isset($enviar['Validation']))?serialize($enviar['Validation']):'';
    		$mensagem = (isset($enviar['Message']))?$enviar['Message']:'';
    		saveTransferErrorLog('GeneratePaymentDARF', $curlParams, $mensagem, $validacao);

    		return redirect('/darf')->with('warning', 'Erro: ocorreu um problema ao processar a requisição. '.$enviar['Message']);
    	}

    	$documentnumber = (isset($enviar['DocumentNumber']))?$enviar['DocumentNumber']:'0';
    	$alreadyexists = (isset($enviar['AlreadyExists']))?1:0;

    	$checkDocnumber = $this->checkExists($documentnumber);
    	if(!$checkDocnumber) {
    		$viewStatus = 'status';
            $msgPosHorario = (!operationTimeLimit('pagamento'))?' Operações após o horário limite serão efetivadas no próximo dia útil.':'';
    		$viewMessage = 'Documento enviado.'.$msgPosHorario;
    		$this->saveDarfLog(somenteNumeros($client->taxnumber),$request, $curlParams,$documentnumber,$alreadyexists,$newIdentifier,$saldoCompensar,$saldoCompensarValor);

    		if($logLimitUsed) logAvailableLimitUsed(Auth::user()->id, $client->id, $client->taxnumber, $client->availablelimit, $saldoATransferir, 'DARF', $documentnumber, false, $internaltransferdocumentnumber, $cashbackvalue); // atualiza detalhamento
    	} else {
    		$viewStatus = 'danger';
    		$viewMessage = 'O documento já foi enviado anteriormente!';
    	}

    	return view('clients.darfEnviado',compact('enviar'))->with($viewStatus,$viewMessage);
    }

    /**
	* darfListar
    */

    public function darfConsultar(Request $request) {
		$client = Client::select('clients.*')->where('id','=',Auth::user()->client_id)->first();
		
		if ($request->isMethod('post') && $request->datade != ''  && $request->dataate != '' && ( $request->datade <= $request->dataate )) {
			$datade  = date2us($request->datade);
    		$dataate = date2us($request->dataate);    		
    	} else {
    		$datade  = date('Y-m-d', strtotime('-15 days'));
    		$dataate = date('Y-m-d');	
    	}



    	$q_darfs = Darfpayment::where('taxnumber','=',$request->taxnumber)
							->whereDate('emission','>=',$datade)
							->whereDate('emission','<=',$dataate);

		if(isset($request) && $request->filtrostatus != '')
            $q_darfs->where('status','=',$request->filtrostatus);


		$darfs = $q_darfs->orderBy('created_at','desc')->get();

		$filtrostatus  = (isset($request) && $request->filtrostatus != '')?$request->filtrostatus:'';

		$datafiltro = array('datade'=>dataUs2Br($datade),'dataate'=>dataUs2Br($dataate), 'filtrostatus'=>$filtrostatus);

		return view('clients.darfConsultar',compact('darfs','datafiltro'));
	}

	public function checkExists($docnumber) {
		$check = Darfpayment::where('documentnumber','=',$docnumber)->first();
		return (!$check)?false:true;
	}


    /* ******************  LOGS  ****************** */

    public function saveDarfLog($taxnumber, $request, $curlParams,$documentnumber,$alreadyexists, $identifier, $saldoCompensar,$saldoCompensarValor) {

		$userInfo = Auth::user();

		$logerror = new Darfpayment();
		$logerror->user_id = $userInfo->id;
		$logerror->client_id = $userInfo->client_id;
		$logerror->taxnumber = $taxnumber;
		$logerror->emission = date('Y-m-d H:i:s');
		$logerror->darftype = $request->darftype;
		$logerror->calculationperiod = dataSlashReverse($request->calculationperiod);
		$logerror->coderevenue = $request->coderevenue;
		$logerror->contributortaxnumber = somenteNumeros($request->contributortaxnumber);
		$logerror->referencenumber = $request->referencenumber;
		$logerror->duedate = dataSlashReverse($request->duedate);
		$logerror->grossrevenuevalue = covert2Float($request->grossrevenuevalue);
		$logerror->grossrevenuepercentage = covert2Float($request->grossrevenuepercentage);
		$logerror->principalvalue = covert2Float($request->principalvalue);
		$logerror->finevalue = covert2Float($request->finevalue);
		$logerror->interestvalue = covert2Float($request->interestvalue);
		$logerror->totalvalue = covert2Float($request->totalvalue);
		$logerror->paymentdate = date2us($request->paymentdate);
		$logerror->description = $request->description;
		$logerror->identifier = $identifier;
		$logerror->ratevaluetype = 1;
		$logerror->status = 0;
		$logerror->documentnumber = $documentnumber;
		$logerror->alreadyexists = $alreadyexists;
		$logerror->datasent = $curlParams;
        $logerror->limiteespecial = $saldoCompensar;
        $logerror->valorlimiteespecial = $saldoCompensarValor;
		$logerror->save();

		return true;
	}

	
	

	

	public function darfCancelar() {
        // todo:finalizar
        $spsInfo = getSPS();
		// $curlParams = "{ \"Method\": \"CancelPaymentDARF\",
  //   				\"PartnerId\": ".$spsInfo->partnerid.",
//                    \"BusinessUnitId\": ".$spsInfo->businessunitid.",
  //   				\"DocumentNumber\": \"".$docnumber."\"
  //   			}";

  //   	$enviar = sendCurl($curlParams);

  //   	if($enviar["Success"] == "false") {
  //   		$validacao = (isset($enviar['Validation']))?serialize($enviar['Validation']):'';
  //   		$mensagem = (isset($enviar['Message']))?$enviar['Message']:'';
  //   		saveTransferErrorLog('CancelPaymentDARF', $curlParams, $mensagem, $validacao);

  //   		return redirect('/darf')->with('warning', 'Erro: ocorreu um problema ao processar a requisição. '.$enviar['Message']);
  //   	}


    	
	}

}
