<?php namespace App\Http\Controllers;

use App\Document;

use Illuminate\Http\Request;

class DocumentController extends Controller
{

	public function index()
	{

		$documents = Document::all();
		$status=(!$documents)?false:true;
		return response()->json(['status'=>$status,'result' => $documents]);
	}


	public function store(Request $request)
	{

		$documents = new Document($request->all());
		$documents->save();
		if(!$documents) { return response()->json(['status'=>false,'result' => 'Houve um problema ao salvar. Por favor tente mais tarde.']);}
		return response()->json(['status'=>true,'result' => $documents]);
	}


	public function show(Request $request, $id)
	{

		$documents = Document::findOrFail($id);
		if(!$documents) { return response()->json(['status'=>false,'result' => 'Oops! Nada foi encontrado.']); }
		return response()->json(['status'=>true,'result' => $documents]);
	}


	public function update(Request $request, $id)
	{

		$documents = Document::findOrFail($id);
		$documents->update($request->all());
		if(!$documents) { return response()->json(['status'=>false,'result' => 'Houve um problema ao atualizar. Por favor tente mais tarde.']);}
		return response()->json(['status'=>true,'result' => $documents]);
	}


	public function destroy($id)
	{

		$documents = Document::findOrFail($id);
		$documents->delete();
		if(!$documents) { return response()->json(['status'=>false,'result' => 'Houve um problema ao excluir. Por favor tente mais tarde.']);}
		return response()->json(['status'=>true,'result' => 'O item foi removido com sucesso.']);
	}


}
