<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Http\Request;

use App\Client;
use App\User;
use App\Role;
use App\Paymentlog;
use App\Transferlog;
use App\Clientcontact;
use App\Billet;
use App\Billeterror;
use App\Darfpayment;
use App\Darjpayment;
use App\Fgtspayment;
use App\Gpspayment;
use App\Garepayment;
use App\Barcodepayment;
use App\Usedavailablelimit;
use App\CollectsMap;

use App\Multisafe;
use App\Transfermanager;

class ExtratoController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function extratoXLS(Request $request){
        
        $client = Client::select('clients.*')->where('id','=',Auth::user()->client_id)->first();

        $spsInfo = getSPS();

        if(isset($request) && ($request->datade != '') && ($request->dataate != '') && (dataSlashReverse($request->datade) <= dataSlashReverse($request->dataate)) ) {
            $datade  = date(dataSlashReverse($request->datade), strtotime('-15 days'));
            $dataate = date(dataSlashReverse($request->dataate));
        } else {
            $datade  = date('Y/m/d', strtotime('-15 days'));
            $dataate = date('Y/m/d');
        }

        $client_taxnumber = Session::get('cnpj');

        $curlParams = "{ \"Method\": \"GetAccountEntry\",
                    \"PartnerId\": ".$spsInfo->partnerid.",
                    \"BusinessUnitId\": ".$spsInfo->businessunitid.",
                    \"TaxNumber\": \"".$client_taxnumber."\",
                    \"StartDate\": \"".$datade."\",
                    \"EndDate\": \"".$dataate."\"
                }";

        $extrato = sendCurl($curlParams);

        if($extrato["Success"] == "false") 
            return redirect('/home')->with('warning', 'Erro: ocorreu um problema ao processar a requisição.');

        $datafiltro = array('datade'=>dataSlashReverse($datade),'dataate'=>dataSlashReverse($dataate));

        // $saldocompensar = getSmartsafeBalance($client->id);
        $clientMultiCnpj = getMultiCnpj($client->id);
        $clientMultiCnpjAvailableLimit = getAvailableLimitMultiCnpj($client_taxnumber);

        $saldocompensar = (empty($clientMultiCnpj))? $client->availablelimit : $clientMultiCnpjAvailableLimit;


        $dataHoraEmissao = date('d/m/Y - H:i')."h";
        $periodoExtrato = dataSlashReverse($datade). " até ".dataSlashReverse($dataate);
        
        ## Trecho extraido de multiCofres($session_cnpj, $current_uri) 
        $session_cnpj = Session::get('cnpj');
        $clientTemp = Client::where('taxnumber','=',somenteNumeros($session_cnpj))->first();
        if(!$clientTemp) {
            $multiTemp = Multisafe::where('taxnumber', '=', somenteNumeros($session_cnpj))->first();
            $razaoSocialCliente = $multiTemp->nickname;
        } else {
            $razaoSocialCliente = $clientTemp->name;
        }
        ###################
        
        
    
        $cnpjCliente = formataCNPJ(Session::get('cnpj'));


        $saldoEmConta = formatMoneyBr($extrato['Balance']);
        $saldoMaisLimite = formatMoneyBr($extrato['Balance']+$saldocompensar);


        $extratoMovimentacoes = json_decode($extrato['Entry']);
        
    
        $xls = "";

        $xls .= "  <table border='0'>";
        
        $xls .= "          <tr>";
        $xls .= "              <th>".utf8_decode('DATA E HORA')."</th>";
        $xls .= "              <th>".utf8_decode('DESCRIÇÃO')."</th>";
        $xls .= "              <th>".utf8_decode('CRÉDITO (R$)')."</th>";
        $xls .= "              <th>".utf8_decode('DÉBITO (R$)')."</th>";
        $xls .= "          </tr>";

       
        foreach($extratoMovimentacoes as $ext) {

            $dt = explode('T',$ext->EntryDate);
            $dataTemp = explode('-',$dt[0]);
            $horaTemp = explode(':',$dt[1]);
            $dataFormatada = $dataTemp[2].'/'.$dataTemp[1].'/'.substr($dataTemp[0], 2, 4).' - '.$horaTemp[0].':'.$horaTemp[1];

            $valorMovimentacao = formatMoneyBr($ext->EntryValue);
            $descricaoMovimentacao = $ext->Details;

            
            if($valorMovimentacao>=0){

                $xls .= "          <tr>";
                $xls .= "              <td>".utf8_decode($dataFormatada)."</td>";
                $xls .= "              <td>".utf8_decode($descricaoMovimentacao)."</td>";
                $xls .= "              <td>".utf8_decode($valorMovimentacao)."</td>";
                $xls .= "              <td>".""."</td>";
                $xls .= "          </tr>";
                
            }
            else{    

                $xls .= "          <tr>";
                $xls .= "              <td>".utf8_decode($dataFormatada)."</td>";
                $xls .= "              <td>".utf8_decode($descricaoMovimentacao)."</td>";
                $xls .= "              <td>".""."</td>";
                $xls .= "              <td>".utf8_decode($valorMovimentacao)."</td>";
                $xls .= "          </tr>";
            }
        }



        

        $xls .= "</table>";
        #Extrato-".date('(Y-m-d)').".csv"
        $arquivo = "Extrato-".date('(Y-m-d)').".xls";

        // Configurações header para forçar o download  
        header('Content-Type: application/vnd.ms-excel; charset=utf-8');
        header('Content-Disposition: attachment;filename="' . $arquivo . '"');
        header('Cache-Control: max-age=0');
        // Se for o IE9, isso talvez seja necessário
        header('Cache-Control: max-age=1');

        // Envia o conteúdo do arquivo  
        echo $xls;

    }

    public function extratoCSV(Request $request) {
        
        $client = Client::select('clients.*')->where('id','=',Auth::user()->client_id)->first();

        $spsInfo = getSPS();

        if(isset($request) && ($request->datade != '') && ($request->dataate != '') && (dataSlashReverse($request->datade) <= dataSlashReverse($request->dataate)) ) {
            $datade  = date(dataSlashReverse($request->datade), strtotime('-15 days'));
            $dataate = date(dataSlashReverse($request->dataate));
        } else {
            $datade  = date('Y/m/d', strtotime('-15 days'));
            $dataate = date('Y/m/d');
        }

        $client_taxnumber = Session::get('cnpj');

        $curlParams = "{ \"Method\": \"GetAccountEntry\",
                    \"PartnerId\": ".$spsInfo->partnerid.",
                    \"BusinessUnitId\": ".$spsInfo->businessunitid.",
                    \"TaxNumber\": \"".$client_taxnumber."\",
                    \"StartDate\": \"".$datade."\",
                    \"EndDate\": \"".$dataate."\"
                }";

        $extrato = sendCurl($curlParams);

        if($extrato["Success"] == "false") 
            return redirect('/home')->with('warning', 'Erro: ocorreu um problema ao processar a requisição.');

        $datafiltro = array('datade'=>dataSlashReverse($datade),'dataate'=>dataSlashReverse($dataate));

        // $saldocompensar = getSmartsafeBalance($client->id);
        $clientMultiCnpj = getMultiCnpj($client->id);
        $clientMultiCnpjAvailableLimit = getAvailableLimitMultiCnpj($client_taxnumber);

        $saldocompensar = (empty($clientMultiCnpj))? $client->availablelimit : $clientMultiCnpjAvailableLimit;


        $dataHoraEmissao = date('d/m/Y - H:i')."h";
        $periodoExtrato = dataSlashReverse($datade). " até ".dataSlashReverse($dataate);
        
        ## Trecho extraido de multiCofres($session_cnpj, $current_uri) 
        $session_cnpj = Session::get('cnpj');
        $clientTemp = Client::where('taxnumber','=',somenteNumeros($session_cnpj))->first();
        if(!$clientTemp) {
            $multiTemp = Multisafe::where('taxnumber', '=', somenteNumeros($session_cnpj))->first();
            $razaoSocialCliente = $multiTemp->nickname;
        } else {
            $razaoSocialCliente = $clientTemp->name;
        }
        ###################
        
        
    
        $cnpjCliente = formataCNPJ(Session::get('cnpj'));


        $saldoEmConta = formatMoneyBr($extrato['Balance']);
        $saldoMaisLimite = formatMoneyBr($extrato['Balance']+$saldocompensar);


        $extratoMovimentacoes = json_decode($extrato['Entry']);
        
        $headers = array(
            "Content-type" => "text/csv",
            "Content-Disposition" => "attachment; filename=Extrato-".date('(Y-m-d)').".csv",
            "Pragma" => "no-cache",
            "Cache-Control" => "must-revalidate, post-check=0, pre-check=0",
            "Expires" => "0"
        );
    
        $columns = array('Data e Hora', 'Descrição', 'Crédito (R$)', 'Débito (R$)');
    
        $callback = function() use ($extratoMovimentacoes, $columns)
        {
            $file = fopen('php://output', 'w');

            fputcsv($file, $columns);
    
            foreach($extratoMovimentacoes as $ext) {

                $dt = explode('T',$ext->EntryDate);
                $dataTemp = explode('-',$dt[0]);
                $horaTemp = explode(':',$dt[1]);
                $dataFormatada = $dataTemp[2].'/'.$dataTemp[1].'/'.substr($dataTemp[0], 2, 4).' - '.$horaTemp[0].':'.$horaTemp[1];

                $valorMovimentacao = formatMoneyBr($ext->EntryValue);
                $descricaoMovimentacao = $ext->Details;
                
                if($valorMovimentacao>=0)
                    fputcsv($file, array($dataFormatada,$descricaoMovimentacao,$valorMovimentacao,""));

                else    
                    fputcsv($file, array($dataFormatada,$descricaoMovimentacao,"",$valorMovimentacao));

            }
            fclose($file);
        };

        return response()->stream($callback, 200, $headers);
    }


    public function extratoPDF(Request $request) {

        $client = Client::select('clients.*')->where('id','=',Auth::user()->client_id)->first();

        $spsInfo = getSPS();

        if(isset($request) && ($request->datade != '') && ($request->dataate != '') && (dataSlashReverse($request->datade) <= dataSlashReverse($request->dataate)) ) {
            $datade  = date(dataSlashReverse($request->datade), strtotime('-15 days'));
            $dataate = date(dataSlashReverse($request->dataate));
        } else {
            $datade  = date('Y/m/d', strtotime('-15 days'));
            $dataate = date('Y/m/d');
        }

        $client_taxnumber = Session::get('cnpj');

        $curlParams = "{ \"Method\": \"GetAccountEntry\",
                    \"PartnerId\": ".$spsInfo->partnerid.",
                    \"BusinessUnitId\": ".$spsInfo->businessunitid.",
                    \"TaxNumber\": \"".$client_taxnumber."\",
                    \"StartDate\": \"".$datade."\",
                    \"EndDate\": \"".$dataate."\"
                }";

        $extrato = sendCurl($curlParams);

        if($extrato["Success"] == "false") 
            return redirect('/home')->with('warning', 'Erro: ocorreu um problema ao processar a requisição.');

        $datafiltro = array('datade'=>dataSlashReverse($datade),'dataate'=>dataSlashReverse($dataate));

        // $saldocompensar = getSmartsafeBalance($client->id);
        $clientMultiCnpj = getMultiCnpj($client->id);
        $clientMultiCnpjAvailableLimit = getAvailableLimitMultiCnpj($client_taxnumber);

        $saldocompensar = (empty($clientMultiCnpj))? $client->availablelimit : $clientMultiCnpjAvailableLimit;




        $dataHoraEmissao = date('d/m/Y - H:i')."h";
        $periodoExtrato = dataSlashReverse($datade). " até ".dataSlashReverse($dataate);
        
        ## Trecho extraido de multiCofres($session_cnpj, $current_uri) 
        $session_cnpj = Session::get('cnpj');
        $clientTemp = Client::where('taxnumber','=',somenteNumeros($session_cnpj))->first();
        if(!$clientTemp) {
            $multiTemp = Multisafe::where('taxnumber', '=', somenteNumeros($session_cnpj))->first();
            $razaoSocialCliente = $multiTemp->nickname;
        } else {
            $razaoSocialCliente = $clientTemp->name;
        }
        ###################
        
        
    
        $cnpjCliente = formataCNPJ(Session::get('cnpj'));


        $saldoEmConta = formatMoneyBr($extrato['Balance']);
        $saldoMaisLimite = formatMoneyBr($extrato['Balance']+$saldocompensar);

        $mpdf = new \Mpdf\Mpdf();


        $html = '
        <html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40"><head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf8">
        <meta name="ProgId" content="Excel.Sheet">
        <meta name="Generator" content="Microsoft Excel 15">
        <link rel="File-List" href="teste%203_arquivos/filelist.xml">
        <style id="Modelo de Extrato_6858_Styles">
        <!--table
            {mso-displayed-decimal-separator:"\,";
            mso-displayed-thousand-separator:"\.";}
        .xl636858
            {padding-top:1px;
            padding-right:1px;
            padding-left:1px;
            mso-ignore:padding;
            color:black;
            font-size:9.0pt;
            font-weight:400;
            font-style:normal;
            text-decoration:none;
            font-family:Ebrima;
            mso-generic-font-family:auto;
            mso-font-charset:0;
            mso-number-format:General;
            text-align:general;
            vertical-align:bottom;
            mso-background-source:auto;
            mso-pattern:auto;
            white-space:nowrap;}
        .xl646858
            {padding-top:1px;
            padding-right:1px;
            padding-left:1px;
            mso-ignore:padding;
            color:black;
            font-size:10.0pt;
            font-weight:400;
            font-style:normal;
            text-decoration:none;
            font-family:Ebrima;
            mso-generic-font-family:auto;
            mso-font-charset:0;
            mso-number-format:Standard;
            text-align:general;
            vertical-align:bottom;
            mso-background-source:auto;
            mso-pattern:auto;
            white-space:nowrap;}
        .xl656858
            {padding-top:1px;
            padding-right:1px;
            padding-left:1px;
            mso-ignore:padding;
            color:black;
            font-size:10.0pt;
            font-weight:400;
            font-style:normal;
            text-decoration:none;
            font-family:Ebrima;
            mso-generic-font-family:auto;
            mso-font-charset:0;
            mso-number-format:General;
            text-align:general;
            vertical-align:bottom;
            border-top:none;
            border-right:none;
            border-bottom:none;
            border-left:.5pt solid #BFBFBF;
            mso-background-source:auto;
            mso-pattern:auto;
            white-space:nowrap;}
        .xl666858
            {padding-top:1px;
            padding-right:1px;
            padding-left:1px;
            mso-ignore:padding;
            color:black;
            font-size:10.0pt;
            font-weight:400;
            font-style:normal;
            text-decoration:none;
            font-family:Ebrima;
            mso-generic-font-family:auto;
            mso-font-charset:0;
            mso-number-format:Standard;
            text-align:general;
            vertical-align:bottom;
            border-top:none;
            border-right:.5pt solid #BFBFBF;
            border-bottom:none;
            border-left:none;
            mso-background-source:auto;
            mso-pattern:auto;
            white-space:nowrap;}
        .xl676858
            {padding-top:1px;
            padding-right:1px;
            padding-left:1px;
            mso-ignore:padding;
            color:black;
            font-size:10.0pt;
            font-weight:700;
            font-style:normal;
            text-decoration:none;
            font-family:Ebrima;
            mso-generic-font-family:auto;
            mso-font-charset:0;
            mso-number-format:Standard;
            text-align:general;
            vertical-align:bottom;
            border-top:none;
            border-right:.5pt solid #BFBFBF;
            border-bottom:none;
            border-left:none;
            mso-background-source:auto;
            mso-pattern:auto;
            white-space:nowrap;}
        .xl686858
            {padding-top:1px;
            padding-right:1px;
            padding-left:1px;
            mso-ignore:padding;
            color:black;
            font-size:11.0pt;
            font-weight:700;
            font-style:normal;
            text-decoration:none;
            font-family:Ebrima;
            mso-generic-font-family:auto;
            mso-font-charset:0;
            mso-number-format:General;
            text-align:left;
            vertical-align:bottom;
            mso-background-source:auto;
            mso-pattern:auto;
            white-space:nowrap;}
        .xl696858
            {padding-top:1px;
            padding-right:1px;
            padding-left:1px;
            mso-ignore:padding;
            color:black;
            font-size:9.0pt;
            font-weight:400;
            font-style:normal;
            text-decoration:none;
            font-family:Ebrima;
            mso-generic-font-family:auto;
            mso-font-charset:0;
            mso-number-format:General;
            text-align:left;
            vertical-align:bottom;
            mso-background-source:auto;
            mso-pattern:auto;
            white-space:nowrap;}
        .xl706858
            {padding-top:1px;
            padding-right:1px;
            padding-left:1px;
            mso-ignore:padding;
            color:black;
            font-size:9.0pt;
            font-weight:400;
            font-style:normal;
            text-decoration:none;
            font-family:Ebrima;
            mso-generic-font-family:auto;
            mso-font-charset:0;
            mso-number-format:General;
            text-align:left;
            vertical-align:top;
            mso-background-source:auto;
            mso-pattern:auto;
            white-space:nowrap;}
        .xl716858
            {padding-top:1px;
            padding-right:1px;
            padding-left:1px;
            mso-ignore:padding;
            color:black;
            font-size:10.0pt;
            font-weight:700;
            font-style:normal;
            text-decoration:none;
            font-family:Ebrima;
            mso-generic-font-family:auto;
            mso-font-charset:0;
            mso-number-format:Standard;
            text-align:right;
            vertical-align:bottom;
            border-top:none;
            border-right:none;
            border-bottom:none;
            border-left:.5pt solid #BFBFBF;
            mso-background-source:auto;
            mso-pattern:auto;
            white-space:nowrap;}
        .xl726858
            {padding-top:1px;
            padding-right:1px;
            padding-left:1px;
            mso-ignore:padding;
            color:black;
            font-size:10.0pt;
            font-weight:700;
            font-style:normal;
            text-decoration:none;
            font-family:Ebrima;
            mso-generic-font-family:auto;
            mso-font-charset:0;
            mso-number-format:Standard;
            text-align:right;
            vertical-align:bottom;
            mso-background-source:auto;
            mso-pattern:auto;
            white-space:nowrap;}
        .xl736858
            {padding-top:1px;
            padding-right:1px;
            padding-left:1px;
            mso-ignore:padding;
            color:white;
            font-size:11.0pt;
            font-weight:700;
            font-style:normal;
            text-decoration:none;
            font-family:Ebrima;
            mso-generic-font-family:auto;
            mso-font-charset:0;
            mso-number-format:General;
            text-align:left;
            vertical-align:bottom;
            border-top:.5pt solid #BFBFBF;
            border-right:none;
            border-bottom:.5pt solid #BFBFBF;
            border-left:.5pt solid #BFBFBF;
            background:#2F75B5;
            mso-pattern:black none;
            white-space:nowrap;}
        .xl746858
            {padding-top:1px;
            padding-right:1px;
            padding-left:1px;
            mso-ignore:padding;
            color:white;
            font-size:11.0pt;
            font-weight:700;
            font-style:normal;
            text-decoration:none;
            font-family:Ebrima;
            mso-generic-font-family:auto;
            mso-font-charset:0;
            mso-number-format:General;
            text-align:left;
            vertical-align:bottom;
            border-top:.5pt solid #BFBFBF;
            border-right:none;
            border-bottom:.5pt solid #BFBFBF;
            border-left:none;
            background:#2F75B5;
            mso-pattern:black none;
            white-space:nowrap;}
        .xl756858
            {padding-top:1px;
            padding-right:1px;
            padding-left:1px;
            mso-ignore:padding;
            color:white;
            font-size:11.0pt;
            font-weight:700;
            font-style:normal;
            text-decoration:none;
            font-family:Ebrima;
            mso-generic-font-family:auto;
            mso-font-charset:0;
            mso-number-format:General;
            text-align:left;
            vertical-align:bottom;
            border-top:.5pt solid #BFBFBF;
            border-right:.5pt solid #BFBFBF;
            border-bottom:.5pt solid #BFBFBF;
            border-left:none;
            background:#2F75B5;
            mso-pattern:black none;
            white-space:nowrap;}
        .xl766858
            {padding-top:1px;
            padding-right:1px;
            padding-left:1px;
            mso-ignore:padding;
            color:black;
            font-size:9.0pt;
            font-weight:700;
            font-style:normal;
            text-decoration:none;
            font-family:Ebrima;
            mso-generic-font-family:auto;
            mso-font-charset:0;
            mso-number-format:Standard;
            text-align:left;
            vertical-align:bottom;
            mso-background-source:auto;
            mso-pattern:auto;
            white-space:nowrap;}
        .xl776858
            {padding-top:1px;
            padding-right:1px;
            padding-left:1px;
            mso-ignore:padding;
            color:black;
            font-size:10.0pt;
            font-weight:400;
            font-style:normal;
            text-decoration:none;
            font-family:Ebrima;
            mso-generic-font-family:auto;
            mso-font-charset:0;
            mso-number-format:Standard;
            text-align:left;
            vertical-align:bottom;
            mso-background-source:auto;
            mso-pattern:auto;
            white-space:nowrap;}
        .xl786858
            {padding-top:1px;
            padding-right:1px;
            padding-left:1px;
            mso-ignore:padding;
            color:black;
            font-size:9.0pt;
            font-weight:400;
            font-style:normal;
            text-decoration:none;
            font-family:Ebrima;
            mso-generic-font-family:auto;
            mso-font-charset:0;
            mso-number-format:Standard;
            text-align:left;
            vertical-align:top;
            mso-background-source:auto;
            mso-pattern:auto;
            white-space:normal;}
        .xl796858
            {padding-top:1px;
            padding-right:1px;
            padding-left:1px;
            mso-ignore:padding;
            color:black;
            font-size:10.0pt;
            font-weight:400;
            font-style:normal;
            text-decoration:none;
            font-family:Ebrima;
            mso-generic-font-family:auto;
            mso-font-charset:0;
            mso-number-format:General;
            text-align:left;
            vertical-align:bottom;
            border-top:.5pt solid #BFBFBF;
            border-right:none;
            border-bottom:none;
            border-left:.5pt solid #BFBFBF;
            mso-background-source:auto;
            mso-pattern:auto;
            white-space:nowrap;}
        .xl806858
            {padding-top:1px;
            padding-right:1px;
            padding-left:1px;
            mso-ignore:padding;
            color:black;
            font-size:10.0pt;
            font-weight:400;
            font-style:normal;
            text-decoration:none;
            font-family:Ebrima;
            mso-generic-font-family:auto;
            mso-font-charset:0;
            mso-number-format:General;
            text-align:left;
            vertical-align:bottom;
            border-top:.5pt solid #BFBFBF;
            border-right:none;
            border-bottom:none;
            border-left:none;
            mso-background-source:auto;
            mso-pattern:auto;
            white-space:nowrap;}
        .xl816858
            {padding-top:1px;
            padding-right:1px;
            padding-left:1px;
            mso-ignore:padding;
            color:black;
            font-size:10.0pt;
            font-weight:400;
            font-style:normal;
            text-decoration:none;
            font-family:Ebrima;
            mso-generic-font-family:auto;
            mso-font-charset:0;
            mso-number-format:General;
            text-align:left;
            vertical-align:bottom;
            border-top:.5pt solid #BFBFBF;
            border-right:.5pt solid #BFBFBF;
            border-bottom:none;
            border-left:none;
            mso-background-source:auto;
            mso-pattern:auto;
            white-space:nowrap;}
        .xl826858
            {padding-top:1px;
            padding-right:1px;
            padding-left:1px;
            mso-ignore:padding;
            color:black;
            font-size:10.0pt;
            font-weight:400;
            font-style:normal;
            text-decoration:none;
            font-family:Ebrima;
            mso-generic-font-family:auto;
            mso-font-charset:0;
            mso-number-format:General;
            text-align:left;
            vertical-align:bottom;
            mso-background-source:auto;
            mso-pattern:auto;
            white-space:nowrap;}
        .xl836858
            {padding-top:1px;
            padding-right:1px;
            padding-left:1px;
            mso-ignore:padding;
            color:black;
            font-size:9.0pt;
            font-weight:700;
            font-style:normal;
            text-decoration:none;
            font-family:Ebrima;
            mso-generic-font-family:auto;
            mso-font-charset:0;
            mso-number-format:General;
            text-align:left;
            vertical-align:bottom;
            mso-background-source:auto;
            mso-pattern:auto;
            white-space:nowrap;}
        .xl846858
            {padding-top:1px;
            padding-right:1px;
            padding-left:1px;
            mso-ignore:padding;
            color:black;
            font-size:9.0pt;
            font-weight:400;
            font-style:normal;
            text-decoration:none;
            font-family:Ebrima;
            mso-generic-font-family:auto;
            mso-font-charset:0;
            mso-number-format:General;
            text-align:center;
            vertical-align:bottom;
            mso-background-source:auto;
            mso-pattern:auto;
            white-space:nowrap;}
        .xl856858
            {padding-top:1px;
            padding-right:1px;
            padding-left:1px;
            mso-ignore:padding;
            color:black;
            font-size:10.0pt;
            font-weight:400;
            font-style:normal;
            text-decoration:none;
            font-family:Ebrima;
            mso-generic-font-family:auto;
            mso-font-charset:0;
            mso-number-format:Standard;
            text-align:center;
            vertical-align:top;
            border-top:none;
            border-right:none;
            border-bottom:none;
            border-left:.5pt solid #BFBFBF;
            mso-background-source:auto;
            mso-pattern:auto;
            white-space:nowrap;}
        .xl866858
            {padding-top:1px;
            padding-right:1px;
            padding-left:1px;
            mso-ignore:padding;
            color:black;
            font-size:10.0pt;
            font-weight:400;
            font-style:normal;
            text-decoration:none;
            font-family:Ebrima;
            mso-generic-font-family:auto;
            mso-font-charset:0;
            mso-number-format:Standard;
            text-align:center;
            vertical-align:top;
            mso-background-source:auto;
            mso-pattern:auto;
            white-space:nowrap;}
        .xl876858
            {padding-top:1px;
            padding-right:1px;
            padding-left:1px;
            mso-ignore:padding;
            color:black;
            font-size:10.0pt;
            font-weight:400;
            font-style:normal;
            text-decoration:none;
            font-family:Ebrima;
            mso-generic-font-family:auto;
            mso-font-charset:0;
            mso-number-format:Standard;
            text-align:center;
            vertical-align:top;
            border-top:none;
            border-right:.5pt solid #BFBFBF;
            border-bottom:none;
            border-left:none;
            mso-background-source:auto;
            mso-pattern:auto;
            white-space:nowrap;}
        .xl886858
            {padding-top:1px;
            padding-right:1px;
            padding-left:1px;
            mso-ignore:padding;
            color:black;
            font-size:10.0pt;
            font-weight:400;
            font-style:normal;
            text-decoration:none;
            font-family:Ebrima;
            mso-generic-font-family:auto;
            mso-font-charset:0;
            mso-number-format:Standard;
            text-align:center;
            vertical-align:top;
            border-top:none;
            border-right:none;
            border-bottom:.5pt solid #BFBFBF;
            border-left:.5pt solid #BFBFBF;
            mso-background-source:auto;
            mso-pattern:auto;
            white-space:nowrap;}
        .xl896858
            {padding-top:1px;
            padding-right:1px;
            padding-left:1px;
            mso-ignore:padding;
            color:black;
            font-size:10.0pt;
            font-weight:400;
            font-style:normal;
            text-decoration:none;
            font-family:Ebrima;
            mso-generic-font-family:auto;
            mso-font-charset:0;
            mso-number-format:Standard;
            text-align:center;
            vertical-align:top;
            border-top:none;
            border-right:none;
            border-bottom:.5pt solid #BFBFBF;
            border-left:none;
            mso-background-source:auto;
            mso-pattern:auto;
            white-space:nowrap;}
        .xl906858
            {padding-top:1px;
            padding-right:1px;
            padding-left:1px;
            mso-ignore:padding;
            color:black;
            font-size:10.0pt;
            font-weight:400;
            font-style:normal;
            text-decoration:none;
            font-family:Ebrima;
            mso-generic-font-family:auto;
            mso-font-charset:0;
            mso-number-format:Standard;
            text-align:center;
            vertical-align:top;
            border-top:none;
            border-right:.5pt solid #BFBFBF;
            border-bottom:.5pt solid #BFBFBF;
            border-left:none;
            mso-background-source:auto;
            mso-pattern:auto;
            white-space:nowrap;}
        .xl916858
            {padding-top:1px;
            padding-right:1px;
            padding-left:1px;
            mso-ignore:padding;
            color:black;
            font-size:10.0pt;
            font-weight:700;
            font-style:normal;
            text-decoration:none;
            font-family:Ebrima;
            mso-generic-font-family:auto;
            mso-font-charset:0;
            mso-number-format:General;
            text-align:left;
            vertical-align:bottom;
            border-top:.5pt solid #BFBFBF;
            border-right:none;
            border-bottom:.5pt solid #BFBFBF;
            border-left:none;
            mso-background-source:auto;
            mso-pattern:auto;
            white-space:nowrap;}
        .xl926858
            {padding-top:1px;
            padding-right:1px;
            padding-left:1px;
            mso-ignore:padding;
            color:black;
            font-size:10.0pt;
            font-weight:700;
            font-style:normal;
            text-decoration:none;
            font-family:Ebrima;
            mso-generic-font-family:auto;
            mso-font-charset:0;
            mso-number-format:General;
            text-align:left;
            vertical-align:bottom;
            border-top:.5pt solid #BFBFBF;
            border-right:none;
            border-bottom:.5pt solid #BFBFBF;
            border-left:.5pt solid #BFBFBF;
            mso-background-source:auto;
            mso-pattern:auto;
            white-space:nowrap;}
        .xl936858
            {padding-top:1px;
            padding-right:1px;
            padding-left:1px;
            mso-ignore:padding;
            color:black;
            font-size:10.0pt;
            font-weight:700;
            font-style:normal;
            text-decoration:none;
            font-family:Ebrima;
            mso-generic-font-family:auto;
            mso-font-charset:0;
            mso-number-format:Standard;
            text-align:left;
            vertical-align:bottom;
            border-top:.5pt solid #BFBFBF;
            border-right:none;
            border-bottom:.5pt solid #BFBFBF;
            border-left:none;
            mso-background-source:auto;
            mso-pattern:auto;
            white-space:nowrap;}
        .xl946858
            {padding-top:1px;
            padding-right:1px;
            padding-left:1px;
            mso-ignore:padding;
            color:black;
            font-size:10.0pt;
            font-weight:700;
            font-style:normal;
            text-decoration:none;
            font-family:Ebrima;
            mso-generic-font-family:auto;
            mso-font-charset:0;
            mso-number-format:Standard;
            text-align:left;
            vertical-align:bottom;
            border-top:.5pt solid #BFBFBF;
            border-right:.5pt solid #BFBFBF;
            border-bottom:.5pt solid #BFBFBF;
            border-left:none;
            mso-background-source:auto;
            mso-pattern:auto;
            white-space:nowrap;}
        .xl956858
            {padding-top:1px;
            padding-right:1px;
            padding-left:1px;
            mso-ignore:padding;
            color:black;
            font-size:9.0pt;
            font-weight:400;
            font-style:normal;
            text-decoration:none;
            font-family:Ebrima;
            mso-generic-font-family:auto;
            mso-font-charset:0;
            mso-number-format:General;
            text-align:center;
            vertical-align:bottom;
            border-top:none;
            border-right:none;
            border-bottom:.5pt solid #BFBFBF;
            border-left:none;
            mso-background-source:auto;
            mso-pattern:auto;
            white-space:nowrap;}
        .xl966858
            {padding-top:1px;
            padding-right:1px;
            padding-left:1px;
            mso-ignore:padding;
            color:black;
            font-size:11.0pt;
            font-weight:700;
            font-style:normal;
            text-decoration:none;
            font-family:Calibri, sans-serif;
            mso-font-charset:0;
            mso-number-format:General;
            text-align:center;
            vertical-align:middle;
            mso-background-source:auto;
            mso-pattern:auto;
            white-space:nowrap;}
        .xl976858
            {padding-top:1px;
            padding-right:1px;
            padding-left:1px;
            mso-ignore:padding;
            color:black;
            font-size:11.0pt;
            font-weight:400;
            font-style:normal;
            text-decoration:none;
            font-family:Calibri, sans-serif;
            mso-font-charset:0;
            mso-number-format:General;
            text-align:center;
            vertical-align:middle;
            mso-background-source:auto;
            mso-pattern:auto;
            white-space:nowrap;}
        -->
        </style>
        </head>

        <body>
        <!--[if !excel]>&nbsp;&nbsp;<![endif]-->
        <!--As seguintes informações foram geradas pelo Assistente para Publicação como
        Página da Web do Microsoft Excel.-->
        <!--Se o mesmo item for republicado a partir do Excel, todas as informações
        entre as marcas DIV serão substituídas.-->


        <div id="Modelo de Extrato_6858" align="center" x:publishsource="Excel">

        <table border="0" cellpadding="0" cellspacing="0" width="501" align="center" class="xl655356858" style="border-collapse:collapse;table-layout:fixed;width:400pt">
        <colgroup><col class="xl655356858" width="98" style="mso-width-source:userset;mso-width-alt:
        3470;width:73pt">
        <col class="xl655356858" width="53" style="mso-width-source:userset;mso-width-alt:
        1877;width:40pt">
        <col class="xl655356858" width="59" style="mso-width-source:userset;mso-width-alt:
        2104;width:44pt">
        <col class="xl655356858" width="70" style="mso-width-source:userset;mso-width-alt:
        2503;width:53pt">
        <col class="xl655356858" width="50" style="mso-width-source:userset;mso-width-alt:
        1763;width:37pt">
        <col class="xl655356858" width="89" style="mso-width-source:userset;mso-width-alt:
        3157;width:67pt">
        <col class="xl655356858" width="82" style="mso-width-source:userset;mso-width-alt:
        2901;width:61pt">
        </colgroup><tbody><tr height="22" style="height:16.8pt">
        <td colspan="4" height="22" class="xl686858" width="280" style="height:16.8pt;
        width:210pt;font-weight: bold">Extrato da conta</td>
        <td class="xl655356858" width="50" style="width:37pt"></td>
        <td colspan="2" rowspan="3" class="xl966858" width="171" style="width:128pt"><img width="120" src="images/logo.png"></td>
        </tr>
        <tr height="19" style="height:14.4pt">
        <td height="19" class="xl636858" style="height:14.4pt">Data de emissão:</td>';
        

        ## Data e hora da emissão do extrato
        #$dataHoraEmissao = "dd/mm/yyyy às HH:MM";
        $html .= '<td colspan="3" class="xl696858">'.$dataHoraEmissao.'</td>';
        
        $html .= '<td class="xl655356858"></td>
        </tr>
        <tr height="19" style="height:14.4pt">
        <td height="19" class="xl636858" style="height:14.4pt">Período:</td>';

        #$periodoExtrato = "dd/mm/yyyy a dd/mm/yyyy";
        $html .= '<td colspan="3" class="xl696858">'.$periodoExtrato.'</td>';
        
        $html .= '<td class="xl655356858"></td>
        </tr>
        <tr height="19" style="height:14.4pt">
        <td height="19" class="xl636858" style="height:14.4pt"></td>
        <td colspan="3" class="xl696858"></td>
        <td class="xl655356858"></td>
        <td class="xl655356858"></td>
        <td class="xl655356858"></td>
        </tr>
        <tr height="20" style="height:15.0pt">
        <td colspan="4" height="20" class="xl836858" style="height:15.0pt; font-weight: bold">Cliente</td>
        <td class="xl655356858"></td>
        <td colspan="2" class="xl766858" style="font-weight: bold">SSG Smart Solutions Group</td>
        </tr>
        <tr height="22" style="mso-height-source:userset;height:16.8pt">';

        #$razaoSocialCliente = "Distribuidora ligeirinho de produtos alimentícios";
        $html .= '<td colspan="4" height="22" class="xl706858" style="height:16.8pt">'.$razaoSocialCliente.'<span style="mso-spacerun:yes">&nbsp;</span></td>';

        $html .= '<td class="xl655356858"></td>
        <td colspan="2" rowspan="3" class="xl786858" width="171" style="width:128pt">Av. das
        Américas 3301, Bloco 03 Sala 201, Barra da Tijuca-RJ,
        operacional@ssgbank.com.br</td>
        </tr>
        <tr height="19" style="height:14.4pt">';

        #$cnpjCliente = "04.067.573/0001-93";
        $html .= '<td colspan="4" height="19" class="xl706858" style="height:14.4pt">CNPJ: '.$cnpjCliente.'</td>';

        $html .= '<td class="xl655356858"></td>
        </tr>
        <tr height="19" style="height:14.4pt">
        <td colspan="4" height="19" class="xl846858" style="height:14.4pt"></td>
        <td class="xl655356858"></td>
        </tr>
        <tr height="19" style="height:14.4pt">
        <td colspan="7" height="19" class="xl956858" style="height:14.4pt">&nbsp;</td>
        </tr>
        <tr height="22" style="height:16.8pt">
        <td colspan="7" height="22" class="xl736858" style="border-right:.5pt solid #BFBFBF;
        height:16.8pt; font-weight: bold">Atividade na conta</td>
        </tr>
        <tr height="20" style="height:15.0pt">
        <td height="20" class="xl926858" style="height:15.0pt;border-top:none; font-weight: bold">Data</td>
        <td colspan="4" class="xl916858" style="font-weight: bold">Detalhe</td>
        <td class="xl936858" style="border-top:none; font-weight: bold">Crédito (R$)</td>
        <td class="xl946858" style="border-top:none; font-weight: bold">Débito (R$)</td>
        </tr>';

        $extratoMovimentacoes = json_decode($extrato['Entry']);
        
        foreach($extratoMovimentacoes as $ext){
            
            
            $dataHoraMovimentacao = entryDate2dataHora($ext->EntryDate);

            $dataBruta = $ext->EntryDate;

            $dt = explode('T',$ext->EntryDate);
            $dataTemp = explode('-',$dt[0]);
            $horaTemp = explode(':',$dt[1]);
            $dataFormatada = $dataTemp[2].'/'.$dataTemp[1].'/'.substr($dataTemp[0], 2, 4).'-'.$horaTemp[0].':'.$horaTemp[1];
            #$dataFormatada = date_format(date_create($dt[0]."-".$dt[1]),"Y/m/d H:i:s");
            #dataUs2Br($dt[0]).' - '.substr($dt[1], 0, 5);

            $valorMovimentacao = formatMoneyBr($ext->EntryValue);
            $descricaoMovimentacao = $ext->Details;

            $html .= '<tr height="20" style="height:15.0pt">
            <td height="20" class="xl656858" style="height:15.0pt;vertical-align: top;">'.$dataFormatada.'</td>
            <td colspan="4" class="xl826858" style="word-wrap:break-word;vertical-align: top;">'.$descricaoMovimentacao.'</td>';

            if($valorMovimentacao>=0){
                $html .= '<td class="xl646858" align="right" style="vertical-align: top;">'.$valorMovimentacao.'</td>
                <td class="xl666858">&nbsp;</td>';
            }
            else{
                $html .= '<td class="xl646858"></td>
                <td class="xl666858" align="right" style="vertical-align: top;">'.$valorMovimentacao.'</td>
                </tr>';
            }
            
        }


        $html .= '<tr height="20" style="height:15.0pt">
        <td colspan="6" height="20" class="xl716858" style="height:15.0pt; font-weight: bold">Saldo em conta:</td>';
        
        #$saldoEmConta = "7.977,01";
        $html .= '<td class="xl676858" align="right">'.$saldoEmConta.'</td>';
        
        $html .= '</tr>
        <tr height="20" style="height:15.0pt">
        <td colspan="6" height="20" class="xl716858" style="height:15.0pt; font-weight: bold">Saldo + Saldo a
        compensar:</td>';

        #$saldoMaisLimite = "10.000,01";
        $html .= '<td class="xl676858" align="right">'.$saldoMaisLimite.'</td>';

        $html .= '</tr>
        <tr height="20" style="height:15.0pt">
        <td colspan="7" height="20" class="xl796858" style="border-right:.5pt solid #BFBFBF;
        height:15.0pt; font-weight: bold">Anotações:</td>
        </tr>
        <tr height="20" style="mso-height-source:userset;height:15.0pt">
        <td colspan="7" rowspan="2" height="39" class="xl856858" style="border-right:.5pt solid #BFBFBF;
        border-bottom:.5pt solid #BFBFBF;height:29.4pt">&nbsp;</td>
        </tr>
        <tr height="19" style="height:14.4pt">
        </tr>
        <!--[if supportMisalignedColumns]-->
        <tr height="0" style="display:none">
        <td width="98" style="width:73pt"></td>
        <td width="53" style="width:40pt"></td>
        <td width="59" style="width:44pt"></td>
        <td width="70" style="width:53pt"></td>
        <td width="50" style="width:37pt"></td>
        <td width="89" style="width:67pt"></td>
        <td width="82" style="width:61pt"></td>
        </tr>
        <!--[endif]-->
        </tbody></table>

        </div>

        </body></html>';

        #print($html);
        
        $mpdf->SetTitle("Extrato SPS");
        $mpdf->SetAuthor("SPS");
        $nomeArquivo="Extrato-".date('(Y-m-d)').".pdf";
  
        // #$modelo = file_get_contents("resources/views/templates/modelo_extrato.htm");
        // #$modelo = file_get_contents("resources/views/templates/hello.htm");
        
        $mpdf->WriteHTML($html);
        $mpdf->Output($nomeArquivo,"I");

        exit;

    }

  
}
