<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;

use App\Client;
use App\User;
use App\Garepayment;

class GarepaymentController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
    * gareFormulario
    */
    public function gareFormulario() {
        $client = getClientById(Auth::user()->client_id);

        return view('clients.gareForm',compact('client'));
    }

    /**
    * gareEnviar
    */
    public function gareEnviar(Request $request) {
// TODO ratevalue
        $client = getClientById(Auth::user()->client_id);

        $spsInfo = getSPS();

        // CONSULTA O SALDO DO CLIENTE
        $saldoCliente = saldoCliente($client->taxnumber);
        $saldoDisponivel = $client->availablelimit;
        // valor a ser transferido
        $valor = covert2Float($request->totalvalue);
        $logLimitUsed = false;

        $saldoCompensar = 0;
        $saldoCompensarValor = 0;
        $internaltransferdocumentnumber = 0;
        $cashbackvalue = 0;

        $cli_ratevalue = consultaTaxaCliente($client->id, 'payment', covert2Float($request->totalvalue));

        // verifica se o disponível é >= valor a ser transferido
        if($valor > $saldoCliente) {
            // se não for, verifica se permite usar saldo a compensar
            if(isset($request->limiteespecial) && $request->limiteespecial == 1) {

                // saldo a transferir para completar o pagamento
                $saldoATransferir = ($valor - $saldoCliente);

                // ao saldo a transferir deve ser adicionada a taxa
                $cashbackvalue = consultaTaxaCliente($client->id, 'internaltransfer', $saldoATransferir);

                // verifica se o cliente possui saldo a compensar suficiente
                if( ($saldoCliente + $saldoDisponivel) < ($valor + $cashbackvalue + $cli_ratevalue) ) {
                    return redirect('gare')->with('warning', 'Não há saldo suficiente para realizar a operação.');
                } else {
                    // realiza a transferencia do valor adicional para o cliente
                    $transfereSaldoDisponivel = transfereSaldoDisponivelCliente($client->taxnumber, ( $saldoATransferir + $cashbackvalue), 'Transferencia de saldo a compensar', $cashbackvalue, $cli_ratevalue);

                    if(!$transfereSaldoDisponivel) return redirect('gare')->with('warning', 'Ocorreu um erro ao realizar a operação. Por favor tente mais tarde.');

                    // $logLimitUsed = logAvailableLimitUsed(Auth::user()->id, $client->id, $client->taxnumber, $client->availablelimit, $saldoATransferir, 'DARF', '0', false); // salva detalhamento
                    $logLimitUsed = true;
                    $saldoCompensar = 1;
                    $saldoCompensarValor = $saldoATransferir;
                    $internaltransferdocumentnumber = $transfereSaldoDisponivel;
                }
            } else {
                return redirect('gare')->with('warning', 'Não há saldo suficiente para realizar a operação.');
            }
        }
        // /CONSULTA O SALDO DO CLIENTE

        $newIdentifier = concatIdentifier($request->identifier);

        

        $curlParams = "{ \"Method\": \"GeneratePaymentGARE\",
                    \"PartnerId\": ".$spsInfo->partnerid.",
                    \"BusinessUnitId\": ".$spsInfo->businessunitid.",
                    \"TaxNumber\": \"".somenteNumeros($request->taxnumber)."\",
                    \"ContributorTaxNumber\": \"".somenteNumeros($request->contributortaxnumber)."\",
                    \"ReferenceNumber\": \"".somenteNumeros($request->referencenumber)."\",
                    \"PrincipalValue\": ".covert2Float($request->principalvalue).",
                    \"FineValue\": ".covert2Float($request->finevalue).",
                    \"InterestValue\": ".covert2Float($request->interestvalue).",
                    \"TotalValue\": ".covert2Float($request->totalvalue).",
                    \"RateValue\": \"".$cli_ratevalue."\",
                    \"PaymentDate\": \"".date2us($request->paymentdate)."\",
                    \"DueDate\": \"".dataSlashReverse($request->duedate)."\",
                    \"CodeRevenue\": \"".$request->coderevenue."\",
                    \"StateRegistration\": \"".$request->stateregistration."\",
                    \"ActiveDebit\": \"".$request->activedebit."\",
                    \"QuoteNumberNotification\": \"".$request->quotenumbernotification."\",
                    \"RateValueType\": \"1\",
                    \"Description\": \"".$request->description."\",
                    \"Identifier\": \"".$newIdentifier."\",
                    \"GareType\": \"".$request->garetype."\"
                }";

        $enviar = sendCurl($curlParams);

        if($enviar["Success"] == "false") {
            $validacao = (isset($enviar['Validation']))?serialize($enviar['Validation']):'';
            $mensagem = (isset($enviar['Message']))?$enviar['Message']:'';
            saveTransferErrorLog('GeneratePaymentGARE', $curlParams, $mensagem, $validacao);

            return redirect('/gare')->with('warning', 'Erro: ocorreu um problema ao processar a requisição. '.$enviar['Message']);
        }

        $documentnumber = (isset($enviar['DocumentNumber']))?$enviar['DocumentNumber']:'0';
        $alreadyexists = (isset($enviar['AlreadyExists']))?1:0;

        $checkDocnumber = $this->checkExists($documentnumber);
        if(!$checkDocnumber) {
            $viewStatus = 'status';
            $viewMessage = 'Documento enviado.';
            $this->saveGareLog(somenteNumeros($client->taxnumber),$request, $curlParams,$documentnumber,$alreadyexists, 0, $newIdentifier,$saldoCompensar,$saldoCompensarValor);

            if($logLimitUsed) logAvailableLimitUsed(Auth::user()->id, $client->id, $client->taxnumber, $client->availablelimit, $saldoATransferir, 'GARE', $documentnumber, false, $internaltransferdocumentnumber, $cashbackvalue); // atualiza detalhamento
        } else {
            $viewStatus = 'danger';
            $viewMessage = 'O documento já foi enviado anteriormente!';
        }

        return view('clients.gareEnviado',compact('enviar'))->with($viewStatus,$viewMessage);
    }

    /**
    * gareListar
    */

    public function gareConsultar(Request $request) {
        $client = Client::select('clients.*')->where('id','=',Auth::user()->client_id)->first();
        
        if ($request->isMethod('post') && $request->datade != ''  && $request->dataate != '' && ( $request->datade <= $request->dataate )) {
            $datade  = date(dataSlashReverse($request->datade), strtotime('-15 days'));
            $dataate = date(dataSlashReverse($request->dataate));           
        } else {
            $datade  = date('Y/m/d', strtotime('-15 days'));
            $dataate = date('Y/m/d');   
        }

        $q_gares = Garepayment::where('taxnumber','=',$request->taxnumber)
                            ->whereDate('emission','>=',$datade)
                            ->whereDate('emission','<=',$dataate);

        if(isset($request) && $request->filtrostatus != '')
            $q_gares->where('status','=',$request->filtrostatus);


        $gares = $q_gares->orderBy('created_at','desc')->get();

        $filtrostatus  = (isset($request) && $request->filtrostatus != '')?$request->filtrostatus:'';

        $datafiltro = array('datade'=>dataSlashReverse($datade),'dataate'=>dataSlashReverse($dataate), 'filtrostatus'=>$filtrostatus);

        return view('clients.gareConsultar',compact('gares','datafiltro'));
    }

    public function checkExists($docnumber) {
        $check = Garepayment::where('documentnumber','=',$docnumber)->first();
        return (!$check)?false:true;
    }


    /* ******************  LOGS  ****************** */

    public function saveGareLog($taxnumber, $request, $curlParams,$documentnumber,$alreadyexists,$ratevalue, $newIdentifier, $saldoCompensar,$saldoCompensarValor) {

        $userInfo = Auth::user();

        $logerror = new Garepayment();
        $logerror->user_id = $userInfo->id;
        $logerror->client_id = $userInfo->client_id;
        $logerror->taxnumber = $taxnumber;
        $logerror->emission = date('Y-m-d H:i:s');
        $logerror->contributortaxnumber = somenteNumeros($request->contributortaxnumber);
        $logerror->referencenumber = $request->referencenumber;
        $logerror->principalvalue = covert2Float($request->principalvalue);
        $logerror->finevalue = covert2Float($request->finevalue);
        $logerror->interestvalue = covert2Float($request->interestvalue);
        $logerror->totalvalue = covert2Float($request->totalvalue);
        $logerror->paymentdate = dataSlashReverse($request->paymentdate);
        $logerror->duedate = dataSlashReverse($request->duedate);
        $logerror->coderevenue = $request->coderevenue;
        $logerror->stateregistration = $request->stateregistration;
        $logerror->activedebit = $request->activedebit;
        $logerror->quotenumbernotification = $request->quotenumbernotification;
        $logerror->description = $request->description;
        $logerror->identifier = $newIdentifier;
        $logerror->garetype = $request->garetype;
        $logerror->status = 0;
        $logerror->documentnumber = $documentnumber;
        $logerror->alreadyexists = $alreadyexists;
        $logerror->ratevalue = $ratevalue;
        $logerror->datasent = $curlParams;
        $logerror->limiteespecial = $saldoCompensar;
        $logerror->valorlimiteespecial = $saldoCompensarValor;
        $logerror->save();

// \"RateValue\": 4;

        return true;
    }

    
    public function gareCancelar() {
        $spsInfo = getSPS();
        // TODO terminar este método
        $curlParams = "{ \"Method\": \"CancelPaymentGare\",
                \"PartnerId\": ".$spsInfo->partnerid.",
                \"BusinessUnitId\": ".$spsInfo->businessunitid.",
                \"DocumentNumber\": \"".$docnumber."\"
             }";

        $enviar = sendCurl($curlParams);

        if($enviar["Success"] == "false") {
            $validacao = (isset($enviar['Validation']))?serialize($enviar['Validation']):'';
            $mensagem = (isset($enviar['Message']))?$enviar['Message']:'';
            saveTransferErrorLog('CancelPaymentGare', $curlParams, $mensagem, $validacao);

         return redirect('/gare')->with('warning', 'Erro: ocorreu um problema ao processar a requisição. '.$enviar['Message']);
        }


        
    }

}
