<?php

namespace App\Http\Controllers;

use App\Autotransferschedule;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;

use App\Classes\Loglevel;
use App\Classes\Log;
// use App\Spsinfo;
// use App\Transactionlog;
// use App\Transfererrorlog;
// use App\Billeterror;
use App\Client;
// use App\Usedavailablelimit;
// use App\Spsbank;

// use App\Transferlog;
// use App\Darfpayment;
// use App\Darjpayment;
// use App\Fgtspayment;
// use App\Gpspayment;
// use App\Garepayment;
// use App\Barcodepayment;
// use App\Billet;
// use App\MonthlyFeePayment;

// use DB;

// use App\Exports\ReportExport;
// use Maatwebsite\Excel\Facades\Excel;

use App\Classes\ClientSPS\ClientSpsService;
use App\Multisafe;
use App\Services\BankSsgService;
use App\Usedavailablelimit;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;

class TesteController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function testes(Request $request)
    {
        if(Auth::user()->role_id>1) {
            return redirect('/home')->with('warning', 'Você não tem permissão para acessar essa área.');
        }


        //dd(Loglevel::ERROR);

        //$actionName = Route::getCurrentRoute()->getActionName();
        //dd($actionName);

        return view('testes.testes');
    }

    public function testesDD(Request $request) {

        $acao = (isset($request->acao)) ? $request->acao : "nenhuma";
        $jsonEnc = json_encode(Session::all());

        switch ($acao) {
            case "dd_application_log" :
                $logIdTesteCriado = Log::saveLogAplicacao(Loglevel::ERROR, 'PAGAMENTO_BOLETO', Route::getCurrentRoute()->getActionName(), 'CRIADO', false, 'datajson');
                $logIdTesteAlterado = Log::saveLogAplicacao(Loglevel::WARNING, 'PAGAMENTO_BOLETO', Route::getCurrentRoute()->getActionName(), 'CRIADO', false, 'datajson');
                Log::saveLogAplicacao(Loglevel::WARNING, 'PAGAMENTO_BOLETO', Route::getCurrentRoute()->getActionName(), 'ALTERADO', true, null, $logIdTesteAlterado);
                $logIdTesteNaoCriadoPorNivel = Log::saveLogAplicacao(Loglevel::DEBUG, 'PAGAMENTO_BOLETO', Route::getCurrentRoute()->getActionName(), 'CRIADO', false, 'datajson');
                $logIdTesteNaoCriadoPorFeature = Log::saveLogAplicacao(Loglevel::ERROR, 'PAGAMENTO_BOLETO_NAOCRIAR', Route::getCurrentRoute()->getActionName(), 'CRIADO', false, 'datajson');
                dd("logIds = ".$logIdTesteCriado.", ".$logIdTesteAlterado,
                   "CT01 -> logIdTesteCriado = ".$logIdTesteCriado,
                   ".... -> logIdTesteNaoCriadoPorNivel (ZERO) = ".$logIdTesteNaoCriadoPorNivel,
                   ".... -> logIdTesteNaoCriadoPorFeature (ZERO) = ".$logIdTesteNaoCriadoPorFeature,
                   "CT02 -> logIdTesteAlterado = ".$logIdTesteAlterado,
                   "CT03 -> SESSION JSON ENCODED = ".$jsonEnc,
                   "CT04 -> logLevel: CRIADO = ".Loglevel::ERROR.", ALTERADO = ".Loglevel::WARNING,
                   ".... -> sucesso: CRIADO = 0 = false, ALTERADO = 1 = true",
                   ".... -> action = App\Http\Controllers\TesteController@testesDD"
                );
                break;
            case "dd_info_sessao" :
                $serial = serialize($request->session()->all());
                $deserial = unserialize($serial);
                $jsonDec = json_decode($jsonEnc, true);
                dd("SESSION ID = ".Session::getId(), "SESSION SERIALIZED = ".$serial,
                   "SESSION ARRAY :", $deserial, "USER:", Auth::user(),
                   "SESSION JSON ENCODED = ".$jsonEnc, "SESSION JSON ARRAY :", $jsonDec);
                break;
            default :
                dd('nenhuma ação');
        }
    }

    public function testesClienteSPS(Request $request) {
        if(Auth::user()->role_id > 1) {
            return redirect('/home')->with('warning', 'Você não tem permissão para acessar essa área.');
        }

        $json = '';
        $limiteEspecial = '';
        $limiteBoleto = '';
        $saldoCompensar = '';
        $saldoReal = '';
        $nomeCliente = '';
        $clientId = '';
        $limiteOperacao = array(
            'boleto'    => 0,
            'transferenciaExterna' => 0,
            'transferenciaInterna' => 0,
            'dxAutomatico' => 0,
        );
        $adiantar = array(
            'boleto'    => 0,
            'transferenciaExterna' => 0,
            'transferenciaInterna' => 0,
            'dxAutomatico' => 0,
            'taxaBoleto'=> 0,
            'taxaTransferenciaExterna' => 0,
            'taxaTransferenciaInterna' => 0,
            'taxaDxAutomatico' => 0,
            'txOperacaoBoleto'=> 0,
            'txOperacaoTransferenciaExterna' => 0,
            'txOperacaoTransferenciaInterna' => 0,
            'txOperacaoDxAutomatico' => 0,
            );
        $infoCliente = array(
            'nomeCliente'   => '',
            'clientId'      => '',
            'saldoReal'     => '',
            'saldoCompensar'=> '',
            'valorOperacao' => '',
        );
        $clients = Client::select('id','taxnumber', 'name','availablelimit')
                         ->where('active', '=', 1)
                         ->orderBy('name')
                         ->get();
        foreach($clients as $k=>$cli) {
            $clients[$k]->multiconta = getMultiCnpj($cli->id);
        }

        if (($request->isMethod('get')) || ($request->taxnumber == 0)) {
            return view('testes.clientesps',compact('clients', 'json', 'infoCliente','limiteEspecial',
                'limiteOperacao', 'adiantar'));
        }
        $valorTotalOperacao = isset($request->valor)? $request->valor : 0;
        $clienteSPS = new ClientSpsService($request->taxnumber);
        $json = json_encode($clienteSPS->executarTestesDEV($valorTotalOperacao));
        $limiteEspecial = isset($request->limiteespecial)? 'sim' : 'não';
        $usarLimiteEspecial = isset($request->limiteespecial)? true : false;

        $limiteOperacao = array(
            'boleto' => $clienteSPS->calculaLimiteDaOperacao('PAGAMENTO_BOLETO', $usarLimiteEspecial),
            'transferenciaExterna' => $clienteSPS->calculaLimiteDaOperacao('TRANSFERENCIA_EXTERNA', $usarLimiteEspecial),
            'transferenciaInterna' => $clienteSPS->calculaLimiteDaOperacao('TRANSFERENCIA_INTERNA', $usarLimiteEspecial),
            'dxAutomatico' => $clienteSPS->calculaLimiteDaOperacao('DX_AUTOMATICO', $usarLimiteEspecial)
        );

        $adiantar = array(
            'boleto'    => $clienteSPS->calculaSaldoAAdiantarParaOperacao('PAGAMENTO_BOLETO', $valorTotalOperacao),
            'transferenciaExterna' => $clienteSPS->calculaSaldoAAdiantarParaOperacao('TRANSFERENCIA_EXTERNA', $valorTotalOperacao),
            'transferenciaInterna' => $clienteSPS->calculaSaldoAAdiantarParaOperacao('TRANSFERENCIA_INTERNA', $valorTotalOperacao),
            'dxAutomatico' => $clienteSPS->calculaSaldoAAdiantarParaOperacao('DX_AUTOMATICO', $valorTotalOperacao),
            'taxaBoleto'=> $clienteSPS->calculaTaxaAdiantamentoParaOperacao('PAGAMENTO_BOLETO', $valorTotalOperacao),
            'taxaTransferenciaExterna' => $clienteSPS->calculaTaxaAdiantamentoParaOperacao('TRANSFERENCIA_EXTERNA', $valorTotalOperacao),
            'taxaTransferenciaInterna' => $clienteSPS->calculaTaxaAdiantamentoParaOperacao('TRANSFERENCIA_INTERNA', $valorTotalOperacao),
            'taxaDxAutomatico' => $clienteSPS->calculaTaxaAdiantamentoParaOperacao('DX_AUTOMATICO', $valorTotalOperacao),
            'txOperacaoBoleto'=> $clienteSPS->calculaTaxaDaOperacao('PAGAMENTO_BOLETO', $valorTotalOperacao),
            'txOperacaoTransferenciaExterna' => $clienteSPS->calculaTaxaDaOperacao('TRANSFERENCIA_EXTERNA', $valorTotalOperacao),
            'txOperacaoTransferenciaInterna' => $clienteSPS->calculaTaxaDaOperacao('TRANSFERENCIA_INTERNA', $valorTotalOperacao),
            'txOperacaoDxAutomatico' => $clienteSPS->calculaTaxaDaOperacao('DX_AUTOMATICO', $valorTotalOperacao)
        );
        $infoCliente = array(
            'nomeCliente'   => $clienteSPS->nickname,
            'clientId'      => $clienteSPS->clientId,
            'saldoReal'     => $clienteSPS->saldoReal,
            'saldoCompensar'=> $clienteSPS->saldoCompensar,
            'valorOperacao' => $valorTotalOperacao,
        );

        return view('testes.clientesps',compact('clients', 'json', 'infoCliente','limiteEspecial',
            'limiteOperacao', 'adiantar'));
    }

    /**
     * Esta função busca no BD a situação atual das mensalidades dos clientes e retorna na view
     * @param boolean $listarTodos Opcional.
     * @return view testes.mensalidade
     */
    public function testeMensalidades($listarTodos = false)
    {
        if (Auth::user()->role_id > 1) {
            return redirect('/home')->with('warning', 'Você não tem permissão para acessar essa área.');
        }

        // 1) Busca todos os clientes
        $clientes = Client::select('id',
                'name',
                'taxnumber',
                'availablelimit'
            )
            ->where('active', '1');
        $todosClientes = Multisafe::select('client_id as id',
                'nickname as name',
                'taxnumber',
                'availablelimit'
            )
            ->where('active', '1')
            ->union($clientes)->orderBy('name','ASC')->get();

        // Inicia array que retornará para view
        $dadosClientes = [];

        if (!$listarTodos) {

            // $listarTodos = false

            // 2) Em cada cliente, busca se há dívida de mensalidade para aquele cliente
            foreach ($todosClientes as $i => $cliente) {
                $buscaMensalidade = Usedavailablelimit::select('*')
                    ->join('clients', 'client_id', '=', 'clients.id')
                    ->where('transactiontype', '=', 'MENSALIDADE')
                    ->where('paid', '=', '0')
                    ->where('usedavailablelimits.taxnumber', '=', $cliente->taxnumber)
                    ->get();

                // 3) Achou mensalidade aberta para o cliente?
                if ($buscaMensalidade->isEmpty()) {
                    // Não achou mensalidade aberta para esse cliente, pula pro próximo cliente
                    continue;
                } else {
                    // Se encontrou, calcula todas as dívidas do cliente (incluido as que não forem de mensalidades)
                    $limites = Usedavailablelimit::select('*')
                        ->where('taxnumber', $cliente->taxnumber)
                        ->where('paid', 0)
                        ->get();

                    $valorAdiantamento = 0;
                    $taxa = 0;
                    $valorMensalidadeDevida = 0;
                    $saldoDevedor = 0;

                    foreach($limites as $lim) {
                        $valorAdiantamento += $lim->requestedvalue + $lim->ratevalue - $lim->paymentvalue;
                        $taxa += $lim->interestvalue;
                        $saldoDevedor += $lim->requestedvalue
                                + $lim->ratevalue
                                - $lim->paymentvalue
                                + $lim->interestvalue;
                        if ($lim->transactiontype == 'MENSALIDADE') $valorMensalidadeDevida += ($lim->paid == '0') ? ($lim->requestedvalue + $lim->ratevalue - $lim->paymentvalue) : 0;
                    }

                    $dadosClientes[$i] = [
                        'taxnumber' => $cliente->taxnumber,
                        'name' => $cliente->name,
                        'saldoACompensar' => $cliente->availablelimit,
                        'valorAdiantamento' => $valorAdiantamento,
                        'taxa' => $taxa,
                        'valorMensalidadeDevida' => $valorMensalidadeDevida,
                        'saldoDevedor' => $saldoDevedor
                    ];
                }
            }

        } else {

            // $listarTodos = true

            // 1) Busca todos os clientes
            $clientes = Client::select('id',
                    'name',
                    'taxnumber',
                    'availablelimit'
                )
                ->where('active', '1');
            $todosClientes = Multisafe::select('client_id as id',
                    'nickname as name',
                    'taxnumber',
                    'availablelimit'
                )
                ->where('active', '1')
                ->union($clientes)->orderBy('name','ASC')->get();

            // 2) Em cada cliente, buscar seus limites utilizados (usedavailablelimits)
            foreach($todosClientes as $i => $cliente) {
                $limites = Usedavailablelimit::select('*')
                    ->where('taxnumber', $cliente->taxnumber)
                    ->where('paid', 0)
                    // ->whereRaw("MONTH(emission) = ?", $mesAtual)
                    ->get();

                $valorAdiantamento = 0;
                $taxa = 0;
                $valorMensalidadeDevida = 0;
                $saldoDevedor = 0;

                // 3) Em cada limite utilizado, calcula os valores e soma com os valores do limite anterior (acumulador)
                foreach($limites as $lim) {
                    $valorAdiantamento += $lim->requestedvalue + $lim->ratevalue - $lim->paymentvalue;
                    $taxa += $lim->interestvalue;
                    $saldoDevedor += $lim->requestedvalue
                             + $lim->ratevalue
                             - $lim->paymentvalue
                             + $lim->interestvalue;
                    if ($lim->transactiontype == 'MENSALIDADE') $valorMensalidadeDevida += ($lim->paid == '0') ? ($lim->requestedvalue + $lim->ratevalue - $lim->paymentvalue) : 0;
                }

                $dadosClientes[$i] = [
                    'taxnumber' => $cliente->taxnumber,
                    'name' => $cliente->name,
                    'saldoACompensar' => $cliente->availablelimit,
                    'valorAdiantamento' => $valorAdiantamento,
                    'taxa' => $taxa,
                    'valorMensalidadeDevida' => $valorMensalidadeDevida,
                    'saldoDevedor' => $saldoDevedor
                ];

            }
        }

        return view('testes.mensalidade', ['dadosClientes' => json_encode($dadosClientes)]);
    }

    public function lancarMensalidades(Request $request)
    {
        if (Auth::user()->role_id > 1) {
            return redirect('/home')->with('warning', 'Você não tem permissão para acessar essa área.');
        }

        Artisan::call('command:lancarmensalidades');

        return redirect()->route('testes.mensalidades');
        // return view('testes.mensalidades');
    }

    public function pagarMensalidades(Request $request)
    {
        if (Auth::user()->role_id > 1) {
            return redirect('/home')->with('warning', 'Você não tem permissão para acessar essa área.');
        }

        Artisan::call('command:pagarmensalidades');

        return redirect()->route('testes.mensalidades');
        // return view('testes.mensalidades');
    }

    public function buscarSaldoCliente(Request $request)
    {
        echo json_encode(formatMoneyBr(saldoCliente($request->cliente)));
    }

    public function lancarDividas()
    {
        $agora = now();

        // 1) Busca todos os clientes
        $clientes = Client::select('id',
                'name',
                'taxnumber',
                'availablelimit'
            )
            ->where('active', '1');
        $todosClientes = Multisafe::select('client_id as id',
                'nickname as name',
                'taxnumber',
                'availablelimit'
            )
            ->where('active', '1')
            ->union($clientes)->orderBy('name','ASC')->get();

        $arrNovasDividas = [];
        $novaDivida = new Usedavailablelimit();

        foreach($todosClientes as $i => $cliente) {

            $valorAleatorio = rand(0, 100000);
            $valorDivida = ($valorAleatorio < $cliente->availablelimit) ? $valorAleatorio : 100;
            $taxa = consultaTaxaCliente($cliente->id, 'internaltransfer', $valorDivida);

            $arrNovasDividas[] = [
                'user_id' => '1',
                'client_id' => intval($cliente->id),
                'emission' => ($agora->subDays(rand(1, 28))->toDateTimeString()),
                'taxnumber' => strval($cliente->taxnumber),
                'availablelimit' => intval($cliente->availablelimit),
                'requestedvalue' => $valorDivida,
                'ratevalue' => $taxa,
                'daysused' => 0,
                'interestvalue' => 0,
                'paid' => 0,
                'paymentvalue' => 0,
                'transactiontype' => 'TRANSFERENCIA',
                'status' => 'Paid',
            ];

        }

        $novaDivida->insert($arrNovasDividas);

        Artisan::call('command:availablelimitinterestcalculator');

        return redirect()->route('testes.calculo-juros');
    }

    /**
     * Função adaptada da função lancarMensalidades.
     * Executa o comando lancarmensalidades, que realiza o lançamento das mensalidades.
     * @return \Illuminate\Routing\Redirector|\Illuminate\Http\RedirectResponse
     */
    public function lancarTesteMensalidades()
    {
        if (Auth::user()->role_id > 1) {
            return redirect('/home')->with('warning', 'Você não tem permissão para acessar essa área.');
        }

        Artisan::queue('command:lancarmensalidades');

        return redirect()->route('testes.pagamento-unificado');
    }

    /**
     * Esta função calcula os juros das atuais dívidas e retorna na view
     * @return \Illuminate\Routing\Redirector|\Illuminate\Http\RedirectResponse
     */
    public function exibirViewPagamentoUnificado()
    {
        // Chama a rotina de calcular todos os juros
        // Artisan::call('command:availablelimitinterestcalculator');

        // 1) Busca todos os clientes
        $clientes = Client::select('id',
                'name',
                'taxnumber',
                'availablelimit'
            )
            ->where('active', '1');
        $todosClientes = Multisafe::select('client_id as id',
                'nickname as name',
                'taxnumber',
                'availablelimit'
            )
            ->where('active', '1')
            ->union($clientes)->orderBy('name','ASC')->get();

        $dadosClientes = [];

        foreach($todosClientes as $i => $cliente) {

            $limitesUtilizados = Usedavailablelimit::where('taxnumber', $cliente->taxnumber)
                ->where('paid', 0)
                ->get();

            $valorAdiantamento = 0;
            $taxa = 0;
            $saldoDevedor = 0;

            foreach($limitesUtilizados as $lim) {
                $valorAdiantamento += $lim->requestedvalue + $lim->ratevalue - $lim->paymentvalue;
                $taxa += $lim->interestvalue;
                $saldoDevedor += $lim->requestedvalue
                            + $lim->ratevalue
                            - $lim->paymentvalue
                            + $lim->interestvalue;
            }

            $dadosClientes[$i] = [
                'taxnumber' => $cliente->taxnumber,
                'name' => $cliente->name,
                'saldoACompensar' => $cliente->availablelimit,
                'valorAdiantamento' => $valorAdiantamento,
                'taxa' => $taxa,
                'saldoDevedor' => $saldoDevedor,
            ];
        }

        return view('testes.pagamentounificado', ['dadosClientes' => json_encode($dadosClientes)]);
    }

    /**
     * Esta função paga todas as mensalidades
     * @return \Illuminate\Routing\Redirector|\Illuminate\Http\RedirectResponse
     */
    public function pagarTesteMensalidades()
    {
        if (Auth::user()->role_id > 1) {
            return redirect('/home')->with('warning', 'Você não tem permissão para acessar essa área.');
        }

        Artisan::queue('command:pagarmensalidades');

        return redirect()->route('testes.pagamento-unificado');
    }

    /**
     * Esta função paga todos os limites utilizados, sejam eles adiantamento de saldo a compensar ou provisionamento
     * @return \Illuminate\Routing\Redirector|\Illuminate\Http\RedirectResponse
     */
    public function pagarLimitesUtilizados()
    {
        if (Auth::user()->role_id > 1) {
            return redirect('/home')->with('warning', 'Você não tem permissão para acessar essa área.');
        }

        Artisan::queue('command:pagarlimitesutilizados');

        return redirect()->route('testes.pagamento-unificado');
    }

    /**
     * Esta função calcula a taxa de tudo que está pendente em usedavailablelimits
     * @return \Illuminate\Routing\Redirector|\Illuminate\Http\RedirectResponse
     */
    public function calcularTaxasLimitesUtilizados()
    {
        if (Auth::user()->role_id > 1) {
            return redirect('/home')->with('warning', 'Você não tem permissão para acessar essa área.');
        }

        Artisan::queue('command:calculartaxas');

        return redirect()->route('testes.pagamento-unificado');
    }

    /**
     * Esta função cobra a taxa de tudo que está pendente em usedavailablelimits
     * @return \Illuminate\Routing\Redirector|\Illuminate\Http\RedirectResponse
     */
    public function cobrarTaxasLimitesUtilizados()
    {
        if (Auth::user()->role_id > 1) {
            return redirect('/home')->with('warning', 'Você não tem permissão para acessar essa área.');
        }

        Artisan::queue('command:cobrartaxas');

        return redirect()->route('testes.pagamento-unificado');
    }

    /**
     * Esta função roda o comando de efetuar distribuição
     * @return \Illuminate\Routing\Redirector|\Illuminate\Http\RedirectResponse
     */
    public function distribuirValores(Request $request)
    {
        if (Auth::user()->role_id > 1) {
            return redirect('/home')->with('warning', 'Você não tem permissão para acessar essa área.');
        }

        $taxnumber = $request->input('taxnumber_distribuicao');

        $valorASerDistribuido = floatval( str_replace(',', '.', str_replace('.', '', $request->input('valor_distribuicao'))) );

        $bankService = new BankSsgService(new ClientSpsService($taxnumber));

        $bankService->distribuir($valorASerDistribuido);

        return redirect()->route('testes.pagamento-unificado');
    }

    /**
     * Exibe a tela de testes do D+0 automático
     * @return \Illuminate\Routing\Redirector|\Illuminate\Http\RedirectResponse
     */
    public function exibirViewD0Automatico()
    {
        if (Auth::user()->role_id > 1) {
            return redirect('/home')->with('warning', 'Você não tem permissão para acessar essa área.');
        }

        // 1) Busca todos os clientes habilitados
        $clientesHabilitados = Client::select('id',
                'name',
                'taxnumber',
                'd0time',
                'd1time',
                'd0automatic',
                'd1automatic',
                DB::raw("'client' as tipocliente")
            )
            ->where('active', '1')
            ->whereRaw("d0automatic = 1 OR d1automatic = 1");

        $todosClientesHabilitados = Multisafe::select('client_id as id',
                'nickname as name',
                'taxnumber',
                'd0time',
                'd1time',
                'd0automatic',
                'd1automatic',
                DB::raw("'multisafe' as tipocliente")
            )
            ->where('active', '1')
            ->whereRaw("d0automatic = 1 OR d1automatic = 1")
            ->union($clientesHabilitados)->orderBy('name','ASC')->get();

        $dadosClientesD0Habilitados = [];
        $dadosClientesD1Habilitados = [];
        $todosD0Agendamentos = [];
        $todosD1Agendamentos = [];

        // 2) Em cada cliente habilitado, monta-se os dados para a view
        foreach($todosClientesHabilitados as $i => $cliente) {

            // 2.1) Array com dados dos clientes habilitados
            if ($cliente->d0automatic == 1) {
                $dadosClientesD0Habilitados[$i] = [
                    'taxnumber' => $cliente->taxnumber,
                    'name' => $cliente->name,
                    'd0time' => $cliente->d0time,
                ];

                // 2.2) Em cada cliente, busca todos os seus agendamentos
                $todosAgendamentosD0Cliente = Autotransferschedule::select(
                    'autotransferschedule.id as id_agendamento',
                    'autotransferschedule.fromtaxnumber',
                    'autotransferschedule.totaxnumber',
                    'operationtype',
                    'scheduleddatetime',
                    'autotransferschedule.availablelimit',
                    'operationvalue',
                    'operationstatus',
                    'operationresponse',
                    'documentnumber',
                    'accounttype',
                    'bank_id',
                    'autotransferschedule.bankbranch',
                    'autotransferschedule.bankaccountdigit',
                    'autotransferschedule.bankaccount'
                );

                if ($cliente->tipocliente == "multisafe") {
                    $todosAgendamentosD0Cliente = $todosAgendamentosD0Cliente
                    ->join('multisafes', 'multisafes.taxnumber', '=', 'autotransferschedule.fromtaxnumber')
                    ->where('multisafes.active', '=', '1');
                } elseif ($cliente->tipocliente == "client") {
                    $todosAgendamentosD0Cliente = $todosAgendamentosD0Cliente
                    ->join('clients', 'clients.taxnumber', '=', 'autotransferschedule.fromtaxnumber')
                    ->where('clients.active', '=', '1');
                }

                $todosAgendamentosD0Cliente = $todosAgendamentosD0Cliente
                ->where('autotransferschedule.operationtype', '=', 'D+0')
                ->where('autotransferschedule.fromtaxnumber', '=', $cliente->taxnumber)
                ->orderBy('autotransferschedule.created_at', 'ASC')
                ->get();

                $todosD0Agendamentos[$i] = [
                    'taxnumber' => $cliente->taxnumber,
                    'name' => $cliente->name,
                    'todosAgendamentosD0Cliente' => $todosAgendamentosD0Cliente
                ];

            }

            if ($cliente->d1automatic == 1) {
                $dadosClientesD1Habilitados[$i] = [
                    'taxnumber' => $cliente->taxnumber,
                    'name' => $cliente->name,
                    'd1time' => $cliente->d1time,
                ];

                $todosAgendamentosD1Cliente = Autotransferschedule::select(
                    'autotransferschedule.id as id_agendamento',
                    'autotransferschedule.fromtaxnumber',
                    'autotransferschedule.totaxnumber',
                    'operationtype',
                    'scheduleddatetime',
                    'autotransferschedule.availablelimit',
                    'operationvalue',
                    'operationstatus',
                    'operationresponse',
                    'documentnumber',
                    'accounttype',
                    'bank_id',
                    'autotransferschedule.bankbranch',
                    'autotransferschedule.bankaccountdigit',
                    'autotransferschedule.bankaccount'
                );

                if ($cliente->tipocliente == "multisafe") {
                    $todosAgendamentosD1Cliente = $todosAgendamentosD1Cliente
                    ->join('multisafes', 'multisafes.taxnumber', '=', 'autotransferschedule.fromtaxnumber')
                    ->where('multisafes.active', '=', '1');
                } elseif ($cliente->tipocliente == "client") {
                    $todosAgendamentosD1Cliente = $todosAgendamentosD1Cliente
                    ->join('clients', 'clients.taxnumber', '=', 'autotransferschedule.fromtaxnumber')
                    ->where('clients.active', '=', '1');
                }

                $todosAgendamentosD1Cliente = $todosAgendamentosD1Cliente
                ->where('autotransferschedule.operationtype', '=', 'D+1')
                ->where('autotransferschedule.fromtaxnumber', '=', $cliente->taxnumber)
                ->orderBy('autotransferschedule.created_at', 'ASC')
                ->get();

                $todosD1Agendamentos[$i] = [
                    'taxnumber' => $cliente->taxnumber,
                    'name' => $cliente->name,
                    'todosAgendamentosD1Cliente' => $todosAgendamentosD1Cliente
                ];
            }
        }

        return view('testes.d0automatico', [
            'arrayClientesD0Habilitados' => $dadosClientesD0Habilitados,
            'arrayClientesD1Habilitados' => $dadosClientesD1Habilitados,
            'arrayAgendamentosD0' => $todosD0Agendamentos,
            'arrayAgendamentosD1' => $todosD1Agendamentos
        ]);
    }

    /**
     * Esta função roda o comando de agendar d+0 automaticamente
     * @return \Illuminate\Routing\Redirector|\Illuminate\Http\RedirectResponse
     */
    public function agendarD0()
    {
        if (Auth::user()->role_id > 1) {
            return redirect('/home')->with('warning', 'Você não tem permissão para acessar essa área.');
        }

        Artisan::queue('command:agendardxautomatico');

        return redirect()->route('testes.d0automatico')->with('success', 'Rotina executada com sucesso.');
    }

    public function autorizarD0()
    {
        if (Auth::user()->role_id > 1) {
            return redirect('/home')->with('warning', 'Você não tem permissão para acessar essa área.');
        }

        Artisan::queue('command:executardxautomatico');

        return redirect()->route('testes.d0automatico');
    }

    public function cancelarD0(Request $request)
    {
        $id = $request->get('id_agendamento');

        $agendamento = Autotransferschedule::find($id);
        $agendamento->operationstatus = "CANCELADO";
        $agendamento->operationresponse = "[" . datetime2br(date('Y-m-d H:i:s')) . "] Operação cancelada pelo operador " . Auth::user()->id;
        $agendamento->update();

        return redirect()->route('testes.d0automatico');
    }

    /**
     * Só pode desfazer cancelamento se a hora do agendamento não tiver acontecido
     */
    // public function desfazerCancelamentoD0(Request $request)
    // {
    //     $id = $request->get('id_agendamento');

    //     $agendamento = Autotransferschedule::find($id);
    //     $agendamento->operationstatus = "AGENDADO";
    //     $agendamento->operationresponse = NULL;
    //     $agendamento->update();

    //     return redirect()->route('testes.d0automatico');
    // }
}
