<?php namespace App\Http\Controllers;

use App\Transactionlog;

use Illuminate\Http\Request;

class TransactionlogController extends Controller
{

	public function index()
	{

		$transactionlogs = Transactionlog::all();
		$status=(!$transactionlogs)?false:true;
		return response()->json(['status'=>$status,'result' => $transactionlogs]);
	}


	public function store(Request $request)
	{

		$transactionlogs = new Transactionlog($request->all());
		$transactionlogs->save();
		if(!$transactionlogs) { return response()->json(['status'=>false,'result' => 'Houve um problema ao salvar. Por favor tente mais tarde.']);}
		return response()->json(['status'=>true,'result' => $transactionlogs]);
	}


	public function show(Request $request, $id)
	{

		$transactionlogs = Transactionlog::findOrFail($id);
		if(!$transactionlogs) { return response()->json(['status'=>false,'result' => 'Oops! Nada foi encontrado.']); }
		return response()->json(['status'=>true,'result' => $transactionlogs]);
	}


	public function update(Request $request, $id)
	{

		$transactionlogs = Transactionlog::findOrFail($id);
		$transactionlogs->update($request->all());
		if(!$transactionlogs) { return response()->json(['status'=>false,'result' => 'Houve um problema ao atualizar. Por favor tente mais tarde.']);}
		return response()->json(['status'=>true,'result' => $transactionlogs]);
	}


	public function destroy($id)
	{

		$transactionlogs = Transactionlog::findOrFail($id);
		$transactionlogs->delete();
		if(!$transactionlogs) { return response()->json(['status'=>false,'result' => 'Houve um problema ao excluir. Por favor tente mais tarde.']);}
		return response()->json(['status'=>true,'result' => 'O item foi removido com sucesso.']);
	}


}
