<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Gate;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        $resources = \App\Resource::all();

        foreach($resources as $resource) {
            Gate::define($resource->resource, function($user) use ($resource){
                return $resource->roles->contains($user->role);
            });
        }

        //dd(Gate::abilities());
    }
}
