<?php

namespace App\Services;

use App\Classes\ClientSPS\ClientSpsService;
use App\Usedavailablelimit;

class BankSsgService
{
    protected $clientService;
    protected $clientTaxnumber;

    public function __construct(ClientSpsService $clientService)
    {
        $this->clientService = $clientService;
        $this->clientTaxnumber = $this->clientService->__get('taxnumber');
    }

    public function distribuir(float $valorASerDistribuido)
    {
        $limitesUtilizadosNaoPagos = Usedavailablelimit::where('paid', '=', 0)
            ->orderByRaw("FIELD(transactiontype, 'PROVISIONAMENTO', '*') DESC, emission ASC")
            ->whereDate('duedate', '<=', date('Y-m-d', strtotime('+1 days')) . ' 23:59:59')
            ->where('taxnumber', '=', $this->clientTaxnumber)
            ->get();

        foreach($limitesUtilizadosNaoPagos as $objLimite) {

            $subtotal = $objLimite->requestedvalue + $objLimite->ratevalue + $objLimite->interestvalue - $objLimite->paymentvalue;

            if ($valorASerDistribuido >= $subtotal) {
                $valorAPagar = $subtotal;
            } else {
                $valorAPagar = $valorASerDistribuido;
            }

            $retornoPagamento = $this->finalizarPagamentoLimitesUtilizadosNaDistribuicao($objLimite, $valorAPagar, 0);

            if ($retornoPagamento['pagou']) {
                $valorASerDistribuido -= $valorAPagar;
            }

            if ($valorASerDistribuido <= 0) break;
        }

        $distribuicao = $this->transferirClienteParaSsg(
            $valorASerDistribuido,
            'Distribuição de valores coletados',
            0,
            0
        );
    }

    private function finalizarPagamentoLimitesUtilizadosNaDistribuicao($objLimite, $valorPago, $valorProvisionado)
    {
        $objLimite->paymentvalue += $valorProvisionado + $valorPago;
        $objLimite->paymentdate = date('Y-m-d H:i:s');

        $valorTotalLimiteUtilizado = $objLimite->requestedvalue + $objLimite->ratevalue + $objLimite->interestvalue;

        if ($valorTotalLimiteUtilizado <= $objLimite->paymentvalue) $objLimite->paid = 1;

        // TODO: Lógica para caso o update não ocorra
        $objLimite->update();

        return [
            'objLimite' => $objLimite,
            'pagou' => true
        ];
    }

    private function transferirClienteParaSsg($valor, $mensagem = '', $cashbackvalue = 0, $cli_ratevalue = 0) {
        $spsInfo = getSPS();

        $dataAtual = date("Y/m/d");
        $estampa = date("YmdHis");
        $clienteIdentifier = str_pad($this->clientService->clientId, 4, "0", STR_PAD_LEFT);

        $valorATransferir = ( $valor + $cli_ratevalue + $cashbackvalue);

        $curlParams = "{ \"Method\": \"InternalTransfer\",
                    \"PartnerId\": ".$spsInfo->partnerid.",
                    \"BusinessUnitId\": ".$spsInfo->businessunitid.",
                    \"FromTaxNumber\": \"".somenteNumeros($spsInfo->cnpj)."\",
                    \"ToTaxNumber\": \"".somenteNumeros($this->clientTaxnumber)."\",
                    \"Value\": \"".$valorATransferir."\",
                    \"RateValue\": 0,
                    \"TransferDate\": \"".$dataAtual."\",
                    \"Identifier\": \"".$clienteIdentifier . $estampa."\",
                    \"Description\": \"".$mensagem."\",
                    \"CashBackValue\":\"".$cashbackvalue."\"
                }";
        // CashBackValue é o valor cobrado do beneficiário. Deve SEMPRE ser menor que o valor da transferência

        $transfere = sendCurl($curlParams);

        $transactionNumber = (isset($transfere['DocumentNumber']))?$transfere['DocumentNumber']:'0';
        $sucesso = ($transfere["Success"] == "false")?0:1;
        $validacao = (isset($transfere['Validation']))?serialize($transfere['Validation']):'';
        $mensagem = (isset($transfere['Message']))?$transfere['Message']:'';

        $checkSaved = checkDocNumberTransferIn($transactionNumber,'InternalTransfer');

        if(!$checkSaved) saveTransactionLog($this->clientService->clientId,somenteNumeros($this->clientTaxnumber),'InternalTransfer',$curlParams,$sucesso,$mensagem,$validacao,$transactionNumber,$valorATransferir,date('Y-m-d H:i:s'),$cashbackvalue);

        if($transfere["Success"] == "false") {
            $validacao = (isset($transfere['Validation']))?serialize($transfere['Validation']):'';
            $mensagem = (isset($transfere['Message']))?$transfere['Message']:'';

            saveTransferErrorLog('InternalTransfer', $curlParams, $mensagem, $validacao);

            return false;
        }

        // TODO
        // MELHORAR ESSA PARTE DO UPDATE
        if ($this->clientService->__get("hierarquia") == "M") {
            $objCliente = \App\Client::where("taxnumber", "=", $this->clientTaxnumber)->first();
        } else {
            $objCliente = \App\Multisafe::where("taxnumber", "=", $this->clientTaxnumber)->first();
        }

        $objCliente->availablelimit = ( ($objCliente->availablelimit - $valorATransferir) < 0 )
            ? 0
            : ( $objCliente->availablelimit - $valorATransferir );

        $objCliente->update();

        return $transactionNumber;
    }
}
