<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateActionlogsTable extends Migration
{
	public function up()
	{
		Schema::create('actionlogs', function (Blueprint $table)
		{
			$table->integer('user_id')->unsigned()->index();
			$table->integer('client_id')->default('0')->unsigned()->index();
			$table->datetime('actiondate')->nullable();
			$table->string('action',255)->nullable();
			$table->longText('params')->nullable();
			$table->timestamps();
		});
	}



	public function down()
	{
		Schema::dropIfExists('actionlogs');
	}
}
