<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDetailedindividualaccountsTable extends Migration
{
	public function up()
	{
		Schema::create('detailedindividualaccounts', function (Blueprint $table)
		{
			$table->increments('id')->unsigned();
			$table->string('businessunitid',100)->index();
			$table->string('personname',255)->nullable();
			$table->string('motherfullname',255)->nullable()->comment('Cpf/cnpj da empresa');
			$table->string('fatherfullname',255)->nullable();
			$table->string('nationality',255)->nullable()->comment('0 - Para SA (Sociedade Annima), 1 - Para LTDA (Sociedade limitada), 2 para MEI (Micro Empreendedor Individual).');
			$table->string('birthdate',15)->nullable();
			$table->string('birthcity',255)->nullable();
			$table->string('birthstate',255)->nullable();
			$table->string('gender',1)->nullable()->comment('M para masculino e F para feminino.');
			$table->string('maritalstatus',1)->nullable()->comment('0 - Solteiro, 1 - Casado, 2 - Divorciado, 3 - Separado, 4 - Vivo.');
			$table->string('spousename',255)->nullable();
			$table->string('occupation',255)->nullable();
			$table->string('identitydocument',45)->nullable();
			$table->timestamps();
		});
	}



	public function down()
	{
		Schema::dropIfExists('detailedindividualaccounts');
	}
}
