<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDocumentsTable extends Migration
{
	public function up()
	{
		Schema::create('documents', function (Blueprint $table)
		{
			$table->increments('id')->unsigned();
			$table->string('businessunitid',100)->index();
			$table->longText('documentfile')->nullable()->comment('Arquivo serializado em Array de Bytes.');
			$table->string('documentname',255)->nullable();
			$table->string('description',255)->nullable();
			$table->string('documenttype',1)->nullable()->comment('0 - Para RG, 1 - Para CPF, 2 - Para comprovante de residncia.');
			$table->string('documentformat',1)->nullable()->comment('0 para PDF, 1 para JPG, 2 para JPEG, 3 para TXT.');
			$table->timestamps();
		});
	}



	public function down()
	{
		Schema::dropIfExists('documents');
	}
}
