<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ChangeClientsAddBank extends Migration
{
	public function up()
	{
		Schema::table('clients', function (Blueprint $table)
		{
			$table->string('banknumber',255)->default(0)->after('phone');
			$table->string('bankbranch',255)->default(0)->after('banknumber');
			$table->string('bankaccount',255)->default(0)->after('bankbranch');
		});
	}



	public function down()
	{
		Schema::table('clients', function (Blueprint $table)
		{
			$table->dropColumn('banknumber');
			$table->dropColumn('bankbranch');
			$table->dropColumn('bankaccount');
		});
	}
}
