<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTransferlogsTable extends Migration
{
	public function up()
	{
		Schema::create('transferlogs', function (Blueprint $table)
		{
			$table->increments('id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->integer('client_id')->unsigned();
			$table->string('taxnumber',20)->default(0);
			$table->datetime('actiondate');
			$table->string('documento',255)->nullable()->default('');
			$table->string('nome',255)->nullable()->default('');
			$table->string('banco',255)->nullable()->default('');
			$table->string('agencia',255)->nullable()->default('');
			$table->string('conta',255)->nullable()->default('');
			$table->string('digito',255)->nullable()->default('');
			$table->string('tipoconta',255)->nullable()->default('');
			$table->string('valor',255)->nullable()->default('');
			$table->string('ratevalue',255)->nullable()->default('');
			$table->string('identificador',255)->nullable()->default('');
			$table->string('success',1)->default('');
			$table->string('documentnumber',255)->nullable()->default('');
			$table->text('url')->nullable();
			$table->string('alreadyexists',1)->nullable()->default(0);
			$table->string('limiteespecial',1)->default(0);
			$table->string('valorlimiteespecial',60)->default(0);
			$table->timestamps();
		});
	}



	public function down()
	{
		Schema::dropIfExists('transferlogs');
	}
}
