<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ChangeClientsAddAddress extends Migration
{
	public function up()
	{
		Schema::table('clients', function (Blueprint $table)
		{
			$table->string('addressline1',100)->default('')->after('name');
			$table->string('addressline2',100)->default('')->after('addressline1');
			$table->string('neighborhood',100)->default('')->after('addressline2');
			$table->string('city',60)->default('')->after('neighborhood');
			$table->string('state',60)->default('')->after('city');
			$table->string('zipcode',8)->default('')->after('state');
		});
	}



	public function down()
	{
		Schema::table('clients', function (Blueprint $table)
		{
			$table->dropColumn('addressline1');
			$table->dropColumn('addressline2');
			$table->dropColumn('neighborhood');
			$table->dropColumn('city');
			$table->dropColumn('state');
			$table->dropColumn('zipcode');
		});
	}
}
