<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateClientcontactsTable extends Migration
{
	public function up()
	{
		Schema::create('clientcontacts', function (Blueprint $table)
		{
			$table->increments('id')->unsigned();
			$table->integer('client_id');
			$table->string('customername',255)->nullable();
			$table->string('customertaxnumber',255)->nullable();
			$table->string('customermail',255)->nullable();
			$table->string('customerphone',255)->nullable();
			$table->string('addressline1',255)->nullable();
			$table->string('addressline2',255)->nullable();
			$table->string('neighborhood',255)->nullable();
			$table->string('city',255)->nullable();
			$table->string('state',255)->nullable();
			$table->string('zipcode',8)->nullable();
			$table->string('bankcode',15)->nullable();
			$table->string('bank',255)->nullable();
			$table->string('bankbranch',25)->nullable();
			$table->string('bankaccount',25)->nullable();
			$table->string('bankaccountdigito',5)->nullable();
			$table->timestamps();
		});
	}



	public function down()
	{
		Schema::dropIfExists('clientcontacts');
	}
}
