<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class PaymentTablesAdjustments extends Migration
{
    public function up()
    {
        Schema::table('darfpayments', function (Blueprint $table) {
            $table->text('entryid')->nullable()->after('documentnumber');
            $table->string('contributorname',255)->default('')->after('entryid');
            $table->string('paymentprotocol',255)->default('')->after('contributorname');
            $table->longtext('webhookpayload')->nullable()->after('paymentprotocol');
            $table->string('status',100)->default('')->change();
            $table->string('contributortaxnumber',100)->default('')->change();

        });

        Schema::table('darjpayments', function (Blueprint $table) {
            $table->text('entryid')->nullable()->after('documentnumber');
            $table->string('contributorname',255)->default('')->after('entryid');
            $table->string('paymentprotocol',255)->default('')->after('contributorname');
            $table->longtext('webhookpayload')->nullable()->after('paymentprotocol');
            $table->string('status',100)->default('')->change();

        });

        Schema::table('fgtspayments', function (Blueprint $table) {
            $table->text('entryid')->nullable()->after('documentnumber');
            $table->string('contributorname',255)->default('')->after('entryid');
            $table->string('paymentprotocol',255)->default('')->after('contributorname');
            $table->longtext('webhookpayload')->nullable()->after('paymentprotocol');
            $table->string('status',100)->default('')->change();

        });

        Schema::table('garepayments', function (Blueprint $table) {
            $table->text('entryid')->nullable()->after('documentnumber');
            $table->string('contributorname',255)->default('')->after('entryid');
            $table->string('paymentprotocol',255)->default('')->after('contributorname');
            $table->longtext('webhookpayload')->nullable()->after('paymentprotocol');
            $table->string('status',100)->default('')->change();

        });

        Schema::table('gpspayments', function (Blueprint $table) {
            $table->text('entryid')->nullable()->after('documentnumber');
            $table->string('contributorname',255)->default('')->after('entryid');
            $table->string('paymentprotocol',255)->default('')->after('contributorname');
            $table->string('gpsidentifier',255)->default('')->after('paymentprotocol');
            $table->string('duedate',255)->default('')->after('gpsidentifier');
            $table->longtext('webhookpayload')->nullable()->after('duedate');
            $table->string('status',100)->default('')->change();

        });
    

    }


    public function down()
    {
        Schema::table('darfpayments', function (Blueprint $table)
        {
            $table->dropColumn('entryid');
            $table->dropColumn('contributorname');
            $table->dropColumn('paymentprotocol');
            $table->dropColumn('webhookpayload');
        });

        Schema::table('darjpayments', function (Blueprint $table)
        {
            $table->dropColumn('entryid');
            $table->dropColumn('contributorname');
            $table->dropColumn('paymentprotocol');
            $table->dropColumn('webhookpayload');
        });

        Schema::table('fgtspayments', function (Blueprint $table)
        {
            $table->dropColumn('entryid');
            $table->dropColumn('contributorname');
            $table->dropColumn('paymentprotocol');
            $table->dropColumn('webhookpayload');
        });

        Schema::table('garepayments', function (Blueprint $table)
        {
            $table->dropColumn('entryid');
            $table->dropColumn('contributorname');
            $table->dropColumn('paymentprotocol');
            $table->dropColumn('webhookpayload');
        });

        Schema::table('gpspayments', function (Blueprint $table)
        {
            $table->dropColumn('entryid');
            $table->dropColumn('contributorname');
            $table->dropColumn('paymentprotocol');
            $table->dropColumn('gpsidentifier');
            $table->dropColumn('duedate');
            $table->dropColumn('webhookpayload');
        });

        
    }
}
