<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class WebhookAdjustments extends Migration
{
    public function up()
    {
        Schema::table('billets', function (Blueprint $table) {
            $table->string('boletodocumentnumber')->default('')->after('boleto');
            $table->string('status')->default('')->after('boletodocumentnumber');
            $table->string('paymentdate')->default('')->after('status');
            $table->string('bankcode')->default('')->after('paymentdate');
            $table->string('iofvalue')->default('')->after('bankcode');
            $table->string('returncode')->default('')->after('iofvalue');
            $table->string('paidvalue')->default('')->after('returncode');
            $table->string('creditdate')->default('')->after('paidvalue');
            $table->string('occurrencedate')->default('')->after('creditdate');
            $table->string('occurrencemotive')->default('')->after('occurrencedate');
            $table->string('barcode')->default('')->after('occurrencemotive');
            $table->string('digitableline')->default('')->after('barcode');
            $table->string('partnerid')->default('')->after('digitableline');
            $table->string('othervalues')->default('')->after('partnerid');
            $table->string('method')->default('')->after('othervalues');
            $table->string('businessunitid')->default('')->after('method');
            $table->longtext('webhookpayload')->nullable()->after('businessunitid');


        });

        Schema::table('transactionlogs', function (Blueprint $table) {
            // $table->string('status',100)->default('')->change();

            $table->string('moneytransferindocumentnumber',255)->nullable()->after('balance');
            $table->string('name',255)->nullable()->after('moneytransferindocumentnumber');
            $table->string('mail',255)->nullable()->after('name');
            $table->string('phone',255)->nullable()->after('mail');
            $table->string('bankcode',255)->nullable()->after('phone');
            $table->string('bankbranch',255)->nullable()->after('bankcode');
            $table->string('bankaccount',255)->nullable()->after('bankbranch');
            $table->string('ratevalue',255)->nullable()->after('bankaccount');
            $table->string('creditedvalue',255)->nullable()->after('ratevalue');
            $table->string('transferdate',255)->nullable()->after('creditedvalue');
            $table->string('partnerid',255)->nullable()->after('transferdate');
            $table->string('documentnumber',255)->nullable()->after('partnerid');
            $table->string('identifier',255)->nullable()->after('documentnumber');
            $table->string('entryid',255)->nullable()->after('identifier');
            $table->string('totalvalue',255)->nullable()->after('entryid');
            $table->string('paymentdate',255)->nullable()->after('totalvalue');
            $table->string('fineinterest',255)->nullable()->after('paymentdate');
            $table->string('discountvalue',255)->nullable()->after('fineinterest');
            $table->string('iofvalue',255)->nullable()->after('discountvalue');
            $table->string('paidvalue',255)->nullable()->after('iofvalue');
            $table->string('othervalues',255)->nullable()->after('paidvalue');
            $table->string('creditdate',255)->nullable()->after('othervalues');
            $table->string('occurrencedate',255)->nullable()->after('creditdate');
            $table->longtext('webhookpayload')->nullable()->after('occurrencedate');
            $table->string('status',60)->nullable()->after('webhookpayload');
        });
    

    }


    public function down()
    {
        Schema::table('billets', function (Blueprint $table)
        {
            $table->dropColumn('boletodocumentnumber');
            $table->dropColumn('status');
            $table->dropColumn('paymentdate');
            $table->dropColumn('bankcode');
            $table->dropColumn('iofvalue');
            $table->dropColumn('returncode');
            $table->dropColumn('paidvalue');
            $table->dropColumn('creditdate');
            $table->dropColumn('occurrencedate');
            $table->dropColumn('occurrencemotive');
            $table->dropColumn('barcode');
            $table->dropColumn('digitableline');
            $table->dropColumn('partnerid');
            $table->dropColumn('othervalues');
            $table->dropColumn('method');
            $table->dropColumn('businessunitid');
            $table->dropColumn('webhookpayload');
        });

        Schema::table('transactionlogs', function (Blueprint $table)
        {
            $table->dropColumn('moneytransferindocumentnumber');
            $table->dropColumn('name');
            $table->dropColumn('mail');
            $table->dropColumn('phone');
            $table->dropColumn('bankcode');
            $table->dropColumn('bankbranch');
            $table->dropColumn('bankaccount');
            $table->dropColumn('ratevalue');
            $table->dropColumn('creditedvalue');
            $table->dropColumn('transferdate');
            $table->dropColumn('partnerid');
            $table->dropColumn('documentnumber');
            $table->dropColumn('identifier');
            $table->dropColumn('entryid');
            $table->dropColumn('totalvalue');
            $table->dropColumn('paymentdate');
            $table->dropColumn('fineinterest');
            $table->dropColumn('discountvalue');
            $table->dropColumn('iofvalue');
            $table->dropColumn('paidvalue');
            $table->dropColumn('othervalues');
            $table->dropColumn('creditdate');
            $table->dropColumn('occurrencedate');
            $table->dropColumn('webhookpayload');
            $table->dropColumn('status');
        });

        
        
    }
}
