<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBarcodepaymentsTable extends Migration
{
    public function up()
    {
        Schema::create('barcodepayments', function (Blueprint $table)
        {
            $table->increments('id')->unsigned();
            $table->string('partnerid',255)->nullable();
            $table->string('businessunitid',255)->nullable();
            $table->integer('user_id');
            $table->integer('client_id');
            $table->string('taxnumber',20)->default(0);
            $table->datetime('emission')->nullable();

            $table->string('name',255)->nullable();
            $table->string('beneficiarytaxnumber',255)->nullable();
            $table->string('beneficiaryname',255)->nullable();
            $table->string('guarantortaxnumber',255)->nullable();
            $table->string('guarantorname',255)->nullable();
            $table->string('payertaxnumber',255)->nullable();
            $table->string('payername',255)->nullable();
            $table->string('mailtosend',255)->nullable();
            $table->string('phonetosend',255)->nullable();
            $table->string('barcode',255)->nullable();
            $table->float('principalvalue')->default(0);
            $table->float('discountvalue')->default(0);
            $table->float('extravalue')->default(0);
            $table->string('paymentdate',255)->nullable();
            $table->string('duedate',255)->nullable();
            $table->string('feepayertaxnumber',255)->nullable();
            $table->string('feepayerfullname',255)->nullable();
            $table->string('feepayermail',255)->nullable();
            $table->string('feepayerphone',255)->nullable();
            $table->string('feepayerbank',255)->nullable();
            $table->string('feepayerbankbranch',255)->nullable();
            $table->string('feepayerbankaccount',255)->nullable();
            $table->string('feepayerbankaccountdigit',255)->nullable();
            $table->string('description',255)->nullable();
            $table->string('identifier',255)->nullable();
            $table->string('ratevaluetype',255)->nullable();
            $table->string('ratevalue',255)->nullable();

            $table->string('drawer',255)->nullable();
            $table->string('taxnumberbeneficiary',255)->nullable();
            $table->string('taxnumberdrawee',255)->nullable();
            $table->string('datedueregistration',255)->nullable();
            $table->string('draweename',255)->nullable();
            $table->string('maxpaymentvalue',255)->nullable();
            $table->string('minpaymentvalue',255)->nullable();
            $table->string('nominalvalue',255)->nullable();
            $table->string('updatedvalue',255)->nullable();
            $table->string('totalrebatevalue',255)->nullable();
            $table->string('totaladdedvalue',255)->nullable();
            $table->string('settlementdate',255)->nullable();
            $table->string('nextsettlement',255)->nullable();
            $table->string('digitableline',255)->nullable();
            $table->string('value',255)->nullable();
            $table->string('maxvalue',255)->nullable();
            $table->string('minvalue',255)->nullable();
            $table->string('paymentwasmade',255)->nullable();

            $table->string('documentnumber',255)->nullable();
            $table->string('entryid',255)->nullable();
            $table->string('interestvalue',255)->nullable();
            $table->string('finevalue',255)->nullable();
            $table->string('totalvalue',255)->nullable();
            $table->string('status',255)->nullable();
            $table->string('bankconcessionarefavored',255)->nullable();
            $table->string('occurrencedate',255)->nullable();
            $table->string('returncode',255)->nullable();
            $table->string('receipturl',255)->nullable();
            $table->string('paymentauthentication',255)->nullable();
            $table->string('paymentprotocol',255)->nullable();
            $table->string('paymentsubtype',255)->nullable();
            $table->string('sendernamebank',255)->nullable();
            $table->string('sendercodebank',255)->nullable();
            $table->string('senderbranch',255)->nullable();
            $table->string('senderaccount',255)->nullable();
            $table->string('senderaccountdigit',255)->nullable();
            
            $table->string('cip',1)->default('0');
            $table->string('alreadyexists',5)->default('0');


            $table->longtext('datasent')->nullable();
            $table->longtext('webhookpayload')->nullable();
            $table->timestamps();
        });
    }



    public function down()
    {
        Schema::dropIfExists('barcodepayments');        
    }
}


/*
\"Drawer\":\"BANCO ITAU S.A.\",
\"TaxNumberBeneficiary\":\"21.568.259/0001-00\",
\"TaxNumberDrawee\":\"96.906.497/0001-00\",
\"PaymentDate\":\"2030-05-10T00:00:00\",
\"DateDueRegistration\":\"2020-05-10T00:00:00\",
\"BeneficiaryName\":\"BENEFICIARIO AMBIENTE HOMOLOGACAO\",
\"DraweeName\":\"PAGADOR AMBIENTE HOMOLOGACAO\",
\"DiscountValue\":0.0,
\"InterestValue\":0.0,
\"MaxPaymentValue\":1004.98,
\"MinPaymentValue\":909.26,
\"FineValue\":18.77,
\"NominalValue\":938.35,
\"UpdatedValue\":957.12,
\"TotalRebateValue\":0.0,
\"TotalAddedValue\":18.77,
\"SettlementDate\":null,
\"DueDate\":\"2020-05-10T00:00:00Z\",
\"NextSettlement\":true,
\"DigitableLine\":\"34191097353832604615870388000005182510000093835\",
\"Value\":957.12,
\"MaxValue\":null,
\"MinValue\":null,
\"PaymentWasMade\":false}
*/