<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class PaymentsNullableFields extends Migration
{
    public function up()
    {


        Schema::table('darfpayments', function (Blueprint $table) {
            $table->float('principalvalue')->default(0)->nullable()->change();
            $table->float('finevalue')->default(0)->nullable()->change();
            $table->float('interestvalue')->default(0)->nullable()->change();
            $table->float('totalvalue')->default(0)->nullable()->change();
            $table->string('ratevaluetype',60)->default('')->nullable()->change();
            $table->string('contributorname',255)->default('')->nullable()->change();
            $table->string('paymentprotocol',255)->default('')->nullable()->change();
            $table->string('wasauthorized',1)->default('0')->nullable()->change();
            $table->float('valueinterestcharges')->default(0)->nullable()->change();
            $table->float('valuerecipegrossaccumulated')->default(0)->nullable()->change();
            $table->float('percentagerecipegrossaccumulated')->default(0)->nullable()->change();
            $table->longtext('webhookpayload')->nullable()->change();
            $table->string('status',100)->default('')->nullable()->change();
        });

        Schema::table('gpspayments', function (Blueprint $table) {
            $table->float('principalvalue')->default(0)->nullable()->change();
            $table->float('fineinterestvalue')->default(0)->nullable()->change();
            $table->float('othervalues')->default(0)->nullable()->change();
            $table->float('ratevalue')->default(0)->nullable()->change();
            $table->float('interestvalue')->default(0)->nullable()->change();
            $table->float('totalvalue')->default(0)->nullable()->change();
            $table->string('wasauthorized',1)->default('0')->nullable()->change();
            $table->string('paymentdate',60)->default('')->nullable()->change();
            $table->string('paymentdate2',60)->default('')->nullable()->change();
            $table->string('contributorname',255)->default('')->nullable()->change();
            $table->string('paymentprotocol',255)->default('')->nullable()->change();
            $table->string('gpsidentifier',255)->default('')->nullable()->change();
            $table->string('duedate',255)->default('')->nullable()->change();
            $table->longtext('webhookpayload')->nullable()->change();
            $table->string('status',100)->default('')->nullable()->change();

        });


    }


    public function down()
    {
               
    }
}
