<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddTaxinfos extends Migration
{
    public function up()
    {
        Schema::create('spsbanks', function (Blueprint $table)
        {
            $table->increments('id')->unsigned();
            $table->integer('spsinfo_id');
            $table->integer('user_id');
            $table->string('nickname',100);
            $table->string('bankname',100);
            $table->string('bankcode',10)->nullable();
            $table->string('bankbranch',10)->nullable();
            $table->string('bankaccount',10)->nullable();
            $table->string('bankaccountdigit',10)->nullable();
            $table->float('billpayments')->default(0);
            $table->float('transfers')->default(0);
            $table->float('billets')->default(0);
            $table->timestamps();
        });

        Schema::table('spsinfos', function (Blueprint $table) {
            // $table->string('chargebypercentage',1)->default('1')->comment('Cobrar percentual ou taxa fixa');

             $table->float('fitbankpayments')->default(0)->after('businessunitid');
            $table->string('fitbankpaymentspercentage',1)->default('1')->comment('Cobrar percentual ou taxa fixa')->after('fitbankpayments');
             $table->float('fitbanktransfers')->default(0)->after('fitbankpaymentspercentage');
            $table->string('fitbanktransferspercentage',1)->default('1')->comment('Cobrar percentual ou taxa fixa')->after('fitbanktransfers');
             $table->float('fitbankbillets')->default(0)->after('fitbanktransferspercentage');
            $table->string('fitbankbilletspercentage',1)->default('1')->comment('Cobrar percentual ou taxa fixa')->after('fitbankbillets');
             $table->float('fitbankp2p')->default(0)->after('fitbankbilletspercentage');
            $table->string('fitbankp2ppercentage',1)->default('1')->comment('Cobrar percentual ou taxa fixa')->after('fitbankp2p');
             $table->float('clientpayments')->default(0)->after('fitbankp2ppercentage');
            $table->string('clientpaymentspercentage',1)->default('1')->comment('Cobrar percentual ou taxa fixa')->after('clientpayments');
             $table->float('clienttransfers')->default(0)->after('clientpaymentspercentage');
            $table->string('clienttransferspercentage',1)->default('1')->comment('Cobrar percentual ou taxa fixa')->after('clienttransfers');
             $table->float('clientbillets')->default(0)->after('clienttransferspercentage');
            $table->string('clientbilletspercentage',1)->default('1')->comment('Cobrar percentual ou taxa fixa')->after('clientbillets');
             $table->float('clientp2p')->default(0)->after('clientbilletspercentage');
            $table->string('clientp2ppercentage',1)->default('1')->comment('Cobrar percentual ou taxa fixa')->after('clientp2p');
             $table->float('clientbalanceusage')->default(0)->comment('Utilização de saldo disponivel')->after('clientp2ppercentage');
            $table->string('clientbalanceusagepercentage',1)->default('1')->comment('Cobrar percentual ou taxa fixa')->after('clientbalanceusage');
            $table->string('clientbalanceusagedailycharge',1)->default('0')->comment('cobrança diária')->after('clientbalanceusagepercentage');
            
            $table->string('paymentstimelimit',8)->default('16:00:00')->after('clientbalanceusagedailycharge')->comment('horario limite para pagamentos');
            $table->string('transferstimelimit',8)->default('16:00:00')->after('paymentstimelimit')->comment('horario limite para transferencias');
            $table->string('billetstimelimit',8)->default('23:59:59')->after('transferstimelimit')->comment('horario limite geração de boletos');
        });

        if (Schema::hasColumn('spsinfos', 'banknumber')) { Schema::table('spsinfos', function (Blueprint $table) { $table->dropColumn('banknumber'); }); }
        if (Schema::hasColumn('spsinfos', 'bankbranch')) { Schema::table('spsinfos', function (Blueprint $table) { $table->dropColumn('bankbranch'); }); }
        if (Schema::hasColumn('spsinfos', 'bankaccount')) { Schema::table('spsinfos', function (Blueprint $table) { $table->dropColumn('bankaccount'); }); }
        if (Schema::hasColumn('spsinfos', 'ratevalue')) { Schema::table('spsinfos', function (Blueprint $table) { $table->dropColumn('ratevalue'); }); }
        if (Schema::hasColumn('spsinfos', 'ratevalueted')) { Schema::table('spsinfos', function (Blueprint $table) { $table->dropColumn('ratevalueted'); }); }
        if (Schema::hasColumn('spsinfos', 'ratevaluelimit')) { Schema::table('spsinfos', function (Blueprint $table) { $table->dropColumn('ratevaluelimit'); }); }
        if (Schema::hasColumn('spsinfos', 'dailyinterest')) { Schema::table('spsinfos', function (Blueprint $table) { $table->dropColumn('dailyinterest'); }); }
        if (Schema::hasColumn('spsinfos', 'dailyinterestvalue')) { Schema::table('spsinfos', function (Blueprint $table) { $table->dropColumn('dailyinterestvalue'); }); }
        if (Schema::hasColumn('spsinfos', 'dailyinterestpercentage')) { Schema::table('spsinfos', function (Blueprint $table) { $table->dropColumn('dailyinterestpercentage'); }); }

        Schema::table('clients', function (Blueprint $table) {
             $table->float('payments')->default(0)->after('zipcode');
            $table->string('paymentspercentage',1)->default('1')->comment('Cobrar percentual ou taxa fixa')->after('payments');
             $table->float('transfers')->default(0)->after('paymentspercentage');
            $table->string('transferspercentage',1)->default('1')->comment('Cobrar percentual ou taxa fixa')->after('transfers');
             $table->float('billets')->default(0)->after('transferspercentage');
            $table->string('billetspercentage',1)->default('1')->comment('Cobrar percentual ou taxa fixa')->after('billets');
             $table->float('p2p')->default(0)->after('billetspercentage');
            $table->string('p2ppercentage',1)->default('1')->comment('Cobrar percentual ou taxa fixa')->after('p2p');
             $table->float('balanceusage')->default(0)->comment('Utilização de saldo disponivel')->after('p2ppercentage');
            $table->string('balanceusagepercentage',1)->default('1')->comment('Cobrar percentual ou taxa fixa')->after('balanceusage');
           $table->float('monthlyfee')->default(0)->comment('valor mensalidade')->after('balanceusagepercentage');
           $table->float('monthlyfeeautodebit')->default(0)->comment('debito automatico valor mensalidade')->after('monthlyfee');
           $table->string('monthlyfeedueday',2)->default('05')->comment('dia do vencimento da mensalidade')->after('monthlyfeeautodebit');

           $table->string('bankaccountdigit',100)->nullable()->after('bankaccount');
           $table->string('banknumber',100)->nullable()->change();
           $table->string('bankbranch',100)->nullable()->change();
           $table->string('bankaccount',100)->nullable()->change();
        });

        if (Schema::hasColumn('clients', 'ratevalue')) { Schema::table('clients', function (Blueprint $table) { $table->dropColumn('ratevalue'); }); }
        if (Schema::hasColumn('clients', 'ratevalueted')) { Schema::table('clients', function (Blueprint $table) { $table->dropColumn('ratevalueted'); }); }
        if (Schema::hasColumn('clients', 'ratevaluelimit')) { Schema::table('clients', function (Blueprint $table) { $table->dropColumn('ratevaluelimit'); }); }
        if (Schema::hasColumn('clients', 'dailyinterest')) { Schema::table('clients', function (Blueprint $table) { $table->dropColumn('dailyinterest'); }); }
        if (Schema::hasColumn('clients', 'dailyinterestvalue')) { Schema::table('clients', function (Blueprint $table) { $table->dropColumn('dailyinterestvalue'); }); }
        if (Schema::hasColumn('clients', 'dailyinterestpercentage')) { Schema::table('clients', function (Blueprint $table) { $table->dropColumn('dailyinterestpercentage'); }); }




        Schema::create('monthlyfeepayments', function (Blueprint $table)
        {
            $table->increments('id')->unsigned();
            $table->integer('client_id');
            $table->float('value')->default(0);
            $table->float('discount')->default(0);
            $table->datetime('launchdate')->comment('data em que foi lançado o débito');
            $table->datetime('duedate')->nullable();
            $table->datetime('paymentdate')->nullable();
            $table->string('documentnumber',100);
            $table->string('status',1)->default('0');
            $table->string('details',255)->nullable()->comment('obs em caso de desconto ou alteração de data etc');
            $table->integer('user_id')->nullable()->comment('preencher em caso de alteração manual. Indicar o usuário que alterou');
            $table->timestamps();
        });

        Schema::create('manuallyaddedbalances', function (Blueprint $table)
        {
            $table->increments('id')->unsigned();
            $table->integer('user_id');
            $table->integer('client_id');
            $table->float('presentvalue')->default(0)->comment('valor atual no saldo disponivel');
            $table->float('addedvalue')->default(0)->comment('valor adicionado');
            $table->float('newvalue')->default(0)->comment('valor final');
            $table->datetime('dateadded')->comment('data em que foi alterado');
            $table->string('details',255)->comment('justificativa');
            $table->timestamps();
        });

        
    }


    public function down()
    {
        Schema::dropIfExists('spsbanks');
        Schema::dropIfExists('monthlyfeepayments');
        Schema::dropIfExists('manuallyaddedbalances');

        Schema::table('spsinfos', function (Blueprint $table) {
            $table->dropColumn('fitbankpayments');
            $table->dropColumn('fitbankpaymentspercentage');
            $table->dropColumn('fitbanktransfers');
            $table->dropColumn('fitbanktransferspercentage');
            $table->dropColumn('fitbankbillets');
            $table->dropColumn('fitbankbilletspercentage');
            $table->dropColumn('fitbankp2p');
            $table->dropColumn('fitbankp2ppercentage');
            $table->dropColumn('clientpayments');
            $table->dropColumn('clientpaymentspercentage');
            $table->dropColumn('clienttransfers');
            $table->dropColumn('clienttransferspercentage');
            $table->dropColumn('clientbillets');
            $table->dropColumn('clientbilletspercentage');
            $table->dropColumn('clientp2p');
            $table->dropColumn('clientp2ppercentage');
            $table->dropColumn('clientbalanceusage');
            $table->dropColumn('clientbalanceusagepercentage');
            $table->dropColumn('clientbalanceusagedailycharge');
            $table->dropColumn('paymentstimelimit');
            $table->dropColumn('transferstimelimit');
            $table->dropColumn('billetstimelimit');
        });

        Schema::table('clients', function (Blueprint $table) {

            $table->dropColumn('payments');            
            $table->dropColumn('paymentspercentage');            
            $table->dropColumn('transfers');            
            $table->dropColumn('transferspercentage');            
            $table->dropColumn('billets');            
            $table->dropColumn('billetspercentage');            
            $table->dropColumn('p2p');            
            $table->dropColumn('p2ppercentage');            
            $table->dropColumn('balanceusage');            
            $table->dropColumn('balanceusagepercentage');            
            $table->dropColumn('monthlyfee');            
            $table->dropColumn('monthlyfeeautodebit');
            $table->dropColumn('monthlyfeedueday');

            $table->dropColumn('bankaccountdigit');            
        });

        
    }
}
