<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMultisafesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('multisafes', function (Blueprint $table) {
            $table->id();
            $table->integer('client_id')->index();
            $table->string('maintaxnumber',45)->comment('Cpf/cnpj');
            $table->string('taxnumber',45)->comment('Cpf/cnpj');
            $table->string('active',1)->default(1);
            $table->string('businessunitid',60);
            $table->string('mail',60)->nullable();
            $table->string('phone',30)->nullable();
            $table->string('nickname',100)->nullable();
            $table->float('availablelimit')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('multisafes');
    }
}
