<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateApplicationlogsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('applicationlogs', function (Blueprint $table) {
            $table->increments('id')->unsigned();

            $table->integer('user_id')->unsigned();
            $table->integer('role_id')->unsigned();
            $table->integer('client_id')->unsigned();
            $table->string('taxnumber',20)->default(0);
            $table->string('sessionid',100)->default(0);
            $table->longText('sessionjson')->nullable();

            $table->integer('loglevel')->unsigned()->default(0);
            $table->string('action',200)->nullable();
            $table->longText('message')->nullable();
            $table->boolean('success')->nullable();
            $table->longText('datajson')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('applicationlogs');
    }
}
