<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class SmartsafetransferAddFieldSmartqueueid extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('smartsafetransfers', function (Blueprint $table) {
            $table->integer('smart_queue_id')->default(NULL)->unsigned()->nullable()->unique()->after('value');
            $table->float('availablelimit')->default(0)->after('smart_queue_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('smartsafetransfers', function (Blueprint $table) {
            $table->dropColumn('availablelimit');
            $table->dropColumn('smart_queue_id');
        });
    }
}
