<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AutotransferscheduleCreateTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('autotransferschedule', function (Blueprint $table) {
            $table->increments('id')->unsigned();
            $table->string("fromtaxnumber", 20)->default(0)->index();
            $table->string('totaxnumber', 20)->default(0);
            $table->string('operationtype')->comment("Tipo da operacao");
            $table->datetime('scheduleddatetime')->comment("Horario agendado para a operacao acontecer");
            $table->float('availablelimit')->nullable()->comment("Saldo A Compensar disponível no momento da operação");
            $table->float('operationvalue')->nullable()->comment("Valor que foi movimentado na operacao");
            $table->string('operationstatus')->default('SCHEDULED')->comment("Status da operacao.");
            $table->longText('operationresponse')->nullable()->comment("Retorno da operacao");
            $table->string('documentnumber')->nullable();
            $table->string('accounttype');
            $table->integer('bank_id')->index();
            $table->string('bankbranch');
            $table->string('bankaccountdigit');
            $table->string('bankaccount');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *d
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('autotransferschedule');
    }
}
