<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AutotransferreceiverCreateTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('autotransferreceiver', function (Blueprint $table) {
            $table->increments('id')->unsigned();
            $table->string("fromtaxnumber", 20)->default(0)->index();
            $table->string('totaxnumber', 20)->default(0);
            $table->string('identifier');
            $table->string('accounttype');
            $table->integer('bank_id')->index();
            $table->string('bankbranch');
            $table->string('bankaccountdigit');
            $table->string('bankaccount');
            $table->string('operationtype');
            $table->timestamps();

            $table->unique(['fromtaxnumber', 'operationtype']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('autotransferreceiver');
    }
}
