<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class Logerrorautotransferschedule extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('log_error_autotransferschedule', function (Blueprint $table) {
            $table->increments('id')->unsigned();
            $table->string("fromtaxnumber", 20)->default(0)->index();
            $table->string('operationtype')->nullable()->comment("Tipo da operacao");
            $table->longText("message");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('log_error_autotransferschedule');
    }
}
