<?php

use Illuminate\Database\Seeder;
use Illuminate\Database\Eloquent\Model;

use App\User;
use App\Role;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        // $this->call(UsersTableSeeder::class);
        Model::unguard();

        DB::table('roles')->truncate();

        /********************** Roles *************************************/
        $roles = [
            ['id'=>1, 'role'=>'Master'],
            ['id'=>2, 'role'=>'Cliente']
        ];

        foreach($roles as $role) {
            Role::create($role);
        }

        /********************** Users *************************************/
        $users = [
            ['name'=>'Master Admin', 'password'=>bcrypt('masterSps'), 'email'=>'master@teste.com', 'role_id'=>1],
            ['name'=>'Teste',        'password'=>bcrypt('testeSps'),  'email'=>'teste@teste.com',  'role_id'=>2]
        ];

        foreach($users as $user) {
            User::create($user);
        }




        Model::reguard();
    }
}
