@extends('layouts.authenticated')

@section('title')
 // Titulo da seção
@endsection

@section('panel_title')
// Titulo do painel, se houver
@endsection

@section('content')
<div class="container">
    <div class="row justify-content-md-center">
        <div class="col-12">
            <div class="card">
            <div class="card-body">
                <div class="row">Procurar</div>
                <form class="form form-horizontal" method="POST">
                    @csrf
                    <div class="row">
                        <div class="col-md-8">
                            <input type='text' id="nomecontato" name="nomecontato" class="form-control" placeholder="Nome" value="" />
                        </div>
                        <div class="col-md-3">
                            <div class="btn-group" role="group" aria-label="Basic example">
                                <button type="submit" class="btn btn-primary waves-effect waves-light">Buscar</button>
                                <button type="button" class="btn btn-outline-warning waves-effect waves-light" onclick="submitForm()">Limpar</button>
                            </div>
                        </div>

                        
                    </div>
                </form>
            </div>
            </div>
        </div>
    </div>

    <div class="row justify-content-md-center">
        <div class="col-12">
        	<div class="card">
        		<div class="card-header">
                    <div class="col-12 text-right">
                        <a href="{{ url('/contatos/cliente/criar') }}">
                            <button type="button" class="btn btn-md btn-icon btn-success waves-effect waves-light"><i class="feather icon-user-plus"></i></button>
                        </a>
                    </div>
                    
                </div>
        		<div class="card-content">
        			<div class="card-body">

                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th class="text-center">
                                            Nome
                                        </th>
                                        <th class="text-center">
                                            Email
                                        </th>
                                        <th class="text-center">
                                            Telefone
                                        </th>
                                        <th class="text-center">
                                            Opções
                                        </th>
                                        <th class="text-center">
                                            Ações
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>

                                @foreach($contacts as $cli)
                                    <tr>
                                        <th class="text-nowrap" scope="row">{{ $cli->customername }}</th>
                                        <td class="text-nowrap text-center">{{ $cli->customeremail }}</td>
                                        <td class="text-nowrap text-center">{{ $cli->customerphone }}</td>
                                        <td class="text-center">

                                            <button type="button" class="btn btn-icon btn-sm btn-outline-info waves-effect waves-light" onclick="submitOption('boleto',{{ $cli->id }})">
                                                <i class="feather icon-file-text"></i></button>

                                            <button type="button" class="btn btn-icon btn-sm btn-outline-primary waves-effect waves-light" onclick="submitOption('transferencia',{{ $cli->id }})">
                                                <i class="feather icon-repeat"></i></button>

                                            <form action="{{ url('/clientes/boletos/contato') }}" method="POST" id="boleto{{ $cli->id }}">
                                                @csrf
                                                <input type="hidden" name="idcontato" value="{{ $cli->id }}">
                                                
                                            </form>

                                            <form action="{{ url('/transferencias/contato') }}" method="POST"  id="transferencia{{ $cli->id }}">
                                                @csrf
                                                <input type="hidden" name="idcontato" value="{{ $cli->id }}">
                                                
                                            </form>
                                        </td>
                                        <td class="text-center">
                                            <a href="#" data-toggle="modal" data-target="#editar-{{ $cli->id }}">
                                              <i class="feather icon-edit text-primary"></i>
                                            </a>
                                            &nbsp;&nbsp;&nbsp;
                                            <a href="#" data-toggle="modal" data-target="#status-{{ $cli->id }}">
                                              <i class="feather text-danger icon-user-x"></i>
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach

                                </tbody>
                            </table>
                        </div>

                        
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<form class="form form-horizontal" method="POST" id="contatoLimpar">
    @csrf
    <input type='hidden' id="nomecontato" name="nomecontato" value="" />
</form>
@endsection

@section('inlinejs')
    <script type="text/javascript">
        function submitForm() {
            $('#contatoLimpar').submit();
        }

        function submitOption(opt,optid) {
            $('#'+opt+optid).submit();
        }

        
    </script>
@endsection
