@extends('layouts.authenticated')

@section('extrajs')
    <script src="{{ asset('js/jquery.mask.min.js') }}"></script>
@endsection


@section('content')
<div class="container">
    <div class="row justify-content-md-center">
        <div class="col-md-8 col-12">
        	<div class="card">
        		<div class="card-header">
                    <h4>Novo contato</h4>                    
                </div>
        		<div class="card-content">
        			<div class="card-body">

                        <form name="criarcontato" action="{{ url('/contatos/cliente/criar') }}" method="POST" onsubmit="return validaForm()">
                            @csrf
                        <div class="modal-body">
                            
                            <label>Nome: &nbsp;&nbsp;<span class="badge badge-square badge-danger"><span>Obrigatório</span></span></label>
                            <div class="form-group">
                                <input type="text" name="customername" id="customername" placeholder="Nome" class="form-control">
                            </div>

                            <label>CPF/CNPJ: &nbsp;&nbsp;<span class="badge badge-square badge-danger"><span>Obrigatório</span></span></label>
                            <div class="form-group">
                                <input type="text" name="customertaxnumber" id="customertaxnumber" placeholder="Documento" class="form-control">
                            </div>

                            <label>Email: &nbsp;&nbsp;<span class="badge badge-square badge-danger"><span>Obrigatório</span></span></label>
                            <div class="form-group">
                                <input type="text" name="customermail" id="customermail" placeholder="Email" class="form-control">
                            </div>

                            <label>Telefone: &nbsp;&nbsp;<span class="badge badge-square badge-danger"><span>Obrigatório</span></span></label>
                            <div class="form-group">
                                <input type="text" name="customerphone" id="customerphone" placeholder="Telefone" class="form-control">
                            </div>

                            <label>Endereço: </label>
                            <div class="form-group">
                                <input type="text" name="addressline1" id="addressline1" placeholder="Endereço" class="form-control">
                            </div>

                            <label>Complemento: </label>
                            <div class="form-group">
                                <input type="text" name="addressline2" id="addressline2" placeholder="Complemento" class="form-control">
                            </div>

                            <label>Bairro: </label>
                            <div class="form-group">
                                <input type="text" name="neighborhood" id="neighborhood" placeholder="Bairro" class="form-control">
                            </div>

                            <label>Cidade: </label>
                            <div class="form-group">
                                <input type="text" name="city" id="city" placeholder="Cidade" class="form-control">
                            </div>

                            <label>Estado: </label>
                            <div class="form-group">
                                <input type="text" name="state" id="state" placeholder="Estado" class="form-control">
                            </div>

                            <label>CEP: </label>
                            <div class="form-group">
                                <input type="text" name="zipcode" id="zipcode" placeholder="CEP" class="form-control">
                            </div>

                            <label>Código do banco: </label>
                            <div class="form-group">
                                <input type="text" name="bankcode" id="bankcode" placeholder="Código do banco" class="form-control">
                            </div>

                            <label>Banco: </label>
                            <div class="form-group">
                                <input type="text" name="bank" id="bank" placeholder="" class="form-control">
                            </div>

                            <label>Agência: </label>
                            <div class="form-group">
                                <input type="text" name="bankbranch" id="bankbranch" placeholder="Agência" class="form-control">
                            </div>

                            <label>Conta: </label>
                            <div class="form-group">
                                <input type="text" name="bankaccount" id="bankaccount" placeholder="Conta" class="form-control">
                            </div>

                            <label>Dígito: </label>
                            <div class="form-group">
                                <input type="text" name="bankaccountdigito" id="bankaccountdigito" placeholder="" class="form-control">
                            </div>

                            
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-primary waves-effect waves-light" data-dismiss="modal">Fechar</button>
                            <button type="submit" class="btn btn-primary waves-effect waves-light">Salvar</button>
                        </div>
                    </form>

					</div>
				</div>
			</div>
		</div>
	</div>
</div>

@endsection

@section('inlinejs')
    <script type="text/javascript">
        function validaForm() {
           
            if( 
                $("#customername").val() =='' || 
                $("#customertaxnumber").val() =='' || 
                $("#customermail").val() =='' || 
                $("#customerphone").val() ==''
                ) {
                alert('Verifique os campos obrigatórios');
                return false;
            }

            if (/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/.test(criarcontato.customermail.value)) {
            } else {    
                alert('Verifique o email informado');
                return false;
            }
            
            return true;
        }

        var options = {
            onKeyPress: function (cpf, ev, el, op) {
                var masks = ['000.000.000-000', '00.000.000/0000-00'];
                $('#customertaxnumber').mask((cpf.length > 14) ? masks[1] : masks[0], op);
            }
        }

        $('#customertaxnumber').length > 11 ? $('#customertaxnumber').mask('00.000.000/0000-00', options) : $('#customertaxnumber').mask('000.000.000-00#', options);

        $('#customerphone').mask('#');
        $('#zipcode').mask('#');
        $('#bankcode').mask('#');
        $('#bankbranch').mask('#');
        $('#bankaccount').mask('#');
        $('#bankaccountdigito').mask('#');
    </script>
@endsection
