@extends('layouts.authenticated')

@section('extracss')
    <link rel="stylesheet" href="{{ asset('css/vendors/css/pickers/pickadate/pickadate.css') }}">
@endsection

@section('extrajs')
    <script src="{{ asset('js/jquery.mask.min.js') }}"></script>
    <script src="{{ asset('js/jquery.maskMoney.min.js') }}"></script>

    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.js') }}"></script>
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.date.js') }}"></script>
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.time.js') }}"></script>
    <script src="{{ asset('js/js/scripts/pickers/dateTime/pick-a-datetime.js') }}"></script>
@endsection

@section('content')
<div class="container">
	<div class="row justify-content-md-center">
        <div class="col-md-8 col-12">
        	
        	<div class="card">
        		<div class="card-header">
                    <h4 class="card-title"></h4>
                </div>
        		<div class="card-content">
        			<div class="card-body">

        				<h2>Detalhes do boleto</h2>
                        <form action="/pagamentos/boletos/pagar" method="POST">
                            @csrf
                            <input type="hidden" name="cip" value="0">
                            <input type="hidden" name="barcode" value="{{ $boleto->Barcode }}">
                            <input type="hidden" name="digitableline" value="{{ $boleto->DigitableLine }}">
                            <input type="hidden" name="principalvalue" value="{{ $boleto->Value }}">
                            <input type="hidden" name="duedate" value="{{ entryDate2data($boleto->DueDate) }}">
                            
            				<div class="row">
                                <div class="col-12">
                                    <div class="form-group row">
                                        <div class="col-md-12">
                                            <label>Linha digitável</label>
                                            <p class="spacer-left-30">{{ $boleto->DigitableLine }}</p>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <div class="col-md-6">
                                            <label>Vencimento</label>
                                            <p class="spacer-left-30">{{ entryDate2data($boleto->DueDate) }}</p>
                                        </div>
                                        <div class="col-md-6">
                                            <label>Data do pagamento</label>
                                            <input type="text" class="form-control col-6 spacer-left-30" id="paymentdate" name="paymentdate" value="<?=date('d/m/Y')?>">
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <div class="col-md-6">
                                            <label>Código banco</label>
                                            <p class="spacer-left-30">{{ $boleto->BankCode }}</p>
                                        </div>
                                        <div class="col-md-6">
                                            <label>Banco</label>
                                            <p class="spacer-left-30">{{ $boleto->BankName }}</p>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <div class="col-md-6">
                                            <label>Valor do título</label>
                                            <p class="spacer-left-30"><b>R$ {{ number_format($boleto->Value,2,',','.') }}</b></p>
                                        </div>
                                        <div class="col-md-6">
                                            <label>Desconto</label>
                                            <input type="text" class="form-control col-3 spacer-left-30" id="discountvalue" name="discountvalue" value="0">
                                        </div>
                                    </div>
                                    @if($boleto->ConcessionaireName)
                                        <div class="form-group row">
                                            <div class="col-md-6">
                                                <label>Concessionária</label>
                                                <p class="spacer-left-30">{{ $boleto->ConcessionaireName }}</p>
                                            </div>
                                            <div class="col-md-6">
                                                <label>Código concessionária</label>
                                                <p class="spacer-left-30">{{ $boleto->ConcessionaireCode }}</p>
                                            </div>
                                        </div>
                                    @endif
                                    
                                    <div class="form-group row">
                                        <div class="col-md-6">
                                            <label>Juros + Multa</label>
                                            <input type="text" class="form-control col-3 spacer-left-30" id="extravalue" name="extravalue" value="0">
                                        </div>
                                        <div class="col-md-6">
                                            <label>Identificador</label>
                                            <input type="text" class="form-control col-10 spacer-left-30" id="identifier" name="identifier">
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <div class="custom-control custom-checkbox col-md-8 spacer-left-30">
                                            <input type="checkbox" class="custom-control-input" checked="" name="limiteespecial" id="limiteespecial" value="1">
                                            <label class="custom-control-label" for="limiteespecial">Permitir utilização do saldo a compensar (*)</label>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-12 text-right">
                                        <a href="{{ URL::previous() }}"><button type="reset" class="btn btn-outline-warning mr-1 mb-1 waves-effect waves-light">Voltar</button></a>
                                        <button type="submit" class="btn btn-success mr-1 mb-1 waves-effect waves-light">Realizar pagamento</button>
                                    </div>
                                    <div class="col-12">
                                        <p class="font-small-3">(*) Caso seu limite disponível seja menor que o valor determinado para transferência e você possua saldo a compensar, é possível completar o valor. Sujeito a cobrança de taxas.</p>
                                    </div>
                                </div>
                            </div>
                        </form>
					</div>
				</div>
			</div>
		</div>
	</div>

    <div class="row justify-content-md-center">
        <div class="col-md-8 col-12">
            <div class="card">
                <div class="card-body">
                    <?php $saldoDisponivel = getFitbankBalance();?>
                    @if(!$saldoDisponivel)
                        <p class="text-info">Não foi possível consultar seu saldo disponível no momento</p>
                    @else
                        <div class=" text-center {{ ($saldoDisponivel<0)?'text-danger':'' }}">Saldo Atual: R$ {{ formatMoneyBr($saldoDisponivel) }}</div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('inlinejs')
    <script type="text/javascript">
        $(function() {
            $('#discountvalue, #extravalue').maskMoney({
                prefix:'R$ ', 
                allowNegative: false, 
                thousands:'.', 
                decimal:',', 
                affixesStay: false,
                allowZero: true
            });

            var pickerOpt = {
                monthsFull: ['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'],
                monthsShort: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'],
                weekdaysFull: ['Domingo', 'Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta', 'Sábado'],
                weekdaysShort: ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sab'],
                today: 'Hoje',
                clear: 'Limpar',
                close: 'Fechar',
                labelMonthNext: 'Mês seg.',
                labelMonthPrev: 'Mês ant.',
                labelMonthSelect: 'Selecione um mês',
                labelYearSelect: 'Selecione um ano',
                format: 'dd/mm/yyyy',
                // formatSubmit: 'yyyy/mm/dd',
            };

            $('#paymentdate').pickadate(pickerOpt);

        });
    </script>
@endsection