@extends('layouts.authenticated')

@section('extracss')
    <link rel="stylesheet" href="{{ asset('css/vendors/css/pickers/pickadate/pickadate.css') }}">
@endsection

@section('extrajs')
    <script src="{{ asset('js/jquery.mask.min.js') }}"></script>
    <script src="{{ asset('js/jquery.maskMoney.min.js') }}"></script>

    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.js') }}"></script>
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.date.js') }}"></script>
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.time.js') }}"></script>
    <script src="{{ asset('js/js/scripts/pickers/dateTime/pick-a-datetime.js') }}"></script>
@endsection

@section('content')
<div class="container">
	<div class="row justify-content-md-center">
        <div class="col-md-8 col-12">
        	
        	<div class="card">
        		<div class="card-header">
                    <h4 class="card-title"></h4>
                </div>
        		<div class="card-content">
        			<div class="card-body">

        				<h2>Detalhes do boleto</h2>
                        <form action="/pagamentos/boletos/pagar" method="POST">
                            @csrf
                            <input type="hidden" name="cip" value="1">
                            <input type="hidden" name="barcode" value="{{ $cod_barras['codigo'] }}">
                            <input type="hidden" name="digitableline" value="{{ $boleto->DigitableLine }}">
                            <input type="hidden" name="principalvalue" value="{{ $boleto->Value }}">
                            <input type="hidden" name="totaladdedvalue" value="{{ $boleto->TotalAddedValue }}">
                            <input type="hidden" name="finevalue" value="{{ $boleto->FineValue }}">
                            <input type="hidden" name="interestvalue" value="{{ $boleto->InterestValue }}">
                            <input type="hidden" name="duedate" value="{{ entryDate2data($boleto->DueDate) }}">
                            
                            <input type="hidden" name="totaladdedvalue" value="{{ $boleto->TotalAddedValue }}">
                            <input type="hidden" name="nominalvalue" value="{{ $boleto->NominalValue }}">
                            
            				<div class="row">
                                <div class="col-12">
                                    <div class="form-group row">
                                        <div class="col-md-12">
                                            <label>Linha digitável</label>
                                            <p class="spacer-left-30">{{ $boleto->DigitableLine }}</p>
                                        </div>
                                    </div>
                                    
                                    <div class="form-group row">
                                        <div class="col-md-12">
                                            <label>Banco</label>
                                            <p class="spacer-left-30">{{ $boleto->Drawer }}</p>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <div class="col-md-12">
                                            <label>Nome do beneficiário</label>
                                            <p class="spacer-left-30">{{ $boleto->BeneficiaryName }}</p>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <div class="col-md-12">
                                            <label>CPF/CNPJ do beneficiário</label>
                                            <p class="spacer-left-30">{{ $boleto->TaxNumberBeneficiary }}</p>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <div class="col-md-12">
                                            <label>Nome do solicitante</label>
                                            <p class="spacer-left-30">{{ $boleto->DraweeName }}</p>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <div class="col-md-12">
                                            <label>CPF/CNPJ do solicitante</label>
                                            <p class="spacer-left-30">{{ $boleto->TaxNumberDrawee }}</p>
                                        </div>
                                    </div>                                   


                                    <div class="form-group row">
                                        <div class="col-md-6">
                                            <label>Vencimento</label>
                                            <p class="spacer-left-30">{{ entryDate2data($boleto->DueDate) }}</p>
                                        </div>
                                        <div class="col-md-6">
                                            <label>Data do pagamento</label>
                                            <input type="text" class="form-control col-6 spacer-left-30" id="paymentdate" name="paymentdate" value="<?=date('d/m/Y')?>">
                                        </div>
                                    </div>
                                    
                                    <div class="form-group row">
                                        <div class="col-md-6">
                                            <label>Valor do título</label>
                                            <p class="spacer-left-30"><b>R$ {{ number_format($boleto->Value,2,',','.') }}</b></p>
                                        </div>
                                        <div class="col-md-6">
                                            <label>Desconto</label>
                                            <input type="text" class="form-control col-3 spacer-left-30" id="discountvalue" name="discountvalue" value="{{ number_format($boleto->DiscountValue,2,',','.') }}">
                                        </div>
                                    </div>
                                    
                                    <div class="form-group row">
                                        <div class="col-md-6">
                                            <label>Valor dos juros</label>
                                            <p class="spacer-left-30"><b>R$ {{ number_format($boleto->InterestValue,2,',','.') }}</b></p>
                                        </div>
                                        <div class="col-md-6">
                                            <label>Valor da multa</label>
                                            <p class="spacer-left-30"><b>R$ {{ number_format($boleto->FineValue,2,',','.') }}</b></p>
                                        </div>
                                    </div>
                                    
                                    
                                    <div class="form-group row">
                                        <div class="col-md-6">
                                            <label>Juros + Multa</label>
                                            <p class="spacer-left-30"><b>R$ {{ number_format($boleto->TotalAddedValue,2,',','.') }}</b></p>
                                        </div>
                                        <div class="col-md-6">
                                            <label>Identificador</label>
                                            <input type="text" class="form-control col-10 spacer-left-30" id="identifier" name="identifier">
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <div class="custom-control custom-checkbox col-md-8 spacer-left-30">
                                            <input type="checkbox" class="custom-control-input" checked="" name="limiteespecial" id="limiteespecial" value="1">
                                            <label class="custom-control-label" for="limiteespecial">Permitir utilização do saldo a compensar (*)</label>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-12 text-right">
                                        <a href="{{ URL::previous() }}"><button type="reset" class="btn btn-outline-warning mr-1 mb-1 waves-effect waves-light">Voltar</button></a>
                                        <button type="submit" class="btn btn-success mr-1 mb-1 waves-effect waves-light">Realizar pagamento</button>
                                    </div>
                                    <div class="col-12 text-center">Limite da Operação (*): R$ {{ formatMoneyBr($limiteoperacao) }}
                                    </div><br>
                                    <div class="col-12">
                                        <p class="font-small-3">(*) Caso seu limite disponível seja menor que o valor determinado para transferência e você possua saldo a compensar, é possível completar o valor. Sujeito a cobrança de taxas.</p>
                                    </div>
                                </div>
                            </div>
                        </form>
					</div>
				</div>
			</div>
		</div>
	</div>

    <div class="row justify-content-md-center">
        <div class="col-md-8 col-12">
            <div class="card">
                <div class="card-body">
                    <?php $saldoDisponivel = getFitbankBalance();?>
                    @if(!$saldoDisponivel)
                        <p class="text-info">Não foi possível consultar seu saldo disponível no momento</p>
                    @else
                        <div class=" text-center {{ ($saldoDisponivel<0)?'text-danger':'' }}">Saldo Atual: R$ {{ formatMoneyBr($saldoDisponivel) }}</div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('inlinejs')
    <script type="text/javascript">
        $(function() {
            $('#discountvalue, #extravalue').maskMoney({
                prefix:'R$ ', 
                allowNegative: false, 
                thousands:'.', 
                decimal:',', 
                affixesStay: false,
                allowZero: true
            });

            var pickerOpt = {
                monthsFull: ['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'],
                monthsShort: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'],
                weekdaysFull: ['Domingo', 'Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta', 'Sábado'],
                weekdaysShort: ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sab'],
                today: 'Hoje',
                clear: 'Limpar',
                close: 'Fechar',
                labelMonthNext: 'Mês seg.',
                labelMonthPrev: 'Mês ant.',
                labelMonthSelect: 'Selecione um mês',
                labelYearSelect: 'Selecione um ano',
                format: 'dd/mm/yyyy',
                // formatSubmit: 'yyyy/mm/dd',
            };

            $('#paymentdate').pickadate(pickerOpt);

        });
    </script>
@endsection