@extends('layouts.authenticated')

@section('extrajs')
    <script src="{{ asset('js/jquery.mask.min.js') }}"></script>
@endsection

@section('content')
<div class="container">

    <?php $multicnpj = getMultiCnpj();?>
    
    @if(!empty($multicnpj))
        <?php $multiCofres = multiCofres(Session::get('cnpj'), Request::path());?>
        {!! $multiCofres !!}
    @endif
    
	<div class="row justify-content-md-center">
        <div class="col-md-8 col-12">

            <div class="card">
                <div class="card-content">
                    <div class="card-body">
                        <div class=" text-center ">Limite da Operação (*): R$ {{ formatMoneyBr($limiteoperacao) }}</div>
                    </div>
                </div>
            </div>
        	
        	<div class="card">
        		<div class="card-header">
                    <h4 class="card-title"></h4>
                </div>
        		<div class="card-content">
        			<div class="card-body">

        				<h2>Digite o código de barras</h2>
                        <form action="" method="post" onsubmit="return validaForm()">
                            @csrf
        				<div class="row">
                            <div class="col-12">
                                <div class="form-group row">
                                    <div class="col-md-12">
                                        <input type="text" class="form-control" id="barcode" name="barcode" placeholder="Código de barras">
                                    </div>
                                </div>
                                <div class="col-md-12 text-right">
                                    <button type="reset" class="btn btn-outline-warning mr-1 mb-1 waves-effect waves-light">Limpar</button>
                                    <button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light">Avançar</button>
                                </div>
                            </div>
                        </div>
                        </form>

					</div>
				</div>
			</div>
		</div>
	</div>
</div>

@endsection

@section('inlinejs')
    <script type="text/javascript">
        function validaForm() {
            if($('#barcode').val() == '') {
                alert('Informe o código de barras.');
                return false;
            }
        }
        $('#barcode').mask('#');
    </script>
@endsection