@extends('layouts.authenticated')

@section('extracss')
<link rel="stylesheet" href="{{ asset('css/vendors/css/pickers/pickadate/pickadate.css') }}">
@endsection

@section('extrajs')
<script src="{{ asset('js/vendors/js/pickers/pickadate/picker.js') }}"></script>
<script src="{{ asset('js/vendors/js/pickers/pickadate/picker.date.js') }}"></script>
<script src="{{ asset('js/vendors/js/pickers/pickadate/picker.time.js') }}"></script>
<script src="{{ asset('js/js/scripts/pickers/dateTime/pick-a-datetime.js') }}"></script>

@endsection

@section('content')
<div class="container">

	<?php $multicnpj = getMultiCnpj();?>

	@if(!empty($multicnpj))
		<?php $multiCofres = multiCofres(Session::get('cnpj'), Request::path());?>
		{!! $multiCofres !!}
	@endif

	@if($errorOnUpdate)
		<div class="row justify-content-md-center">
			<div class="col-md-12 col-12">
				<div class="card">
					<div class="card-body">
						<span class="badge bg-danger">
							<i class="fa fa-exclamation"></i></span>
						- Há uma ou mais transferências que podem estar desatualizadas
					</div>
				</div>
			</div>
		</div>
	@endif

	<div class="row justify-content-md-center">
		<div class="col-md-12 col-12">
			<div class="card">
				<div class="card-body">
					<div class="table-responsive">
						<table class="table table-bordered table-striped">
							<thead>
								<tr>
									<th class="text-center">
										Data
									</th>
									<th class="text-center">
										Situação
									</th>
									<th class="text-center">
										Detalhes
									</th>
									<th class="text-center">
										Valor
									</th>
									<th class="text-center">
										Identificador
									</th>
									<th class="text-center">
										Comp.
									</th>
									<th class="text-center">
										Ações
									</th>
								</tr>
							</thead>
							<tbody>
								@foreach($transfers as $transfer)
															<?php $cliente = getClientById($transfer['client_id']) ?>
															<?php $user = getUserById($transfer['user_id']) ?>
															<tr>
																<th class="text-nowrap" scope="row">
																	{{ datetime2br($transfer['actiondate']) }}
																</th>
																<td class="text-nowrap">
																	Agendado
																	@if(isset($transfer['errorOnUpdate']))
																		<span class="badge bg-danger"
																			data-toggle="tooltip"
																			data-placement="top"
																			title="A situação pode estar desatualizada!">
																			<i
																				class="fa fa-exclamation"></i></span>
																	@endif
																</td>
																<td class="text-nowrap">{!!
									"Nome:&nbsp;<strong>" . $transfer['nome'] . "</strong><br>" .
									"Documento:&nbsp;<strong>" . formataCNPJ($transfer['documento']) . "</strong><br>" .
									"Banco:&nbsp;<strong>" . $transfer['banco'] . "</strong><br>" .
									"Agência:&nbsp;<strong>" . $transfer['agencia'] . "</strong><br>" .
									"Conta:&nbsp;<strong>" . $transfer['conta'] . "-" . $transfer['digito'] . "</strong><br>" .
									"Tipo conta:&nbsp;<strong>" . (($transfer['tipoconta'] == 0) ? 'Corrente' : 'Poupança') . "</strong>"
																									!!}</td>
																<td class="text-nowrap">R$
																	{{ formatMoneyBr($transfer['valor']) }}
																</td>
																<td class="text-nowrap">
																	{{ $transfer['identificador'] }}
																</td>
																<td class="text-center">
																	@if(!empty($transfer['url']))
																		<a href="{{ $transfer['url'] }}"
																			target="_blank"
																			class="text-danger"><i
																				class="fa fa-file-pdf-o"></i></a>
																	@endif
																</td>
																<td class="text-center">
																	<a href="#cancelModal{{ $transfer['documentnumber'] }}"
																		data-toggle="modal">
																		<button type="button"
																			class="btn btn-danger btn-sm"
																			style="float:right">Cancelar</button>
																	</a>
																</td>
															</tr>

															<!-- Modal -->
															<div class="modal fade text-left"
																id="cancelModal{{ $transfer['documentnumber'] }}"
																tabindex="-1" role="dialog"
																aria-labelledby="cancelModalLabel{{ $transfer['documentnumber'] }}"
																aria-hidden="true">
																<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable"
																	role="document">
																	<div class="modal-content">
																		<div class="modal-header">
																			<h4 class="modal-title"
																				id="cancelModalLabel{{ $transfer['documentnumber'] }}">
																				Cancelar
																				Agendamento
																			</h4>
																			<button type="button"
																				class="close"
																				data-dismiss="modal"
																				aria-label="Close">
																				<span
																					aria-hidden="true">&times;</span>
																			</button>
																		</div>
																		<form action="{{ route('transferencias.agendamento.cancelar')}}"
																			method="POST">
																			@csrf
																			<input type="hidden"
																				name="documentNumber"
																				value="{{$transfer['documentnumber']}}" />
																			<div class="modal-body">
																				<p>Deseja
																					confirmar
																					o
																					cancelamento
																					da
																					transferência
																					agendada?
																				</p>
																			</div>
																			<div
																				class="modal-footer">
																				<button type="button"
																					class="btn btn-secondary"
																					data-dismiss="modal">Fechar</button>
																				<button type="submit"
																					class="btn btn-danger">Confirmar</button>
																			</div>
																		</form>
																	</div>
																</div>
															</div>
								@endforeach

							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection