@extends('layouts.authenticated')

@section('extracss')
    
@endsection

@section('extrajs')
    <script src="{{ asset('js/jquery.maskMoney.min.js') }}"></script>
@endsection

@section('content')
<div class="container">
	<div class="row justify-content-md-center">
        <div class="col-md-8 col-12 text-right">
            <h2>Transferência Simples - Cliente</h2>
        </div>
    </div>
    <div class="row justify-content-md-center">
        <div class="col-md-8 col-12">
        	
        	<div class="card">
        		<div class="card-header">
                    <h4 class="card-title">Transferência para conta Fitbank Cliente</h4>
                </div>
        		<div class="card-content">
        			<div class="card-body">
        				<br>
			        	<form action="{{ url('/transferenciacliente') }}" method="POST">
			        		@csrf
			                <div class="form-body">
			                    <div class="row">
			                        <div class="col-12">
			                            <div class="form-group row">
			                                <div class="col-md-4">
			                                    <span>Cliente</span>
			                                </div>
			                                <div class="col-md-8">
			                                    <select id="client_id" class="form-control" name="taxnumber">
			                                    	<option value="0"> - Selecione - </option>
			                                    	@foreach($clients as $client)
			                                    		<option value="{{ $client->taxnumber }}">{{ $client->name }} &nbsp;&nbsp;[R$ {{ formatMoneyBr($client->availablelimit) }}]</option>

			                                    		@foreach($client->multiconta as $multi)
				                                    		<option value="{{ $multi->taxnumber }}"> - {{ $multi->nickname }} &nbsp;&nbsp;[R$ {{ formatMoneyBr($multi->availablelimit) }}]</option>
				                                    	@endforeach

			                                    	@endforeach
			                                    </select>
			                                </div>
			                            </div>
			                        </div>
			                        <div class="col-12">
			                            <div class="form-group row">
			                                <div class="col-md-4">
			                                    <span>Valor</span>
			                                </div>
			                                <div class="col-md-8">
			                                    <input type="valor" id="valor" class="form-control" name="valor" placeholder="Valor" value="">
			                                </div>
			                            </div>
			                        </div>

			                        
			                        <div class="col-12">
			                            <div class="form-group row">
			                                <div class="col-md-4">
			                                    <span>Identificador</span>
			                                </div>
			                                <div class="col-md-8">
			                                    <input type="identifier" id="identifier" class="form-control" name="identifier" placeholder="Identificador" value="">
			                                </div>
			                            </div>
			                        </div>
			                        <div class="col-md-8 offset-md-4">
			                            <button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light">Enviar</button>
			                            <button type="reset" class="btn btn-outline-warning mr-1 mb-1 waves-effect waves-light">Limpar</button>
			                        </div>
			                    </div>
			                </div>
			            </form>

					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row justify-content-md-center">
        <div class="col-md-8 col-12">
			<div class="card">
				<div class="card-body">
					<div class=" text-center {{ ($extrato['Balance']<0)?'text-danger':'' }}">Saldo SPS: R$ {{ formatMoneyBr($extrato['Balance']) }}</div>
				</div>
			</div>
		</div>
	</div>
</div>

@endsection

@section('inlinejs')
	<script type="text/javascript">
		$(function() {
		    $('#valor').maskMoney({
		    	prefix:'R$ ', 
		    	allowNegative: false, 
		    	thousands:'.', 
		    	decimal:',', 
		    	affixesStay: false
		    });
		})
	</script>
@endsection
