@extends('layouts.authenticated')

@section('extrajs')
    <script src="{{ asset('js/jquery.mask.min.js') }}"></script>
    <script src="{{ asset('js/jquery.maskMoney.min.js') }}"></script>
@endsection

@section('content')
<div class="container">
	<div class="row justify-content-md-center">
        <div class="col-md-8 col-12 text-right">
            <h2>Clientes</h2>
        </div>
    </div>
    <div class="row justify-content-md-center text-right separator-b-10">
		<div class="col-md-8 col-12 text-right">
			<button type="button" class="btn btn-md btn-icon btn-success waves-effect waves-light" data-toggle="modal" data-target="#inlineForm"><i class="feather icon-plus"></i> Adicionar cliente</button>
		</div>
	</div>

    <div class="row justify-content-md-center">
        <div class="col-md-8 col-12">
			<div class="card">
                <div class="card-header">
                    <h4 class="card-title {{ ($client->active==0)?'text-muted':'' }}"> 
                        {{ $client->nickname }} &nbsp;&nbsp;&nbsp; @if($client->active==0) <span class="badge badge-light">Inativo</span> @endif
                    </h4>
                    @if(empty($client->businessunitid))
                        <a href="{{ url('/enviaclientefitbank/'.$client->id) }}"><button class="btn btn-sm btn-info">Enviar para Fitbank</button></a>
                    @endif
                </div>
	            <div class="card-body">
                    <div class="mt-1 text-right">
                        <a href="{{ url('clientes/'.$client->id.'/editar') }}">
                            <i class="feather icon-edit text-primary"></i>
                        </a>
                        &nbsp;&nbsp;&nbsp;
                        <a href="#" data-toggle="modal" data-target="#status-{{$client->id}}">
                            <i class="feather {{ ($client->active==0)?'icon-check-circle text-success':'icon-x-circle text-danger' }}"></i>
                        </a>
                    </div>

                    <div class="mt-1">
                        <h6 class="mb-0">Razão social</h6>
                        <p>{{ $client->name }}</p>
                    </div>
                    <div class="mt-1">
                        <h6 class="mb-0">CNPJ/CPF</h6>
                        <p>{{ formataCNPJ($client->taxnumber) }}</p>
                    </div>
                    <div class="mt-1">
                        <h6 class="mb-0">Id interno Fitbank</h6>
                        <p>{{ $client->businessunitid }}</p>
                    </div>
                    <div class="mt-1">
                        <h6 class="mb-0">Email</h6>
                        <p>{{ $client->mail }}</p>
                    </div>
                    <div class="mt-1">
                        <h6 class="mb-0">Telefone</h6>
                        <p>{{ $client->phone }}</p>
                    </div>

                   {{--  <div class="mt-1">
                        <h6 class="mb-0">Código do Banco</h6>
                        <p>{{ $client->banknumber }}</p>
                    </div>

                    <div class="mt-1">
                        <h6 class="mb-0">Agência</h6>
                        <p>{{ $client->bankbranch }}</p>
                    </div>

                    <div class="mt-1">
                        <h6 class="mb-0">Conta</h6>
                        <p>{{ $client->bankaccount }}</p>
                    </div>
--}}


                <div class="row">
                    <div class="col-12">
                        
                        <div class="divider divider-info">
                            <div class="divider-text">Informações bancárias</div>
                        </div>

                        <br><br>

                        <div class="mt-1">
                            <h6 class="mb-0">Banco</h6>
                            <p>{{ $client->banknumber }}</p>
                        </div>
                        <div class="mt-1">
                            <h6 class="mb-0">Agência</h6>
                            <p>{{ formataCNPJ($client->bankbranch) }}</p>
                        </div>
                        <div class="mt-1">
                            <h6 class="mb-0">Conta</h6>
                            <p>{{ $client->bankaccount }} - {{ $client->bankaccountdigit }}</p>
                        </div>
                        <div class="mt-1">
                            <h6 class="mb-0">Permitir limite especial</h6>
                            <p>{{ ($client->availablelimit==1)?'Sim':'Não' }}</p>
                        </div>

                        <div class="mt-1">
                            <h6 class="mb-0">Saldo disponível</h6>
                            <p>R$ {{ formatMoneyBr($client->availablelimit) }}</p>
                        </div>

                        <div class="mt-1">
                            <h6 class="mb-0">Alterar saldo disponível</h6>
                            <form action="{{ url('/clientes/'.$client->id.'/atualizasaldodisponivel') }}" method="POST" class="form form-horizontal">
                                @csrf
                                <div class="form-body">
                                <div class="form-group row">
                                    <div class="col-md-4">
                                        <input type="hidden" name="client_id" value="{{ $client->id }}">
                                        <input type="hidden" name="taxnumber" value="{{ $client->taxnumber }}">
                                        <input type="text" id="valor" class="form-control valor" name="valor" value="{{formatMoneyBr($client->availablelimit)}}">    
                                    </div>
                                    <div class="col-md-4">
                                        <button type="submit" class="btn btn-primary btn-block" value="Atualizar">Atualizar saldo</button>    
                                    </div>
                                </div>
                                </div>
                            </form>
                        </div>
                        

                        <?php $multicnpj = getMultiCnpj($client->id);?>
                        
                        @if($multicnpj->count() > 0)
                            <br>
                            <div class="divider divider-info">
                                <div class="divider-text"><h4>Contas adicionais</h4></div>
                            </div>
                            
                            @foreach($multicnpj as $multi)

                                @if($multi->active==1)
                                    <h4><mark>{{ formataCNPJ($multi->taxnumber) }}</mark>
                                        @if($multi->businessunitid < 1)
                                            <a href="{{ url('/enviaclientemultifitbank/'.$multi->taxnumber) }}"><button class="btn btn-sm btn-info">Enviar para Fitbank</button></a>
                                        @endif
                                    </h4>

                                    <div class="mt-1">
                                        <h6 class="mb-0">Saldo disponível</h6>
                                        <p>R$ {{ formatMoneyBr($multi->availablelimit) }}</p>
                                    </div>

                                    <div class="mt-1">
                                        <h6 class="mb-0">Alterar saldo disponível</h6>
                                        <form action="{{ url('/clientes/'.$client->id.'/atualizasaldodisponivel') }}" method="POST" class="form form-horizontal">
                                            @csrf
                                            <div class="form-body">
                                            <div class="form-group row">
                                                <div class="col-md-4">
                                                    <input type="hidden" name="client_id" value="{{ $client->id }}">
                                                    <input type="hidden" name="taxnumber" value="{{ $multi->taxnumber }}">
                                                    <input type="text" id="valor" class="form-control valor" name="valor" value="{{formatMoneyBr($multi->availablelimit)}}">    
                                                </div>
                                                <div class="col-md-4">
                                                    <button type="submit" class="btn btn-primary btn-block" value="Atualizar">Atualizar saldo</button>    
                                                </div>
                                            </div>
                                            </div>
                                        </form>
                                    </div>
                                @else

                                    <p class="text-muted font-medium-3">{{ formataCNPJ($multi->taxnumber) }} (inativa)</p>
                                    <br>

                                @endif
                                <br>
                            @endforeach

                        @endif
                    </div>
                </div>

                <br><br>

                <div class="row">
                    <div class="col-12">
                            <div class="divider divider-info">
                                <div class="divider-text">Taxas</div>
                            </div>

                            <br><br>

                            <div class="row">
                            <div class="col-12">
                                <div class="form-group row">
                                    <div class="col-md-4">
                                        <span>Taxas diferenciadas:</span>
                                    </div>
                                    <div class="col-md-4">
                                        <strong>{{ ($client->customrates==1)?'Sim':'Não' }}</strong>
                                    </div>
                                </div>
                            </div>
                            </div>

                            <div class="row">
                            <div class="col-12">
                                <div class="form-group row">
                                    <div class="col-md-4">
                                        <span>Dia do vencimento tarifa:</span>
                                    </div>
                                    <div class="col-md-4">
                                        <strong>{{ $client->monthlyfeedueday }}</strong>
                                    </div>
                                </div>
                            </div>
                            </div>

                            <table class="table table-striped table-bordered">
                                <thead>
                                    <th>Transação</th>
                                    <th class="text-center">Custo</th>
                                    <th class="text-center">Tipo</th>
                                </thead>
                                <tbody>
                                    <tr>
                                        <th scope="row">Pagamentos</th>
                                        <td class="text-center">{{ ($client->paymentspercentage=='1')?formatMoneyBr($client->payments).'%':'R$ '.formatMoneyBr($client->payments) }}</td>
                                        <td class="text-center">{{ ($client->paymentspercentage=='1')?'percentual':'fixo' }}</td>
                                    </tr>
                                    <tr>
                                        <th scope="row">Transferências (DOC/TED)</th>
                                        <td class="text-center">{{ ($client->transferspercentage=='1')?formatMoneyBr($client->transfers).'%':'R$ '.formatMoneyBr($client->transfers) }}</td>
                                        <td class="text-center">{{ ($client->transferspercentage=='1')?'percentual':'fixo' }}</td>
                                    </tr>
                                    <tr>
                                        <th scope="row">Geração de boletos</th>
                                        <td class="text-center">{{ ($client->billetspercentage=='1')?formatMoneyBr($client->billets).'%':'R$ '.formatMoneyBr($client->billets) }}</td>
                                        <td class="text-center">{{ ($client->billetspercentage=='1')?'percentual':'fixo' }}</td>
                                    </tr>
                                    <tr>
                                        <th scope="row">Adiantamento de saldo</th>
                                        <td class="text-center">{{ ($client->balanceusagepercentage=='1')?formatMoneyBr($client->balanceusage).'%':'R$ '.formatMoneyBr($client->balanceusage) }}</td>
                                        <td class="text-center">{{ ($client->balanceusagepercentage=='1')?'percentual':'fixo' }}</td>
                                    </tr>
                                    <tr>
                                        <th scope="row">Tarifa mensal</th>
                                        <td class="text-center">{{ formatMoneyBr($client->monthlyfee) }}</td>
                                        <td class="text-center">Fixo</td>
                                    </tr>
                                </tbody>
                            </table>
                    </div>
                </div>

                    <br><br>

                    <div class="divider divider-info">
                        <div class="divider-text">Usuário(s)</div>
                    </div>
                    <br><br>
                    <div class="mt-1 text-right">
                        <button type="button" class="btn btn-md btn-icon btn-success waves-effect waves-light" data-toggle="modal" data-target="#cliente_usuario_{{$client->id}}"><i class="feather icon-user-plus"></i></button>
                    </div>
                    <?php $usuarios = usuariosCliente($client->id); ?>
                    @foreach($usuarios as $usr)
                        <p class="{{ ($usr->active==0)?'text-muted':'' }}">{{ $usr->name.' ('.$usr->email.')' }} &nbsp;&nbsp;&nbsp; @if($usr->active==0) <span class="badge badge-light">Inativo</span> @endif</p>
                    @endforeach

	            </div>
	        </div>

                {{-- MODAL EDITA USUARIO --}}
                <div class="modal fade text-left" id="cliente_usuario_{{$client->id}}" tabindex="-1" role="dialog" aria-labelledby="myModalLabel33" style="display: none;" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h4 class="modal-title" id="myModalLabel33">{{ $client->nickname }} - Novo usuário</h4>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">×</span>
                                </button>
                            </div>
                            <form action="{{ url('/usuarios') }}" method="POST">
                                @csrf
                                <div class="modal-body">
                                    
                                    <input type="hidden" name="client_id" value="{{$client->id}}">

                                    <label>Nome: </label>
                                    <div class="form-group">
                                        <input type="text" name="name" placeholder="Nome" class="form-control">
                                    </div>

                                    <label>Email: </label>
                                    <div class="form-group">
                                        <input type="text" name="email" placeholder="Email Address" class="form-control">
                                    </div>
                                    <div class="font-small-3">
                                        <i class="feather icon-alert-triangle text-warning"></i>&nbsp;<span class="text-danger">Uma senha será gerada e enviada para o email.</span>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-primary waves-effect waves-light" data-dismiss="modal">Fechar</button>
                                    <button type="submit" class="btn btn-primary waves-effect waves-light">Salvar</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                {{-- MODAL EDITA USUARIO --}}

                {{-- MODAL STATUS CLIENTE --}}
                <div class="modal fade text-left" id="status-{{ $client->id }}" tabindex="-1" role="dialog" aria-labelledby="myModalLabel33" style="display: none;" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h4 class="modal-title" id="myModalLabel33">{{ $client->name }} - {{ ($client->active==1)?'Desativar':'Ativar' }}</h4>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">×</span>
                                </button>
                            </div>
                            <form action="{{ url('/clientes/'.$client->id.'/mudastatus') }}" method="POST">
                                @csrf
                                <div class="modal-body">
                                    <input type="hidden" name="id" value="{{ $client->id }}">
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-primary waves-effect waves-light" data-dismiss="modal">Fechar</button>
                                    <button type="submit" class="btn btn-primary waves-effect waves-light">{{ ($client->active==1)?'Desativar':'Ativar' }}</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                {{-- MODAL STATUS CLIENTE --}}


		</div>
	</div>
</div>



{{-- MODAL CRIA CLIENTE --}}
<div class="modal fade text-left" id="inlineForm" tabindex="-1" role="dialog" aria-labelledby="myModalLabel33" style="display: none;" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="myModalLabel33">Novo cliente</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form action="{{ url('/clientes') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <label>Razão social</label>
                    <div class="form-group">
                        <input type="text" name="name" placeholder="Nome" class="form-control">
                    </div>

                    <label>Nome fantasia</label>
                    <div class="form-group">
                        <input type="text" name="nickname" placeholder="" class="form-control">
                    </div>

                    <label>CNPJ/CPF</label>
                    <div class="form-group">
                        <input type="text" name="taxnumber" id="cpfcnpj" placeholder="" class="form-control">
                    </div>

                    <label>Email</label>
                    <div class="form-group">
                        <input type="text" name="mail" placeholder="" class="form-control">
                    </div>

                    <label>Telefone</label>
                    <div class="form-group">
                        <input type="text" name="phone" placeholder="" class="form-control">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary waves-effect waves-light" data-dismiss="modal">Fechar</button>
                    <button type="submit" class="btn btn-primary waves-effect waves-light">Salvar</button>
                </div>
            </form>
        </div>
    </div>
</div>
{{-- MODAL CRIA CLIENTE --}}

@endsection

@section('inlinejs')
<script type="text/javascript">
    var options = {
        onKeyPress: function (cpf, ev, el, op) {
            var masks = ['000.000.000-000', '00.000.000/0000-00'];
            $('#cpfcnpj').mask((cpf.length > 14) ? masks[1] : masks[0], op);
        }
    }

    $('#cpfcnpj').length > 11 ? $('#cpfcnpj').mask('00.000.000/0000-00', options) : $('#cpfcnpj').mask('000.000.000-00#', options);

    $(function() {
        $('#valor').maskMoney({
            prefix:'', 
            allowNegative: false, 
            thousands:'.', 
            decimal:',', 
            affixesStay: false,
            allowZero: true
        });
    });
</script>
@endsection

