@extends('layouts.authenticated')

@section('extracss')
    <link rel="stylesheet" href="{{ asset('css/vendors/css/pickers/pickadate/pickadate.css') }}">
@endsection

@section('extrajs')
    <script src="{{ asset('js/jquery.maskMoney.min.js') }}"></script>
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.js') }}"></script>
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.date.js') }}"></script>
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.time.js') }}"></script>
    <script src="{{ asset('js/js/scripts/pickers/dateTime/pick-a-datetime.js') }}"></script>

@endsection

@section('content')
<div class="container">
	<div class="row justify-content-md-center">
        <div class="col-md-8 col-12">
        	
        	<div class="card">
        		<div class="card-header">
                    <h4 class="card-title">Editar Configurações</h4>
                </div>
        		<div class="card-content">
        			<div class="card-body">
                        <form action="{{ url('/spsinfo') }}" method="POST">
                            {!! csrf_field() !!}
                            <input type="hidden" name="id" value="{{ $spsinfos->id }}">

                        <ul class="nav nav-tabs nav-fill" id="myTab" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active" id="info-tab-fill" data-toggle="tab" href="#info-fill" role="tab" aria-controls="info-fill" aria-selected="false">Informações</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="fitbankrates-tab-fill" data-toggle="tab" href="#fitbankrates-fill" role="tab" aria-controls="fitbankrates-fill" aria-selected="false">Taxas Fitbank</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="clientrates-tab-fill" data-toggle="tab" href="#clientrates-fill" role="tab" aria-controls="clientrates-fill" aria-selected="false">Taxas Clientes</a>
                            </li>
                        </ul>

                        <div class="tab-content pt-1">
                            {{-- ABA INFORMAÇÔES --}}
                            <div class="tab-pane active" id="info-fill" role="tabpanel" aria-labelledby="info-tab-fill">
                                <label>Nome: </label>
                                <div class="form-group">
                                    <input type="text" name="name" placeholder="Nome" class="form-control" value="{{ $spsinfos->name }}">
                                </div>

                                <label>CNPJ: </label>
                                <div class="form-group">
                                    <input type="text" name="cnpj" placeholder="" class="form-control" value="{{ formataCNPJ($spsinfos->cnpj) }}">
                                </div>

                                <label>Id interno Fitbank - Business Unit Id: </label>
                                <div class="form-group">
                                    <input type="text" name="businessunitid" placeholder="" class="form-control" value="{{ $spsinfos->businessunitid }}">
                                </div>

                                <label>Partner Id: </label>
                                <div class="form-group">
                                    <input type="text" name="partnerid" placeholder="" class="form-control" value="{{ $spsinfos->partnerid }}">
                                </div>

                                <label>Key: </label>
                                <div class="form-group">
                                    <input type="text" name="key" placeholder="" class="form-control" value="{{ $spsinfos->key }}">
                                </div>

                                <label>Secret: </label>
                                <div class="form-group">
                                    <input type="text" name="secret" placeholder="" class="form-control" value="{{ $spsinfos->secret }}">
                                </div>

                                <label>MarketPlaceId (Interno Fitbank): </label>
                                <div class="form-group">
                                    <input type="text" name="mktplaceid" placeholder="" class="form-control" value="{{ $spsinfos->mktplaceid }}">
                                </div>

                                <label>Email: </label>
                                <div class="form-group">
                                    <input type="text" name="suppliermail" placeholder="" class="form-control" value="{{ $spsinfos->suppliermail }}">
                                </div>

                                <label>Telefone: </label>
                                <div class="form-group">
                                    <input type="text" name="supplierphone" placeholder="" class="form-control" value="{{ $spsinfos->supplierphone }}">
                                </div>

                                <br><br>

                                <div class="divider divider-primary">
                                    <div class="divider-text">Horários limite para transações</div>
                                </div>

                                <br>

                                <div class="form-body">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="form-group row">
                                                <div class="col-md-4">
                                                    <span>Pagamentos</span>
                                                </div>
                                                <div class="col-md-4">
                                                    <input type="text" id="paymentstimelimit" class="form-control pickatime" name="paymentstimelimit" value="{{ $spsinfos->paymentstimelimit }}">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="form-group row">
                                                <div class="col-md-4">
                                                    <span>Transferências</span>
                                                </div>
                                                <div class="col-md-4">
                                                    <input type="text" id="transferstimelimit" class="form-control pickatime" name="transferstimelimit" value="{{ $spsinfos->transferstimelimit }}">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="form-group row">
                                                <div class="col-md-4">
                                                    <span>Geração de boletos</span>
                                                </div>
                                                <div class="col-md-4">
                                                    <input type="text" id="billetstimelimit" class="form-control pickatime" name="billetstimelimit" value="{{ $spsinfos->billetstimelimit }}">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                   


                                
                            </div>

                            {{-- ABA TAXAS FITBANK --}}
                            <div class="tab-pane" id="fitbankrates-fill" role="tabpanel" aria-labelledby="fitbankrates-tab-fill">
                               
                                <table class="table table-striped table-bordered">
                                    <thead>
                                        <th>Transação</th>
                                        <th class="text-center">Custo</th>
                                        <th class="text-center">Tipo</th>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <th scope="row">Pagamentos</th>
                                            <td class="text-center"><input type="text" id="fitbankpayments" class="form-control input-align-right" name="fitbankpayments" value="{{ covertFloat2Br($spsinfos->fitbankpayments) }}"></td>
                                            <td class="text-center">
                                                <select name="fitbankpaymentspercentage" class="form-control">
                                                    <option value="1" {{ ($spsinfos->fitbankpaymentspercentage=='1')?'selected':'' }}>Percentual</option>
                                                    <option value="0" {{ ($spsinfos->fitbankpaymentspercentage=='0')?'selected':'' }}>Valor fixo</option>
                                                </select>
                                            </td>
                                            
                                        </tr>
                                        <tr>
                                            <th scope="row">Transferências (DOC/TED)</th>
                                            <td class="text-center"><input type="text" id="fitbanktransfers" class="form-control input-align-right" name="fitbanktransfers" value="{{ covertFloat2Br($spsinfos->fitbanktransfers) }}"></td>
                                            <td class="text-center">
                                                <select name="fitbanktransferspercentage" class="form-control">
                                                    <option value="1" {{ ($spsinfos->fitbanktransferspercentage=='1')?'selected':'' }}>Percentual</option>
                                                    <option value="0" {{ ($spsinfos->fitbanktransferspercentage=='0')?'selected':'' }}>Valor fixo</option>
                                                </select>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th scope="row">Geração de boletos</th>
                                            <td class="text-center"><input type="text" id="fitbankbillets" class="form-control input-align-right" name="fitbankbillets" value="{{ covertFloat2Br($spsinfos->fitbankbillets) }}"></td>
                                            <td class="text-center">
                                                <select name="fitbankbilletspercentage" class="form-control">
                                                    <option value="1" {{ ($spsinfos->fitbankbilletspercentage=='1')?'selected':'' }}>Percentual</option>
                                                    <option value="0" {{ ($spsinfos->fitbankbilletspercentage=='0')?'selected':'' }}>Valor fixo</option>
                                                </select>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th scope="row">P2P</th>
                                            <td class="text-center"><input type="text" id="fitbankp2p" class="form-control input-align-right" name="fitbankp2p" value="{{ covertFloat2Br($spsinfos->fitbankp2p) }}"></td>
                                            <td class="text-center">
                                                <select name="fitbankp2ppercentage" class="form-control">
                                                    <option value="1" {{ ($spsinfos->fitbankp2ppercentage=='1')?'selected':'' }}>Percentual</option>
                                                    <option value="0" {{ ($spsinfos->fitbankp2ppercentage=='0')?'selected':'' }}>Valor fixo</option>
                                                </select>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th scope="row">Juros diário por adiantamento de saldo (%)</th>
                                            <td class="text-center"><input type="text" id="clientbalanceusagedailycharge" class="form-control input-align-right" name="clientbalanceusagedailycharge" value="{{ covertFloat2Br($spsinfos->clientbalanceusagedailycharge) }}"></td>
                                            <td class="text-center">
                                                
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>

                            </div>

                            {{-- ABA TAXAS DO CLIENTE --}}
                            <div class="tab-pane" id="clientrates-fill" role="tabpanel" aria-labelledby="clientrates-tab-fill">

                                <table class="table table-striped table-bordered">
                                    <thead>
                                        <th>Transação</th>
                                        <th class="text-center">Custo</th>
                                        <th class="text-center">Tipo</th>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <th scope="row">Pagamentos</th>
                                            <td class="text-center"><input type="text" id="clientpayments" class="form-control input-align-right" name="clientpayments" value="{{ covertFloat2Br($spsinfos->clientpayments) }}"></td>
                                            <td class="text-center">
                                                <select name="clientpaymentspercentage" class="form-control">
                                                    <option value="1" {{ ($spsinfos->clientpaymentspercentage=='1')?'selected':'' }}>Percentual</option>
                                                    <option value="0" {{ ($spsinfos->clientpaymentspercentage=='0')?'selected':'' }}>Valor fixo</option>
                                                </select>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th scope="row">Transferências (DOC/TED)</th>
                                            <td class="text-center"><input type="text" id="clienttransfers" class="form-control input-align-right" name="clienttransfers" value="{{ covertFloat2Br($spsinfos->clienttransfers) }}"></td>
                                            <td class="text-center">
                                                <select name="clienttransferspercentage" class="form-control">
                                                    <option value="1" {{ ($spsinfos->clienttransferspercentage=='1')?'selected':'' }}>Percentual</option>
                                                    <option value="0" {{ ($spsinfos->clienttransferspercentage=='0')?'selected':'' }}>Valor fixo</option>
                                                </select>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th scope="row">Geração de boletos</th>
                                            <td class="text-center"><input type="text" id="clientbillets" class="form-control input-align-right" name="clientbillets" value="{{ covertFloat2Br($spsinfos->clientbillets) }}"></td>
                                            <td class="text-center">
                                                <select name="clientbilletspercentage" class="form-control">
                                                    <option value="1" {{ ($spsinfos->clientbilletspercentage=='1')?'selected':'' }}>Percentual</option>
                                                    <option value="0" {{ ($spsinfos->clientbilletspercentage=='0')?'selected':'' }}>Valor fixo</option>
                                                </select>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th scope="row">Adiantamento de saldo</th>
                                            <td class="text-center"><input type="text" id="clientbalanceusage" class="form-control input-align-right" name="clientbalanceusage" value="{{ covertFloat2Br($spsinfos->clientbalanceusage) }}"></td>
                                            <td class="text-center">
                                                <select name="clientbalanceusagepercentage" class="form-control">
                                                    <option value="1" {{ ($spsinfos->clientbalanceusagepercentage=='1')?'selected':'' }}>Percentual</option>
                                                    <option value="0" {{ ($spsinfos->clientbalanceusagepercentage=='0')?'selected':'' }}>Valor fixo</option>
                                                </select>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>

                            </div>
                        </div>
       				
	                    <br>
	                    <hr>
	                    <br>
	                    <div class="text-center">
                            <button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light" data-toggle="modal" data-target="#editainfo">Salvar alterações</button>
                        </div>


                        </form> 
					</div>
				</div>
			</div>
		</div>
	</div>

</div>


@endsection

@section('inlinejs')
    <script type="text/javascript">
        $(function() {
            $('#fitbankpayments, #fitbanktransfers, #fitbankbillets, #fitbankp2p, #clientpayments, #clienttransfers, #clientbillets, #clientbalanceusage, #clientbalanceusagedailycharge ').maskMoney({
                prefix:'', 
                allowNegative: false, 
                thousands:'.', 
                decimal:',', 
                affixesStay: false,
                allowZero: true,
                precision: 3
            });
        });

        var pickerOpt = {
            interval: 15,
            format: 'HH:i',
            formatSubmit: 'HH:i',
            hiddenName: true
        };

        $(document).ready(function(){
            $("#paymentstimelimit, #transferstimelimit, #billetstimelimit").pickatime(pickerOpt);
        });

    </script>
@endsection
