@extends('layouts.authenticated')

@section('extracss')
    <link rel="stylesheet" href="{{ asset('css/vendors/css/pickers/pickadate/pickadate.css') }}">
@endsection

@section('extrajs')
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.js') }}"></script>
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.date.js') }}"></script>
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.time.js') }}"></script>
    <script src="{{ asset('js/js/scripts/pickers/dateTime/pick-a-datetime.js') }}"></script>

@endsection

@section('content')
<div class="container">
    <div class="row justify-content-md-center">
        <div class="col-md-12 col-12 text-right">
            <h2>Adiantamento de Saldo</h2>
        </div>
    </div>
    <div class="row justify-content-md-center">
        <div class="col-md-12 col-12">
            <div class="card">
            <div class="card-body">
                <h3 class="text-center">Selecione os filtros</h3>

                <form class="form" onsubmit="validaForm()" method="POST">
                    @csrf
                <br>                    

                    <div class="form-body">
                        <div class="row">
                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Data início
                                </div>
                                <div class="col-md-8">
                                    <input type='text' id="datade" name="datade" class="form-control datepickerDe" placeholder="Data inicial" value="{{ ($filtros['datade']) }}" />
                                </div>
                            </div>
                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Data fim
                                </div>
                                <div class="col-md-8">
                                    <input type='text' id="dataate" name="dataate" class="form-control datepickerAte" placeholder="Data final" value="{{ ($filtros['dataate']) }}" />
                                </div>
                            </div>
                        </div> {{-- row --}}

                        <div class="row">
                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Cliente
                                </div>
                                <div class="col-md-8">
                                    <select name="client_id" class="form-control">
                                        <option value="">Selecione</option>
                                        @foreach($clients as $client)
                                            <option value="{{ $client->id }}" {{ ($filtros['filtroCliente'] == $client->id )?'selected':'' }}>{{ $client->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Situação
                                </div>
                                <div class="col-md-8">
                                    <select name="status" class="form-control">
                                        <option value="">Selecione</option>
                                        <option value="0" {{ ($filtros['filtroStatus'] == '0')?'selected':'' }}>Aberto</option>
                                        <option value="1" {{ ($filtros['filtroStatus'] == '1')?'selected':'' }}>Pago</option>
                                    </select>
                                </div>
                            </div>
                        </div>{{-- row --}}
                    </div> {{-- form-body --}}
                    <div class="col-12 text-right"><button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light">Filtrar</button></div>
                </form>
            </div>
            </div>
        </div>
    </div>

    <div class="row justify-content-md-center">
        <div class="col-md-12 col-12">    
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-7 text-right">Período: {{ ($filtros['datade']) }} a {{ ($filtros['dataate']) }}</div>
                    </div>
                </div>    
            </div>    
        </div>    
    </div> 

	<div class="row justify-content-md-center">
        <div class="col-md-12 col-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th class="text-left">
                                        Data
                                    </th>
                                    <th class="text-left">
                                        Cliente
                                    </th>
                                    <th class="text-center">
                                        Detalhes
                                    </th>
                                    <th class="text-center">
                                        Situação
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $totalsolicitado=0.0;?>
                                <?php $totaltarifa=0.0;?>
                                <?php $totaljuros=0.0;?>
                                @foreach($tlogs as $tlog)
                                    <tr>
                                        <th class="text-nowrap text-left" scope="row">{{ datetime2br($tlog->emission) }}</th>
                                        <td class="text-nowrap text-left">{{ $tlog->client }}</td>
                                        <td class="text-left">
                                            <b>Solicitado:</b> R$ {{ formatMoneyBr($tlog->requestedvalue) }} <br>
                                            <b>Tarifa:</b> R$ {{ formatMoneyBr($tlog->ratevalue) }} <br>
                                            <b>Dias:</b> {{ $tlog->daysused }} <br>
                                            <b>Juros atual:</b> R$ {{ formatMoneyBr($tlog->interestvalue) }} <br>
                                        </td>
                                        <td class="text-center">
                                            {!! ($tlog->paid == 0)?'<span class="text-danger">Aberto</span>':'<span class="text-success">Pago</span>' !!}
                                            <br>
                                            {!! ($tlog->paid==1)?'<small>'.datetime2databr($tlog->paymentdate).'</small>':'' !!}

                                        </td>
                                    </tr>
                                    <?php $totalsolicitado+=$tlog->requestedvalue;?>
                                    <?php $totaltarifa+=$tlog->ratevalue;?>
                                    <?php $totaljuros+=$tlog->interestvalue;?>
                                @endforeach
                                <tr class="table-tr-border-top">
                                    <td class="text-right" colspan="2"><strong>Total no período</strong></td>
                                    <td class="text-right">
                                        <b>Solicitado:</b> R$ {{ formatMoneyBr($totalsolicitado) }} <br>
                                        <b>Tarifa:</b> R$ {{ formatMoneyBr($totaltarifa) }} <br>
                                        <b>Juros atual:</b> R$ {{ formatMoneyBr($totaljuros) }} <br><br>

                                        <b>Tarifas + Juros:</b> R$ {{ formatMoneyBr($totaltarifa + $totaljuros) }}
                                    </td>
                                    <td class="text-center"></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('inlinejs')
    <script type="text/javascript">
        var pickerOpt = {
            monthsFull: ['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'],
            monthsShort: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'],
            weekdaysFull: ['Domingo', 'Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta', 'Sábado'],
            weekdaysShort: ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sab'],
            today: 'Hoje',
            clear: 'Limpar',
            close: 'Fechar',
            labelMonthNext: 'Mês seg.',
            labelMonthPrev: 'Mês ant.',
            labelMonthSelect: 'Selecione um mês',
            labelYearSelect: 'Selecione um ano',
            format: 'dd/mm/yyyy',
            // formatSubmit: 'yyyy/mm/dd',
        };

        $('.datepickerDe').pickadate(pickerOpt);
        $('.datepickerAte').pickadate(pickerOpt);

        
        function validaForm() {
            var dataDe = document.getElementById('datade').value;
            var filtrode = new Date(dataDe);
            var dataAte = document.getElementById('dataate').value;
            var filtroate = new Date(dataAte);
            
            if(document.getElementById('datade').value == '' || document.getElementById('datade').value == '') {
                alert('Preencha as datas para filtrar.');
                return false;
            }

            if ( filtrode > filtroate ) { 
                alert('A data final não pode ser menor que a inicial.');
                return false;
            }
            return true;
        }
    </script>
@endsection

